/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.probav;

import org.esa.s3tbx.idepix.core.IdepixConstants;
import org.esa.s3tbx.idepix.core.pixel.AbstractPixelProperties;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.math.MathUtils;

public class ProbaVAlgorithm
extends AbstractPixelProperties {
    static final float LAND_THRESH = 0.9f;
    static final float WATER_THRESH = 0.9f;
    private static final float BRIGHTWHITE_THRESH = 0.65f;
    private static final float PRESSURE_THRESH = 0.9f;
    private static final float UNCERTAINTY_VALUE = 0.5f;
    private static final float BRIGHT_THRESH = 0.3f;
    private static final float WHITE_THRESH = 0.5f;
    private static final float BRIGHT_FOR_WHITE_THRESH = 0.2f;
    private static final float NDVI_THRESH = 0.4f;
    private static final float REFL835_WATER_THRESH = 0.1f;
    private static final float REFL835_LAND_THRESH = 0.15f;
    private boolean l1bLand;
    private boolean processingLand;
    private boolean isBlueGood;
    private boolean isRedGood;
    private boolean isNirGood;
    private boolean isSwirGood;
    private double elevation;
    private double[] nnOutput;
    float[] refl;

    @Override
    public boolean isInvalid() {
        return !this.isBlueGood || !this.isRedGood || !this.isNirGood || !this.isSwirGood || !this.processingLand;
    }

    @Override
    public boolean isClearSnow() {
        return !this.isInvalid() && ((double)this.ndsiValue() > 0.4 && (double)this.refl[3] < 0.13 && (double)this.tc1Value() > 0.3 || (double)this.ndsiValue() > 0.7 && (double)this.tc1Value() > 0.5) && this.elevation > 650.0;
    }

    @Override
    public boolean isCloud() {
        return !this.isInvalid() && (this.isGeneralCloud() || this.isHaze() || this.isComplexHaze() || this.isBorderCloud());
    }

    @Override
    public boolean isSeaIce() {
        return false;
    }

    @Override
    public boolean isBrightWhite() {
        return !this.isInvalid() && this.whiteValue() + this.brightValue() > this.getBrightWhiteThreshold();
    }

    @Override
    public boolean isGlintRisk() {
        return false;
    }

    @Override
    public boolean isClearLand() {
        float landValue;
        if (this.isInvalid()) {
            return false;
        }
        if (!MathUtils.equalValues((float)this.radiometricLandValue(), (float)0.5f)) {
            landValue = this.radiometricLandValue();
        } else if (this.aPrioriLandValue() > 0.5f) {
            landValue = this.aPrioriLandValue();
        } else {
            return false;
        }
        return !this.isWater && !this.isCloud() && landValue > 0.9f;
    }

    @Override
    public boolean isClearWater() {
        float waterValue;
        if (this.isInvalid()) {
            return false;
        }
        if (!MathUtils.equalValues((float)this.radiometricWaterValue(), (float)0.5f)) {
            waterValue = this.radiometricWaterValue();
        } else if (this.aPrioriWaterValue() > 0.5f) {
            waterValue = this.aPrioriWaterValue();
        } else {
            return false;
        }
        return this.isWater && !this.isCloud() && waterValue > 0.9f;
    }

    @Override
    public boolean isBright() {
        return !this.isInvalid() && this.brightValue() > this.getBrightThreshold();
    }

    @Override
    public boolean isWhite() {
        return !this.isInvalid() && this.whiteValue() > this.getWhiteThreshold();
    }

    @Override
    public boolean isLand() {
        boolean isLand1 = !this.usel1bLandWaterFlag && !this.isWater;
        return !this.isInvalid() && (isLand1 || this.aPrioriLandValue() > 0.9f);
    }

    @Override
    public boolean isL1Water() {
        return !this.isInvalid() && this.aPrioriWaterValue() > 0.9f;
    }

    @Override
    public boolean isVegRisk() {
        return !this.isInvalid() && this.ndviValue() > this.getNdviThreshold();
    }

    @Override
    public boolean isHigh() {
        return !this.isInvalid() && this.pressureValue() > this.getPressureThreshold();
    }

    public float brightValue() {
        double value = (this.refl[0] + this.refl[1]) / 2.0f;
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float temperatureValue() {
        return 0.5f;
    }

    public float spectralFlatnessValue() {
        double slope0 = IdepixUtils.spectralSlope(this.refl[0], this.refl[1], IdepixConstants.PROBAV_WAVELENGTHS[0], IdepixConstants.PROBAV_WAVELENGTHS[1]);
        double slope1 = IdepixUtils.spectralSlope(this.refl[1], this.refl[2], IdepixConstants.PROBAV_WAVELENGTHS[1], IdepixConstants.PROBAV_WAVELENGTHS[2]);
        double flatness = 1.0 - Math.abs(2000.0 * (slope0 + slope1) / 2.0);
        return (float)Math.max(0.0, flatness);
    }

    public float whiteValue() {
        if (this.brightValue() > 0.2f) {
            return this.spectralFlatnessValue();
        }
        return 0.0f;
    }

    public float ndsiValue() {
        double value = (this.refl[1] - this.refl[3]) / (this.refl[1] + this.refl[3]);
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float ndviValue() {
        double value = (this.refl[2] - this.refl[1]) / (this.refl[2] + this.refl[1]);
        value = Math.min(value, 1.0);
        value = Math.max(value, 0.0);
        return (float)value;
    }

    public float pressureValue() {
        return 0.5f;
    }

    public float glintRiskValue() {
        return IdepixUtils.spectralSlope(this.refl[0], this.refl[1], IdepixConstants.PROBAV_WAVELENGTHS[0], IdepixConstants.PROBAV_WAVELENGTHS[1]);
    }

    public float aPrioriLandValue() {
        if (this.isInvalid()) {
            return 0.5f;
        }
        if (this.l1bLand) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float aPrioriWaterValue() {
        if (this.isInvalid()) {
            return 0.5f;
        }
        if (!this.l1bLand) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float radiometricLandValue() {
        if (this.isInvalid() || this.isCloud()) {
            return 0.5f;
        }
        if (this.refl[2] > this.refl[1] && this.refl[2] > 0.15f) {
            return 1.0f;
        }
        if (this.refl[2] > 0.15f) {
            return 0.75f;
        }
        return 0.25f;
    }

    public float radiometricWaterValue() {
        if (this.isInvalid() || this.isCloud()) {
            return 0.5f;
        }
        if (this.refl[0] > this.refl[1] && this.refl[1] > this.refl[2] && this.refl[2] < 0.1f) {
            return 1.0f;
        }
        return 0.25f;
    }

    public float getBrightWhiteThreshold() {
        return 0.65f;
    }

    public float getNdviThreshold() {
        return 0.4f;
    }

    public float getBrightThreshold() {
        return 0.3f;
    }

    public float getWhiteThreshold() {
        return 0.5f;
    }

    public float getPressureThreshold() {
        return 0.9f;
    }

    public boolean isGeneralCloud() {
        return !this.isInvalid() && (double)this.tcSlope1Value() < -0.2 && !(this.tcSlope2Value() < 0.0f) && !this.isClearSnow();
    }

    public boolean isHaze() {
        return !this.isInvalid() && (double)this.tcSlope1Value() < -0.07 && !((double)this.tcSlope2Value() < -0.01) && (double)this.tc1Value() > 0.3 && (double)this.refl[0] > 0.21 && !this.isClearSnow() && !this.isGeneralCloud();
    }

    public boolean isComplexHaze() {
        return !this.isInvalid() && (double)this.bnDiffValue() > -0.192 && (double)this.bnDiffValue() < 0.1 && (double)this.tc1Value() > 0.42 && (double)this.nswirDiffValue() < 0.03 && this.refl[2] - this.refl[1] > this.refl[1] - this.refl[0] && (double)this.refl[0] > 0.194 && !this.isClearSnow() && !this.isGeneralCloud() && !this.isHaze();
    }

    public boolean isBorderCloud() {
        return !this.isInvalid() && this.refl[1] - this.refl[0] > 0.0f && this.refl[2] - this.refl[1] > 0.0f && this.refl[3] - this.refl[2] > 0.0f && (double)this.refl[0] > 0.25 && (double)(this.refl[1] - this.refl[0] + (this.refl[2] - this.refl[1]) + (this.refl[3] - this.refl[2])) < 0.326 && !this.isClearSnow() && !this.isGeneralCloud() && !this.isHaze() && !this.isComplexHaze();
    }

    public float tc1Value() {
        double value = 0.332 * (double)this.refl[0] + 0.603 * (double)this.refl[1] + 0.676 * (double)this.refl[2] + 0.263 * (double)this.refl[3];
        return (float)value;
    }

    public float tcSlope1Value() {
        double value = 0.016 * (double)this.refl[0] + 0.428 * (double)this.refl[1] - 0.452 * (double)this.refl[2] + 0.882 * (double)this.refl[3] - (0.9 * (double)this.refl[0] + 0.428 * (double)this.refl[1] + 0.0759 * (double)this.refl[2] - 0.041 * (double)this.refl[3]);
        return (float)value;
    }

    public float tcSlope2Value() {
        double value = 0.9 * (double)this.refl[0] + 0.428 * (double)this.refl[1] + 0.0759 * (double)this.refl[2] - 0.041 * (double)this.refl[3] - (0.283 * (double)this.refl[0] - 0.66 * (double)this.refl[1] + 0.577 * (double)this.refl[2] + 0.388 * (double)this.refl[3]);
        return (float)value;
    }

    public float bnDiffValue() {
        double value = (this.refl[0] - this.refl[2]) / (this.refl[0] + this.refl[2]);
        return (float)value;
    }

    public float nswirDiffValue() {
        double value = (this.refl[2] - this.refl[3]) / (this.refl[2] + this.refl[3]);
        return (float)value;
    }

    public void setL1bLand(boolean l1bLand) {
        this.l1bLand = l1bLand;
    }

    public void setProcessingLand(boolean processingLand) {
        this.processingLand = processingLand;
    }

    public void setIsBlueGood(boolean isBlueGood) {
        this.isBlueGood = isBlueGood;
    }

    public void setIsRedGood(boolean isRedGood) {
        this.isRedGood = isRedGood;
    }

    public void setIsNirGood(boolean isNirGood) {
        this.isNirGood = isNirGood;
    }

    public void setIsSwirGood(boolean isSwirGood) {
        this.isSwirGood = isSwirGood;
    }

    public void setRefl(float[] refl) {
        if (refl.length != IdepixConstants.PROBAV_WAVELENGTHS.length) {
            throw new OperatorException("PROBA-V pixel processing: Invalid number of wavelengths [" + refl.length + "] - must be " + IdepixConstants.PROBAV_WAVELENGTHS.length);
        }
        this.refl = refl;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }

    public double[] getNnOutput() {
        return this.nnOutput;
    }
}

