/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olcislstr;

import com.bc.ceres.binding.ValueRange;

public class OlciSlstrCloudNNInterpreter {
    private static final ValueRange CLEAR_SNOW_ICE_BOUNDS = new ValueRange(0.0, 1.7, true, false);
    private static final ValueRange OPAQUE_CLOUD_BOUNDS = new ValueRange(1.7, 2.5, true, false);
    private static final ValueRange SEMI_TRANS_CLOUD_BOUNDS = new ValueRange(2.5, 3.46, true, false);
    private static final ValueRange SPATIAL_MIXED_CLOUD_BOUNDS = new ValueRange(3.46, 4.54, true, false);
    private static final ValueRange CLEAR_LAND_BOUNDS = new ValueRange(4.54, 5.46, true, false);
    private static final ValueRange CLEAR_WATER_BOUNDS = new ValueRange(5.46, 6.0, true, false);

    private OlciSlstrCloudNNInterpreter() {
    }

    public static OlciSlstrCloudNNInterpreter create() {
        return new OlciSlstrCloudNNInterpreter();
    }

    boolean isCloudAmbiguous(double nnValue, boolean isLand, boolean considerGlint) {
        return SEMI_TRANS_CLOUD_BOUNDS.contains(nnValue) || SPATIAL_MIXED_CLOUD_BOUNDS.contains(nnValue);
    }

    boolean isCloudSure(double nnValue) {
        return OPAQUE_CLOUD_BOUNDS.contains(nnValue);
    }

    boolean isSnowIce(double nnValue) {
        return CLEAR_SNOW_ICE_BOUNDS.contains(nnValue);
    }
}

