/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olci;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.olci.OlciClassificationOp;
import org.esa.s3tbx.idepix.algorithms.olci.OlciPostProcessOp;
import org.esa.s3tbx.idepix.algorithms.olci.OlciUtils;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.operators.BasisOp;
import org.esa.s3tbx.idepix.operators.IdepixProducts;
import org.esa.s3tbx.processor.rad2refl.Sensor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Sentinel3.Olci", category="Optical/Pre-Processing", version="1.0", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for OLCI.")
public class OlciOp
extends BasisOp {
    @SourceProduct(alias="sourceProduct", label="OLCI L1b product", description="The OLCI L1b source product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private boolean outputRadiance;
    private boolean outputRad2Refl;
    @Parameter(description="The list of radiance bands to write to target product.", label="Select TOA radiances to write to the target product", valueSet={"Oa01_radiance", "Oa02_radiance", "Oa03_radiance", "Oa04_radiance", "Oa05_radiance", "Oa06_radiance", "Oa07_radiance", "Oa08_radiance", "Oa09_radiance", "Oa10_radiance", "Oa11_radiance", "Oa12_radiance", "Oa13_radiance", "Oa14_radiance", "Oa15_radiance", "Oa16_radiance", "Oa17_radiance", "Oa18_radiance", "Oa19_radiance", "Oa20_radiance", "Oa21_radiance"}, defaultValue="")
    private String[] radianceBandsToCopy;
    @Parameter(description="The list of reflectance bands to write to target product.", label="Select TOA reflectances to write to the target product", valueSet={"Oa01_reflectance", "Oa02_reflectance", "Oa03_reflectance", "Oa04_reflectance", "Oa05_reflectance", "Oa06_reflectance", "Oa07_reflectance", "Oa08_reflectance", "Oa09_reflectance", "Oa10_reflectance", "Oa11_reflectance", "Oa12_reflectance", "Oa13_reflectance", "Oa14_reflectance", "Oa15_reflectance", "Oa16_reflectance", "Oa17_reflectance", "Oa18_reflectance", "Oa19_reflectance", "Oa20_reflectance", "Oa21_reflectance"}, defaultValue="")
    private String[] reflBandsToCopy;
    @Parameter(defaultValue="false", label=" Write NN value to the target product", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="true", label=" Use SRTM Land/Water mask", description="If selected, SRTM Land/Water mask is used instead of L1b land flag. Slower, but in general more precise.")
    private boolean useSrtmLandWaterMask;
    private Product classificationProduct;
    private Product postProcessingProduct;
    private Product rad2reflProduct;
    private Product waterMaskProduct;
    private Map<String, Product> classificationInputProducts;
    private Map<String, Object> classificationParameters;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.OLCI);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.outputRadiance = this.radianceBandsToCopy != null && this.radianceBandsToCopy.length > 0;
        this.outputRad2Refl = this.reflBandsToCopy != null && this.reflBandsToCopy.length > 0;
        this.preProcess();
        this.setClassificationInputProducts();
        this.computeCloudProduct();
        Product olciIdepixProduct = this.classificationProduct;
        olciIdepixProduct.setName(this.sourceProduct.getName() + "_IDEPIX");
        olciIdepixProduct.setAutoGrouping("Oa*_radiance:Oa*_reflectance");
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)olciIdepixProduct, (boolean)true);
        if (this.computeCloudBuffer) {
            this.postProcess(olciIdepixProduct);
        }
        this.targetProduct = this.createTargetProduct(olciIdepixProduct);
        this.targetProduct.setAutoGrouping(olciIdepixProduct.getAutoGrouping());
        if (this.postProcessingProduct != null) {
            Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
            cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
        }
    }

    private Product createTargetProduct(Product idepixProduct) {
        Product targetProduct = new Product(idepixProduct.getName(), idepixProduct.getProductType(), idepixProduct.getSceneRasterWidth(), idepixProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyFlagCodings((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)idepixProduct, (Product)targetProduct, (boolean)true);
        ProductUtils.copyMasks((Product)idepixProduct, (Product)targetProduct);
        ProductUtils.copyTiePointGrids((Product)idepixProduct, (Product)targetProduct);
        targetProduct.setStartTime(idepixProduct.getStartTime());
        targetProduct.setEndTime(idepixProduct.getEndTime());
        OlciUtils.setupOlciClassifBitmask(targetProduct);
        if (this.outputRadiance) {
            IdepixIO.addRadianceBands(this.sourceProduct, targetProduct, this.radianceBandsToCopy);
        }
        if (this.outputRad2Refl) {
            IdepixIO.addOlciRadiance2ReflectanceBands(this.rad2reflProduct, targetProduct, this.reflBandsToCopy);
        }
        if (this.outputSchillerNNValue) {
            ProductUtils.copyBand((String)"nn_value", (Product)idepixProduct, (Product)targetProduct, (boolean)true);
        }
        return targetProduct;
    }

    private void preProcess() {
        this.rad2reflProduct = IdepixProducts.computeRadiance2ReflectanceProduct(this.sourceProduct, Sensor.OLCI);
        if (this.useSrtmLandWaterMask) {
            HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
            waterMaskParameters.put("resolution", 50);
            waterMaskParameters.put("subSamplingFactorX", 3);
            waterMaskParameters.put("subSamplingFactorY", 3);
            this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
        }
    }

    private void setClassificationParameters() {
        this.classificationParameters = new HashMap<String, Object>();
        this.classificationParameters.put("copyAllTiePoints", true);
        this.classificationParameters.put("outputSchillerNNValue", this.outputSchillerNNValue);
        this.classificationParameters.put("useSrtmLandWaterMask", this.useSrtmLandWaterMask);
    }

    private void computeCloudProduct() {
        this.setClassificationParameters();
        this.classificationProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(OlciClassificationOp.class), this.classificationParameters, this.classificationInputProducts);
    }

    private void setClassificationInputProducts() {
        this.classificationInputProducts = new HashMap<String, Product>();
        this.classificationInputProducts.put("l1b", this.sourceProduct);
        this.classificationInputProducts.put("rhotoa", this.rad2reflProduct);
        this.classificationInputProducts.put("waterMask", this.waterMaskProduct);
    }

    private void postProcess(Product olciIdepixProduct) {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("l1b", this.sourceProduct);
        input.put("olciCloud", olciIdepixProduct);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("computeCloudBuffer", Boolean.valueOf(this.computeCloudBuffer));
        params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
        this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(OlciPostProcessOp.class), params, input);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OlciOp.class);
        }
    }
}

