/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.olci;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.olci.OlciCloudNNInterpreter;
import org.esa.s3tbx.idepix.algorithms.olci.OlciUtils;
import org.esa.s3tbx.idepix.core.seaice.SeaIceClassification;
import org.esa.s3tbx.idepix.core.seaice.SeaIceClassifier;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.IdepixUtils;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Olci.Classification", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix land pixel classification operator for OLCI.")
public class OlciClassificationOp
extends Operator {
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write Schiller NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="false", description="Check for sea/lake ice also outside Sea Ice Climatology area.", label="Check for sea/lake ice also outside Sea Ice Climatology area")
    private boolean ignoreSeaIceClimatology;
    @Parameter(defaultValue="true", label=" Use SRTM Land/Water mask", description="If selected, SRTM Land/Water mask is used instead of L1b land flag. Slower, but in general more precise.")
    private boolean useSrtmLandWaterMask;
    @SourceProduct(alias="l1b", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="rhotoa")
    private Product rad2reflProduct;
    @SourceProduct(alias="waterMask", optional=true)
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    private Band[] olciReflBands;
    private Band landWaterBand;
    private static final String OLCI_ALL_NET_NAME = "11x10x4x3x2_207.9.net";
    private static final double THRESH_LAND_MINBRIGHT1 = 0.3;
    private static final double THRESH_LAND_MINBRIGHT2 = 0.25;
    private static final double THRESH_WATER_MINBRIGHT1 = 0.2;
    private static final double THRESH_WATER_MINBRIGHT2 = 0.08;
    private ThreadLocal<SchillerNeuralNetWrapper> olciAllNeuralNet;
    private OlciCloudNNInterpreter nnInterpreter;
    private SeaIceClassifier seaIceClassifier;
    private static final double SEA_ICE_CLIM_THRESHOLD = 10.0;

    public void initialize() throws OperatorException {
        this.setBands();
        this.nnInterpreter = OlciCloudNNInterpreter.create();
        this.readSchillerNeuralNets();
        this.createTargetProduct();
        this.initSeaIceClassifier();
        if (this.waterMaskProduct != null && this.useSrtmLandWaterMask) {
            this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
        }
    }

    private void readSchillerNeuralNets() {
        InputStream olciAllIS = ((Object)((Object)this)).getClass().getResourceAsStream(OLCI_ALL_NET_NAME);
        this.olciAllNeuralNet = SchillerNeuralNetWrapper.create(olciAllIS);
    }

    private void initSeaIceClassifier() {
        ProductData.UTC startTime = this.getSourceProduct().getStartTime();
        int monthIndex = startTime.getAsCalendar().get(2);
        try {
            this.seaIceClassifier = new SeaIceClassifier(monthIndex + 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setBands() {
        this.olciReflBands = new Band[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (int i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            int suffixStart = Rad2ReflConstants.OLCI_REFL_BAND_NAMES[i].indexOf("_");
            String reflBandname = Rad2ReflConstants.OLCI_REFL_BAND_NAMES[i].substring(0, suffixStart);
            this.olciReflBands[i] = this.rad2reflProduct.getBand(reflBandname + "_reflectance");
        }
    }

    private void createTargetProduct() throws OperatorException {
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        Band cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 11);
        FlagCoding flagCoding = OlciUtils.createOlciFlagCoding("pixel_classif_flags");
        cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.outputSchillerNNValue) {
            this.targetProduct.addBand("nn_value", 30);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Tile waterFractionTile = null;
        if (this.landWaterBand != null) {
            waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        }
        Band olciQualityFlagBand = this.sourceProduct.getBand("quality_flags");
        Tile olciQualityFlagTile = this.getSourceTile((RasterDataNode)olciQualityFlagBand, rectangle);
        Tile[] olciReflectanceTiles = new Tile[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (int i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            olciReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.olciReflBands[i], rectangle);
        }
        Band cloudFlagTargetBand = this.targetProduct.getBand("pixel_classif_flags");
        Tile cloudFlagTargetTile = targetTiles.get(cloudFlagTargetBand);
        Tile nnTargetTile = null;
        if (this.outputSchillerNNValue) {
            nnTargetTile = targetTiles.get(this.targetProduct.getBand("nn_value"));
        }
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    int waterFraction = -1;
                    if (waterFractionTile != null) {
                        waterFraction = waterFractionTile.getSampleInt(x, y);
                    }
                    this.initCloudFlag(olciQualityFlagTile, targetTiles.get(cloudFlagTargetBand), olciReflectanceTiles, y, x);
                    boolean isBright = olciQualityFlagTile.getSampleBit(x, y, 27);
                    cloudFlagTargetTile.setSample(x, y, 7, isBright);
                    if (this.isOlciLandPixel(x, y, olciQualityFlagTile, waterFraction)) {
                        this.classifyOverLand(olciReflectanceTiles, cloudFlagTargetTile, nnTargetTile, y, x);
                        continue;
                    }
                    this.classifyOverWater(olciQualityFlagTile, olciReflectanceTiles, cloudFlagTargetTile, nnTargetTile, y, x, waterFraction);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide GA cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private void classifyOverWater(Tile olciQualityFlagTile, Tile[] olciReflectanceTiles, Tile cloudFlagTargetTile, Tile nnTargetTile, int y, int x, int waterFraction) {
        this.classifyCloud(x, y, olciQualityFlagTile, olciReflectanceTiles, cloudFlagTargetTile, waterFraction);
        if (this.outputSchillerNNValue) {
            double[] nnOutput = this.getOlciNNOutput(x, y, olciReflectanceTiles);
            nnTargetTile.setSample(x, y, nnOutput[0]);
        }
    }

    private void classifyOverLand(Tile[] olciReflectanceTiles, Tile cloudFlagTargetTile, Tile nnTargetTile, int y, int x) {
        float[] olciReflectances = new float[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (int i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            olciReflectances[i] = olciReflectanceTiles[i].getSampleFloat(x, y);
        }
        SchillerNeuralNetWrapper nnWrapper = this.olciAllNeuralNet.get();
        double[] inputVector = nnWrapper.getInputVector();
        for (int i = 0; i < inputVector.length; ++i) {
            inputVector[i] = Math.sqrt(olciReflectances[i]);
        }
        double nnOutput = nnWrapper.getNeuralNet().calc(inputVector)[0];
        if (!cloudFlagTargetTile.getSampleBit(x, y, 0)) {
            cloudFlagTargetTile.setSample(x, y, 2, false);
            cloudFlagTargetTile.setSample(x, y, 3, false);
            cloudFlagTargetTile.setSample(x, y, 1, false);
            cloudFlagTargetTile.setSample(x, y, 6, false);
            boolean cloudSure = (double)olciReflectances[2] > 0.3 && this.nnInterpreter.isCloudSure(nnOutput);
            boolean cloudAmbiguous = (double)olciReflectances[2] > 0.25 && this.nnInterpreter.isCloudAmbiguous(nnOutput, true, false);
            cloudFlagTargetTile.setSample(x, y, 2, cloudAmbiguous);
            cloudFlagTargetTile.setSample(x, y, 3, cloudSure);
            cloudFlagTargetTile.setSample(x, y, 1, cloudAmbiguous || cloudSure);
            cloudFlagTargetTile.setSample(x, y, 6, this.nnInterpreter.isSnowIce(nnOutput));
            cloudFlagTargetTile.setSample(x, y, 10, true);
        }
        if (nnTargetTile != null) {
            nnTargetTile.setSample(x, y, nnOutput);
        }
    }

    private boolean isOlciLandPixel(int x, int y, Tile olciL1bFlagTile, int waterFraction) {
        if (waterFraction < 0) {
            return olciL1bFlagTile.getSampleBit(x, y, 31);
        }
        if (IdepixUtils.getGeoPos((GeoCoding)this.getSourceProduct().getSceneGeoCoding(), (int)x, (int)y).lat > -58.0) {
            if (waterFraction <= 100) {
                return waterFraction == 0;
            }
            return olciL1bFlagTile.getSampleBit(x, y, 31);
        }
        return olciL1bFlagTile.getSampleBit(x, y, 31);
    }

    private void classifyCloud(int x, int y, Tile l1FlagsTile, Tile[] rhoToaTiles, Tile targetTile, int waterFraction) {
        boolean isCoastline = waterFraction < 0 ? l1FlagsTile.getSampleBit(x, y, 30) : this.isCoastlinePixel(x, y, waterFraction);
        targetTile.setSample(x, y, 9, isCoastline);
        boolean checkForSeaIce = false;
        if (!isCoastline) {
            GeoPos geoPos = IdepixUtils.getGeoPos(this.getSourceProduct().getSceneGeoCoding(), x, y);
            checkForSeaIce = this.ignoreSeaIceClimatology || this.isPixelClassifiedAsSeaice(geoPos);
        }
        double nnOutput = this.getOlciNNOutput(x, y, rhoToaTiles)[0];
        if (!targetTile.getSampleBit(x, y, 0)) {
            targetTile.setSample(x, y, 2, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 6, false);
            targetTile.setSample(x, y, 10, false);
            boolean isGlint = this.isGlintPixel(x, y, l1FlagsTile);
            boolean cloudSure = (double)rhoToaTiles[16].getSampleFloat(x, y) > 0.2 && this.nnInterpreter.isCloudSure(nnOutput);
            boolean cloudAmbiguous = (double)rhoToaTiles[16].getSampleFloat(x, y) > 0.08 && this.nnInterpreter.isCloudAmbiguous(nnOutput, false, isGlint);
            targetTile.setSample(x, y, 2, cloudAmbiguous);
            targetTile.setSample(x, y, 3, cloudSure);
            targetTile.setSample(x, y, 1, cloudAmbiguous || cloudSure);
            if (checkForSeaIce && this.nnInterpreter.isSnowIce(nnOutput)) {
                targetTile.setSample(x, y, 6, true);
                targetTile.setSample(x, y, 3, false);
                targetTile.setSample(x, y, 1, false);
            }
        }
    }

    private double[] getOlciNNOutput(int x, int y, Tile[] rhoToaTiles) {
        SchillerNeuralNetWrapper nnWrapper = this.olciAllNeuralNet.get();
        double[] nnInput = nnWrapper.getInputVector();
        for (int i = 0; i < nnInput.length; ++i) {
            nnInput[i] = Math.sqrt(rhoToaTiles[i].getSampleFloat(x, y));
        }
        return nnWrapper.getNeuralNet().calc(nnInput);
    }

    private boolean isPixelClassifiedAsSeaice(GeoPos geoPos) {
        double maxLon = 360.0;
        double minLon = 0.0;
        double maxLat = 180.0;
        double minLat = 0.0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                double lon = geoPos.lon + 180.0 + (double)x * 1.0;
                double lat = 90.0 - geoPos.lat + (double)y * 1.0;
                lon = Math.max(lon, 0.0);
                lon = Math.min(lon, 360.0);
                lat = Math.max(lat, 0.0);
                lat = Math.min(lat, 180.0);
                SeaIceClassification classification = this.seaIceClassifier.getClassification(lat, lon);
                if (!(classification.max >= 10.0)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCoastlinePixel(int x, int y, int waterFraction) {
        return IdepixUtils.getGeoPos((GeoCoding)this.getSourceProduct().getSceneGeoCoding(), (int)x, (int)y).lat > -58.0 && waterFraction <= 100 && waterFraction < 100 && waterFraction > 0;
    }

    private boolean isGlintPixel(int x, int y, Tile l1FlagsTile) {
        return l1FlagsTile.getSampleBit(x, y, 22);
    }

    private void initCloudFlag(Tile olciL1bFlagTile, Tile targetTile, Tile[] olciReflectanceTiles, int y, int x) {
        float[] olciReflectances = new float[Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length];
        for (int i = 0; i < Rad2ReflConstants.OLCI_REFL_BAND_NAMES.length; ++i) {
            olciReflectances[i] = olciReflectanceTiles[i].getSampleFloat(x, y);
        }
        boolean l1Invalid = olciL1bFlagTile.getSampleBit(x, y, 25);
        boolean reflectancesValid = IdepixIO.areAllReflectancesValid(olciReflectances);
        targetTile.setSample(x, y, 0, l1Invalid || !reflectancesValid);
        targetTile.setSample(x, y, 1, false);
        targetTile.setSample(x, y, 3, false);
        targetTile.setSample(x, y, 2, false);
        targetTile.setSample(x, y, 6, false);
        targetTile.setSample(x, y, 4, false);
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 9, false);
        targetTile.setSample(x, y, 10, false);
        targetTile.setSample(x, y, 7, false);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OlciClassificationOp.class);
        }
    }
}

