/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.modis;

import java.awt.Color;
import java.util.Random;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.BitSetter;

public class ModisUtils {
    public static FlagCoding createModisFlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding(flagId);
        flagCoding.addFlag("IDEPIX_MIXED_PIXEL", BitSetter.setFlag((int)0, (int)11), "Mixed pixel");
        flagCoding.addFlag("IDEPIX_CLOUD_B_NIR", BitSetter.setFlag((int)0, (int)12), "Cloudy pixel (from 'b_nir test')");
        return flagCoding;
    }

    public static void setupModisClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_MIXED_PIXEL", (String)"Mixed pixel", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_MIXED_PIXEL", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_B_NIR", (String)"Cloudy pixel (from 'b_nir test')", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_B_NIR", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index, (ProductNode)mask);
    }
}

