/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.modis;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.algorithms.modis.ModisUtils;
import org.esa.s3tbx.idepix.operators.BasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Modis.Postprocess", version="2.2", copyright="(c) 2016 by Brockmann Consult", description="Refines the MODIS pixel classification.", internal=true)
public class ModisPostProcessOp
extends BasisOp {
    @SourceProduct(alias="refl", description="MODIS L1b reflectance product")
    private Product reflProduct;
    @SourceProduct(alias="classif", description="MODIS pixel classification product")
    private Product classifProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @Parameter(defaultValue="2", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Compute cloud shadow", description=" Compute cloud shadow with latest 'fronts' algorithm")
    private boolean computeCloudShadow;
    private RectangleExtender rectCalculator;
    private Band landWaterBand;

    public void initialize() throws OperatorException {
        this.createTargetProduct();
        this.rectCalculator = new RectangleExtender(new Rectangle(this.reflProduct.getSceneRasterWidth(), this.reflProduct.getSceneRasterHeight()), this.cloudBufferWidth, this.cloudBufferWidth);
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Band classifFlagSourceBand = this.classifProduct.getBand("pixel_classif_flags");
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle extendedRectangle = this.rectCalculator.extend(targetRectangle);
        Tile classifFlagSourceTile = this.getSourceTile((RasterDataNode)classifFlagSourceBand, extendedRectangle);
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, extendedRectangle);
        for (int y = extendedRectangle.y; y < extendedRectangle.y + extendedRectangle.height; ++y) {
            this.checkForCancellation();
            for (int x = extendedRectangle.x; x < extendedRectangle.x + extendedRectangle.width; ++x) {
                if (!targetRectangle.contains(x, y)) continue;
                boolean isCloud = classifFlagSourceTile.getSampleBit(x, y, 1);
                this.combineFlags(x, y, classifFlagSourceTile, targetTile);
                if (!(this.classifProduct.getSceneGeoCoding() instanceof TiePointGeoCoding) && !(this.classifProduct.getSceneGeoCoding() instanceof CrsGeoCoding) && this.isCoastline(x, y, classifFlagSourceTile, targetRectangle)) {
                    targetTile.setSample(x, y, 9, true);
                }
                if (this.isNearCoastline(x, y, targetTile, waterFractionTile, targetRectangle)) {
                    this.refineSnowIceFlaggingForCoastlines(x, y, classifFlagSourceTile, targetTile);
                    if (isCloud) {
                        this.refineCloudFlaggingForCoastlines(x, y, classifFlagSourceTile, waterFractionTile, targetTile, targetRectangle);
                    }
                }
                if (!isCloud) continue;
                this.computeCloudBuffer(x, y, classifFlagSourceTile, targetTile);
            }
        }
    }

    private boolean isCoastline(int x, int y, Tile sourceFlagTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        boolean isLandCenter = sourceFlagTile.getSampleBit(x, y, 10);
        if (isLandCenter) {
            int landCount = 0;
            int count = 0;
            for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean isCenter = i == x && j == y;
                    boolean isLand = sourceFlagTile.getSampleBit(i, j, 10);
                    if (!isCenter) {
                        ++count;
                    }
                    if (!isLand || isCenter) continue;
                    ++landCount;
                }
            }
            return count >= 4 && landCount >= Math.max(count - 6, 1) && landCount <= count - 3;
        }
        return false;
    }

    private boolean isNearCoastline(int x, int y, Tile sourceFlagTile, Tile waterFractionTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        if (!(this.classifProduct.getSceneGeoCoding() instanceof TiePointGeoCoding) && !(this.classifProduct.getSceneGeoCoding() instanceof CrsGeoCoding)) {
            int waterFractionCenter = waterFractionTile.getSampleInt(x, y);
            for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    if (!rectangle.contains(i, j) || waterFractionTile.getSampleInt(i, j) == waterFractionCenter) continue;
                    return true;
                }
            }
        } else {
            for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean isAlreadyCoastline;
                    if (!rectangle.contains(i, j) || !(isAlreadyCoastline = sourceFlagTile.getSampleBit(i, j, 9))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean refineCloudFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile waterFractionTile, Tile targetTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        boolean removeCloudFlag = true;
        if (this.isPixelSurrounded(x, y, sourceFlagTile, rectangle, 1)) {
            removeCloudFlag = false;
        } else {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            block0: for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean is_cloud = sourceFlagTile.getSampleBit(i, j, 1);
                    if (!is_cloud || !targetTileRectangle.contains(i, j) || this.isNearCoastline(i, j, sourceFlagTile, waterFractionTile, rectangle)) continue;
                    removeCloudFlag = false;
                    continue block0;
                }
            }
        }
        if (removeCloudFlag) {
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 2, false);
            boolean is_land = sourceFlagTile.getSampleBit(x, y, 10);
            targetTile.setSample(x, y, 11, !is_land);
        }
        return !removeCloudFlag;
    }

    private void refineSnowIceFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        boolean isSnowIce = sourceFlagTile.getSampleBit(x, y, 6);
        if (isSnowIce) {
            targetTile.setSample(x, y, 6, false);
        }
    }

    private boolean isPixelSurrounded(int x, int y, Tile sourceFlagTile, Rectangle targetRectangle, int pixelFlag) {
        int surroundingPixelCount = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                boolean is_flagged;
                if (!sourceFlagTile.getRectangle().contains(i, j) || !(is_flagged = sourceFlagTile.getSampleBit(i, j, pixelFlag)) || !targetRectangle.contains(i, j)) continue;
                ++surroundingPixelCount;
            }
        }
        return (double)surroundingPixelCount * 1.0 / 9.0 >= 0.7;
    }

    private void createTargetProduct() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.classifProduct, this.classifProduct.getName(), this.classifProduct.getProductType());
        ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.classifProduct, (Product)this.targetProduct, (boolean)false);
        ProductUtils.copyFlagBands((Product)this.reflProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyFlagCodings((Product)this.reflProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.classifProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.reflProduct, (Product)this.targetProduct);
        ModisUtils.setupModisClassifBitmask(this.targetProduct);
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    private void computeCloudBuffer(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        Rectangle rectangle = targetTile.getRectangle();
        int LEFT_BORDER = Math.max(x - this.cloudBufferWidth, rectangle.x);
        int RIGHT_BORDER = Math.min(x + this.cloudBufferWidth, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - this.cloudBufferWidth, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + this.cloudBufferWidth, rectangle.y + rectangle.height - 1);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                boolean is_already_cloud = sourceFlagTile.getSampleBit(i, j, 1);
                if (is_already_cloud || !rectangle.contains(i, j)) continue;
                targetTile.setSample(i, j, 4, true);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ModisPostProcessOp.class);
        }
    }
}

