/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.modis;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.modis.ModisClassificationOp;
import org.esa.s3tbx.idepix.algorithms.modis.ModisPostProcessOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.operators.BasisOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.TerraAqua.Modis", category="Optical/Pre-Processing", version="2.2", authors="Olaf Danne, Marco Zuehlke", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for MODIS.")
public class ModisOp
extends BasisOp {
    @Parameter(defaultValue="CLOUD_CONSERVATIVE", valueSet={"CLEAR_SKY_CONSERVATIVE", "CLOUD_CONSERVATIVE"}, label=" Strength of cloud flagging", description="Strength of cloud flagging. In case of 'CLOUD_CONSERVATIVE', more pixels might be flagged as cloud.")
    private String cloudFlaggingStrength;
    @Parameter(defaultValue="1", label=" Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="150", valueSet={"1000", "150", "50"}, label=" Resolution of land-water mask (m/pixel)", description="Resolution of used land-water mask in meters per pixel")
    private int waterMaskResolution;
    @Parameter(defaultValue="false", label=" Write reflective solar bands", description="Write TOA reflective solar bands (RefSB) to target product.")
    private boolean outputRad2Refl = false;
    @Parameter(defaultValue="false", description="Write CAWA RefSB (bands 2, 5, 17-19) to the target product.", label=" Write CAWA RefSB bands (experimental!)")
    private boolean outputCawaRefSB = false;
    @Parameter(defaultValue="false", label=" Write emissive bands", description="Write 'Emissive' bands to target product.")
    private boolean outputEmissive = false;
    @Parameter(defaultValue="1.035", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    double nnCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.35", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    double nnCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.2", label=" NN cloud sure/snow separation value", description=" NN cloud ambiguous cloud sure/snow separation value")
    double nnCloudSureSnowSeparationValue;
    private double bNirThresh859 = 0.08;
    private double glintThresh859forCloudSure = 0.15;
    private double glintThresh859forCloudAmbiguous = 0.06;
    private boolean applyBrightnessTest = true;
    private boolean applyOrLogicInCloudTest = true;
    private double brightnessThreshCloudAmbiguous = 0.125;
    @SourceProduct(alias="sourceProduct", label="Name (MODIS L1b product)", description="The source product.")
    private Product sourceProduct;
    private Product waterMaskProduct;
    private Product classifProduct;
    private Map<String, Object> waterClassificationParameters;

    public void initialize() throws OperatorException {
        this.applyOrLogicInCloudTest = this.cloudFlaggingStrength.equals("CLOUD_CONSERVATIVE");
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.MODIS);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.processModis();
    }

    private void processModis() {
        HashMap<String, Product> occciClassifInput = new HashMap<String, Product>(4);
        this.computeAlgorithmInputProducts(occciClassifInput);
        Map<String, Object> occciCloudClassificationParameters = this.createModisPixelClassificationParameters();
        HashMap<String, Integer> postProcessParameters = new HashMap<String, Integer>();
        postProcessParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        HashMap<String, Product> postProcessInput = new HashMap<String, Product>();
        postProcessInput.put("waterMask", this.waterMaskProduct);
        postProcessInput.put("refl", this.sourceProduct);
        this.classifProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ModisClassificationOp.class), occciCloudClassificationParameters, occciClassifInput);
        postProcessInput.put("classif", this.classifProduct);
        Product postProcessProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(ModisPostProcessOp.class), postProcessParameters, postProcessInput);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)postProcessProduct);
        this.setTargetProduct(postProcessProduct);
        this.addBandsToTargetProduct(postProcessProduct);
    }

    private void computeAlgorithmInputProducts(Map<String, Product> occciClassifInput) {
        this.createWaterMaskProduct();
        occciClassifInput.put("waterMask", this.waterMaskProduct);
        occciClassifInput.put("refl", this.sourceProduct);
    }

    private void createWaterMaskProduct() {
        HashMap<String, Integer> waterParameters = new HashMap<String, Integer>();
        waterParameters.put("resolution", this.waterMaskResolution);
        waterParameters.put("subSamplingFactorX", 3);
        waterParameters.put("subSamplingFactorY", 3);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterParameters, (Product)this.sourceProduct);
    }

    private Map<String, Object> createModisPixelClassificationParameters() {
        HashMap<String, Object> occciCloudClassificationParameters = new HashMap<String, Object>(1);
        occciCloudClassificationParameters.put("cloudBufferWidth", this.cloudBufferWidth);
        occciCloudClassificationParameters.put("wmResolution", this.waterMaskResolution);
        occciCloudClassificationParameters.put("applyBrightnessTest", this.applyBrightnessTest);
        occciCloudClassificationParameters.put("applyOrLogicInCloudTest", this.applyOrLogicInCloudTest);
        occciCloudClassificationParameters.put("nnCloudAmbiguousLowerBoundaryValue", this.nnCloudAmbiguousLowerBoundaryValue);
        occciCloudClassificationParameters.put("nnCloudAmbiguousSureSeparationValue", this.nnCloudAmbiguousSureSeparationValue);
        occciCloudClassificationParameters.put("nnCloudSureSnowSeparationValue", this.nnCloudSureSnowSeparationValue);
        occciCloudClassificationParameters.put("brightnessThreshCloudAmbiguous", this.brightnessThreshCloudAmbiguous);
        occciCloudClassificationParameters.put("glintThresh859forCloudSure", this.glintThresh859forCloudSure);
        occciCloudClassificationParameters.put("glintThresh859forCloudAmbiguous", this.glintThresh859forCloudAmbiguous);
        occciCloudClassificationParameters.put("bNirThresh859", this.bNirThresh859);
        return occciCloudClassificationParameters;
    }

    private void addBandsToTargetProduct(Product targetProduct) {
        if (this.outputCawaRefSB) {
            this.outputRad2Refl = false;
            this.outputEmissive = false;
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "EV_250_Aggr1km_RefSB_2");
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "EV_500_Aggr1km_RefSB_5");
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "EV_1KM_RefSB_17");
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "EV_1KM_RefSB_18");
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "EV_1KM_RefSB_19");
            for (int i = 0; i < this.sourceProduct.getNumTiePointGrids(); ++i) {
                TiePointGrid srcTPG = this.sourceProduct.getTiePointGridAt(i);
                if (!srcTPG.getName().contains("Zenith") && !srcTPG.getName().contains("Azimuth") || targetProduct.containsTiePointGrid(srcTPG.getName())) continue;
                targetProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
            }
        }
        if (this.outputRad2Refl) {
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "RefSB");
        }
        if (this.outputEmissive) {
            ModisOp.copySourceBands(this.sourceProduct, targetProduct, "Emissive");
        }
    }

    private static void copySourceBands(Product rad2reflProduct, Product targetProduct, String bandNameSubstring) {
        for (String bandname : rad2reflProduct.getBandNames()) {
            if (!bandname.contains(bandNameSubstring) || targetProduct.containsBand(bandname)) continue;
            ProductUtils.copyBand((String)bandname, (Product)rad2reflProduct, (Product)targetProduct, (boolean)true);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ModisOp.class);
        }
    }
}

