/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.modis;

public class ModisAlgorithm {
    private static final double THRESH_BRIGHT_SNOW_ICE = 0.25;
    private static final double THRESH_NDSI_SNOW_ICE = 0.8;
    private boolean modisApplyBrightnessTest;
    private double modisBrightnessThreshCloudSure;
    private double modisBrightnessThreshCloudAmbiguous;
    private double modisBNirThresh859;
    private double modisGlintThresh859forCloudSure;
    private double modisGlintThresh859forCloudAmbiguous;
    private boolean modisApplyOrLogicInCloudTest;
    private double nnCloudAmbiguousLowerBoundaryValue;
    private double nnCloudAmbiguousSureSeparationValue;
    private double nnCloudSureSnowSeparationValue;
    float waterFraction;
    double[] refl;
    double[] nnOutput;

    public boolean isSnowIce() {
        boolean isSnowIceFromNN = this.nnOutput != null ? this.nnOutput[0] > this.nnCloudSureSnowSeparationValue && this.nnOutput[0] <= 5.0 : !this.isInvalid() && (double)this.brightValue() > 0.25 && (double)this.ndsiValue() > 0.8;
        boolean isSnowIceFromReflRatio = false;
        boolean isSnowIceFromRGB = false;
        return isSnowIceFromNN;
    }

    public boolean isCloud() {
        return this.isCloudAmbiguous() || this.isCloudSure();
    }

    public boolean isCloudAmbiguous() {
        return this.isCloudSure();
    }

    public boolean isCloudSure() {
        boolean isCloudSureFromNN;
        boolean isCloudSureFromBrightness;
        if (this.isSnowIce()) {
            return false;
        }
        boolean bl = isCloudSureFromBrightness = this.modisApplyBrightnessTest && (double)this.brightValue() > Math.max(this.modisBrightnessThreshCloudSure, this.modisBrightnessThreshCloudAmbiguous);
        if (this.nnOutput != null) {
            isCloudSureFromNN = this.nnOutput[0] > this.nnCloudAmbiguousSureSeparationValue && this.nnOutput[0] <= this.nnCloudSureSnowSeparationValue;
            isCloudSureFromNN = isCloudSureFromNN && this.refl[1] > this.modisGlintThresh859forCloudSure;
        } else {
            isCloudSureFromNN = isCloudSureFromBrightness;
        }
        float c1 = this.whiteValue(0, 2);
        float c2 = this.whiteValue(3, 2);
        float c3 = this.whiteValue(0, 3);
        double m = Math.min(Math.min(this.refl[0], this.refl[2]), this.refl[3]);
        boolean isCloudSureFromWhitenesses = this.isLand() ? m > 0.7 && (double)c1 > 0.96 && (double)c2 > 0.93 && (double)c3 > 0.95 && (double)c1 < 1.04 && (double)c2 < 1.05 && (double)c3 < 1.05 : (double)c1 > 0.87 && (double)c2 > 0.9 && (double)c3 > 0.97;
        boolean bl2 = isCloudSureFromWhitenesses = isCloudSureFromWhitenesses && this.refl[1] > this.modisGlintThresh859forCloudSure;
        if (this.modisApplyOrLogicInCloudTest) {
            return isCloudSureFromNN || isCloudSureFromBrightness || isCloudSureFromWhitenesses;
        }
        return isCloudSureFromNN || isCloudSureFromBrightness && isCloudSureFromWhitenesses;
    }

    public boolean isCloudBNir() {
        if (this.isLand()) {
            return this.isCloudSure();
        }
        return this.refl[1] > this.modisBNirThresh859;
    }

    public boolean isCloudBuffer() {
        return false;
    }

    public boolean isCloudShadow() {
        return false;
    }

    public boolean isMixedPixel() {
        return false;
    }

    public boolean isGlintRisk() {
        return false;
    }

    public boolean isInvalid() {
        return false;
    }

    public boolean isCoastline() {
        return this.waterFraction < 100.0f && this.waterFraction > 0.0f;
    }

    public boolean isLand() {
        return this.waterFraction == 0.0f;
    }

    public boolean isBright() {
        return (double)this.brightValue() > this.modisBrightnessThreshCloudSure;
    }

    public float brightValue() {
        return (float)this.refl[0];
    }

    public float whiteValue(int numeratorIndex, int denominatorIndex) {
        return (float)(this.refl[numeratorIndex] / this.refl[denominatorIndex]);
    }

    public float ndsiValue() {
        return (float)((this.refl[0] - this.refl[6]) / (this.refl[0] + this.refl[6]));
    }

    public void setWaterFraction(float waterFraction) {
        this.waterFraction = waterFraction;
    }

    public void setRefl(double[] reflectance) {
        this.refl = reflectance;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }

    public void setModisApplyBrightnessTest(boolean modisApplyBrightnessTest) {
        this.modisApplyBrightnessTest = modisApplyBrightnessTest;
    }

    public void setModisBrightnessThreshCloudSure(double modisBrightnessThresh) {
        this.modisBrightnessThreshCloudSure = modisBrightnessThresh;
    }

    public void setModisBNirThresh859(double modisBNirThresh859) {
        this.modisBNirThresh859 = modisBNirThresh859;
    }

    public void setModisBrightnessThreshCloudAmbiguous(double modisBrightnessThreshCloudAmbiguous) {
        this.modisBrightnessThreshCloudAmbiguous = modisBrightnessThreshCloudAmbiguous;
    }

    public void setModisGlintThresh859forCloudSure(double modisGlintThresh859forCloudSure) {
        this.modisGlintThresh859forCloudSure = modisGlintThresh859forCloudSure;
    }

    public void setModisGlintThresh859forCloudAmbiguous(double modisGlintThresh859forCloudAmbiguous) {
        this.modisGlintThresh859forCloudAmbiguous = modisGlintThresh859forCloudAmbiguous;
    }

    public void setModisApplyOrLogicInCloudTest(boolean modisApplyOrLogicInCloudTest) {
        this.modisApplyOrLogicInCloudTest = modisApplyOrLogicInCloudTest;
    }

    public void setNnCloudAmbiguousLowerBoundaryValue(double nnCloudAmbiguousLowerBoundaryValue) {
        this.nnCloudAmbiguousLowerBoundaryValue = nnCloudAmbiguousLowerBoundaryValue;
    }

    public void setNnCloudAmbiguousSureSeparationValue(double nnCloudAmbiguousSureSeparationValue) {
        this.nnCloudAmbiguousSureSeparationValue = nnCloudAmbiguousSureSeparationValue;
    }

    public void setNnCloudSureSnowSeparationValue(double nnCloudSureSnowSeparationValue) {
        this.nnCloudSureSnowSeparationValue = nnCloudSureSnowSeparationValue;
    }
}

