/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.algorithms.CloudShadowFronts;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Meris.Postprocess", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Refines the MERIS pixel classification over both land and water.")
public class MerisPostProcessOp
extends Operator {
    @Parameter(defaultValue="true", label=" Compute cloud shadow", description=" Compute cloud shadow with latest 'fronts' algorithm")
    private boolean computeCloudShadow;
    @Parameter(defaultValue="true", label=" Refine pixel classification near coastlines", description="Refine pixel classification near coastlines. ")
    private boolean refineClassificationNearCoastlines;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="merisCloud")
    private Product merisCloudProduct;
    @SourceProduct(alias="ctp")
    private Product ctpProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    private Band waterFractionBand;
    private Band origCloudFlagBand;
    private Band ctpBand;
    private TiePointGrid szaTPG;
    private TiePointGrid saaTPG;
    private TiePointGrid altTPG;
    private GeoCoding geoCoding;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        int extendedHeight;
        int extendedWidth;
        Product postProcessedCloudProduct = IdepixIO.createCompatibleTargetProduct(this.merisCloudProduct, "postProcessedCloud", "postProcessedCloud", true);
        this.waterFractionBand = this.waterMaskProduct.getBand("land_water_fraction");
        this.geoCoding = this.l1bProduct.getSceneGeoCoding();
        this.origCloudFlagBand = this.merisCloudProduct.getBand("pixel_classif_flags");
        this.szaTPG = this.l1bProduct.getTiePointGrid("sun_zenith");
        this.saaTPG = this.l1bProduct.getTiePointGrid("sun_azimuth");
        this.altTPG = this.l1bProduct.getTiePointGrid("dem_alt");
        this.ctpBand = this.ctpProduct.getBand("cloud_top_press");
        if (this.l1bProduct.getProductType().startsWith("MER_F")) {
            extendedWidth = 64;
            extendedHeight = 64;
        } else {
            extendedWidth = 16;
            extendedHeight = 16;
        }
        this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), extendedWidth, extendedHeight);
        ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.merisCloudProduct, (Product)postProcessedCloudProduct, (boolean)false);
        this.setTargetProduct(postProcessedCloudProduct);
    }

    public void computeTile(Band targetBand, final Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        final Rectangle srcRectangle = this.rectCalculator.extend(targetRectangle);
        final Tile sourceFlagTile = this.getSourceTile((RasterDataNode)this.origCloudFlagBand, srcRectangle);
        Tile szaTile = this.getSourceTile((RasterDataNode)this.szaTPG, srcRectangle);
        Tile saaTile = this.getSourceTile((RasterDataNode)this.saaTPG, srcRectangle);
        Tile ctpTile = this.getSourceTile((RasterDataNode)this.ctpBand, srcRectangle);
        Tile altTile = this.getSourceTile((RasterDataNode)this.altTPG, targetRectangle);
        final Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.waterFractionBand, srcRectangle);
        for (int y = srcRectangle.y; y < srcRectangle.y + srcRectangle.height; ++y) {
            this.checkForCancellation();
            for (int x = srcRectangle.x; x < srcRectangle.x + srcRectangle.width; ++x) {
                boolean isCloudAfterRefinement;
                if (!targetRectangle.contains(x, y)) continue;
                boolean isCloud = sourceFlagTile.getSampleBit(x, y, 1);
                this.combineFlags(x, y, sourceFlagTile, targetTile);
                if (this.refineClassificationNearCoastlines && this.isNearCoastline(x, y, waterFractionTile, srcRectangle)) {
                    targetTile.setSample(x, y, 9, true);
                    this.refineSnowIceFlaggingForCoastlines(x, y, sourceFlagTile, targetTile);
                    if (isCloud) {
                        this.refineCloudFlaggingForCoastlines(x, y, sourceFlagTile, waterFractionTile, targetTile, srcRectangle);
                    }
                }
                if (!(isCloudAfterRefinement = targetTile.getSampleBit(x, y, 1))) continue;
                targetTile.setSample(x, y, 6, false);
            }
        }
        if (this.computeCloudShadow) {
            CloudShadowFronts cloudShadowFronts = new CloudShadowFronts(this.geoCoding, srcRectangle, targetRectangle, szaTile, saaTile, ctpTile, altTile){

                @Override
                protected boolean isCloudForShadow(int x, int y) {
                    boolean isNearCoastline;
                    boolean is_cloud_current = !targetTile.getRectangle().contains(x, y) ? sourceFlagTile.getSampleBit(x, y, 1) : targetTile.getSampleBit(x, y, 1);
                    return is_cloud_current && !(isNearCoastline = MerisPostProcessOp.this.isNearCoastline(x, y, waterFractionTile, srcRectangle));
                }

                @Override
                protected boolean isCloudFree(int x, int y) {
                    return !sourceFlagTile.getSampleBit(x, y, 1);
                }

                @Override
                protected boolean isSurroundedByCloud(int x, int y) {
                    return 1.isPixelSurrounded(x, y, sourceFlagTile, 1);
                }

                @Override
                protected void setCloudShadow(int x, int y) {
                    targetTile.setSample(x, y, 5, true);
                }
            };
            cloudShadowFronts.computeCloudShadow();
        }
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    private boolean isCoastlinePixel(int x, int y, Tile waterFractionTile) {
        int waterFraction;
        boolean isCoastline = false;
        if (this.getGeoPos((int)x, (int)y).lat > -58.0 && (waterFraction = waterFractionTile.getSampleInt(x, y)) <= 100) {
            isCoastline = waterFraction < 100 && waterFraction > 0;
        }
        return isCoastline;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        this.geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private boolean isNearCoastline(int x, int y, Tile waterFractionTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        int waterFractionCenter = waterFractionTile.getSampleInt(x, y);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                if (!rectangle.contains(i, j) || !(!(this.l1bProduct.getSceneGeoCoding() instanceof TiePointGeoCoding) && !(this.l1bProduct.getSceneGeoCoding() instanceof CrsGeoCoding) ? waterFractionTile.getSampleInt(i, j) != waterFractionCenter : this.isCoastlinePixel(i, j, waterFractionTile))) continue;
                return true;
            }
        }
        return false;
    }

    private void refineCloudFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile waterFractionTile, Tile targetTile, Rectangle srcRectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, srcRectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, srcRectangle.x + srcRectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, srcRectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, srcRectangle.y + srcRectangle.height - 1);
        boolean removeCloudFlag = true;
        if (CloudShadowFronts.isPixelSurrounded(x, y, sourceFlagTile, 1)) {
            removeCloudFlag = false;
        } else {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            block0: for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean is_cloud = sourceFlagTile.getSampleBit(i, j, 1);
                    if (!is_cloud || !targetTileRectangle.contains(i, j) || this.isNearCoastline(i, j, waterFractionTile, srcRectangle)) continue;
                    removeCloudFlag = false;
                    continue block0;
                }
            }
        }
        if (removeCloudFlag) {
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 2, false);
        }
    }

    private void refineSnowIceFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        boolean isSnowIce = sourceFlagTile.getSampleBit(x, y, 6);
        if (isSnowIce) {
            targetTile.setSample(x, y, 6, false);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MerisPostProcessOp.class);
        }
    }
}

