/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.meris;

import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.meris.MerisLandClassificationOp;
import org.esa.s3tbx.idepix.algorithms.meris.MerisMergeLandWaterOp;
import org.esa.s3tbx.idepix.algorithms.meris.MerisPostProcessOp;
import org.esa.s3tbx.idepix.algorithms.meris.MerisUtils;
import org.esa.s3tbx.idepix.algorithms.meris.MerisWaterClassificationOp;
import org.esa.s3tbx.idepix.core.AlgorithmSelector;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.operators.BasisOp;
import org.esa.s3tbx.idepix.operators.CloudBufferOp;
import org.esa.s3tbx.idepix.operators.IdepixProducts;
import org.esa.s3tbx.processor.rad2refl.Sensor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Idepix.Envisat.Meris", category="Optical/Pre-Processing", version="1.0", authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Pixel identification and classification for MERIS.")
public class MerisOp
extends BasisOp {
    @SourceProduct(alias="sourceProduct", label="MERIS L1b product", description="The MERIS L1b source product.")
    private Product sourceProduct;
    @TargetProduct(description="The target product.")
    private Product targetProduct;
    private boolean outputRadiance = false;
    private boolean outputRad2Refl = false;
    @Parameter(description="The list of radiance bands to write to target product.", label="Select TOA radiances to write to the target product", valueSet={"radiance_1", "radiance_2", "radiance_3", "radiance_4", "radiance_5", "radiance_6", "radiance_7", "radiance_8", "radiance_9", "radiance_10", "radiance_11", "radiance_12", "radiance_13", "radiance_14", "radiance_15"}, defaultValue="")
    String[] radianceBandsToCopy;
    @Parameter(description="The list of reflectance bands to write to target product.", label="Select TOA reflectances to write to the target product", valueSet={"reflectance_1", "reflectance_2", "reflectance_3", "reflectance_4", "reflectance_5", "reflectance_6", "reflectance_7", "reflectance_8", "reflectance_9", "reflectance_10", "reflectance_11", "reflectance_12", "reflectance_13", "reflectance_14", "reflectance_15"}, defaultValue="")
    String[] reflBandsToCopy;
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="2.0", label=" NN cloud ambiguous lower boundary (applied on WATER)", description=" NN cloud ambiguous lower boundary (applied on WATER)")
    double schillerWaterNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.7", label=" NN cloud ambiguous/sure separation value (applied on WATER)", description=" NN cloud ambiguous cloud ambiguous/sure separation value (applied on WATER)")
    double schillerWaterNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.05", label=" NN cloud sure/snow separation value (applied on WATER)", description=" NN cloud ambiguous cloud sure/snow separation value (applied on WATER)")
    double schillerWaterNNCloudSureSnowSeparationValue;
    @Parameter(defaultValue="1.1", label=" NN cloud ambiguous lower boundary (applied on LAND)", description=" NN cloud ambiguous lower boundary (applied on LAND)")
    double schillerLandNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="2.7", label=" NN cloud ambiguous/sure separation value (applied on LAND)", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    double schillerLandNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.6", label=" NN cloud sure/snow separation value (applied on LAND)", description=" NN cloud ambiguous cloud sure/snow separation value")
    double schillerLandNNCloudSureSnowSeparationValue;
    @Parameter(defaultValue="true", label=" Compute cloud shadow", description=" Compute cloud shadow with the algorithm from 'Fronts' project")
    private boolean computeCloudShadow;
    @Parameter(defaultValue="true", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    @Parameter(defaultValue="2", interval="[0,100]", description="The width of a cloud 'safety buffer' around a pixel which was classified as cloudy.", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    private Product waterClassificationProduct;
    private Product landClassificationProduct;
    private Product mergedClassificationProduct;
    private Product postProcessingProduct;
    private Product rad2reflProduct;
    private Product ctpProduct;
    private Product waterMaskProduct;
    private Map<String, Product> classificationInputProducts;
    private Map<String, Object> waterClassificationParameters;
    private Map<String, Object> landClassificationParameters;

    public void initialize() throws OperatorException {
        boolean inputProductIsValid = IdepixIO.validateInputProduct(this.sourceProduct, AlgorithmSelector.MERIS);
        if (!inputProductIsValid) {
            throw new OperatorException("Selected cloud screening algorithm cannot be used with given input product. \n\nSupported sensors are: MERIS, SPOT VGT, MODIS, Landsat-8, SeaWiFS, Sentinel-2 MSI, Sentinel-3 OLCI, PROBA-V, VIIRS.");
        }
        this.outputRadiance = this.radianceBandsToCopy != null && this.radianceBandsToCopy.length > 0;
        this.outputRad2Refl = this.reflBandsToCopy != null && this.reflBandsToCopy.length > 0;
        this.preProcess();
        this.computeWaterCloudProduct();
        this.computeLandCloudProduct();
        this.mergeLandWater();
        this.postProcess();
        this.targetProduct = this.postProcessingProduct;
        this.targetProduct = IdepixIO.cloneProduct(this.mergedClassificationProduct, true);
        this.targetProduct.setAutoGrouping("radiance:reflectance");
        Band cloudFlagBand = this.targetProduct.getBand("pixel_classif_flags");
        cloudFlagBand.setSourceImage(this.postProcessingProduct.getBand("pixel_classif_flags").getSourceImage());
        this.copyOutputBands();
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
    }

    private void preProcess() {
        this.rad2reflProduct = IdepixProducts.computeRadiance2ReflectanceProduct(this.sourceProduct, Sensor.MERIS);
        this.ctpProduct = IdepixProducts.computeCloudTopPressureProduct(this.sourceProduct);
        HashMap<String, Integer> waterMaskParameters = new HashMap<String, Integer>();
        waterMaskParameters.put("resolution", 50);
        waterMaskParameters.put("subSamplingFactorX", 3);
        waterMaskParameters.put("subSamplingFactorY", 3);
        this.waterMaskProduct = GPF.createProduct((String)"LandWaterMask", waterMaskParameters, (Product)this.sourceProduct);
    }

    private void setLandClassificationParameters() {
        this.landClassificationParameters = new HashMap<String, Object>();
        this.landClassificationParameters.put("copyAllTiePoints", true);
        this.landClassificationParameters.put("outputSchillerNNValue", this.outputSchillerNNValue);
        this.landClassificationParameters.put("ccSchillerNNCloudAmbiguousLowerBoundaryValue", this.schillerLandNNCloudAmbiguousLowerBoundaryValue);
        this.landClassificationParameters.put("ccSchillerNNCloudAmbiguousSureSeparationValue", this.schillerLandNNCloudAmbiguousSureSeparationValue);
        this.landClassificationParameters.put("ccSchillerNNCloudSureSnowSeparationValue", this.schillerLandNNCloudSureSnowSeparationValue);
    }

    private void setWaterClassificationParameters() {
        this.waterClassificationParameters = new HashMap<String, Object>();
        this.waterClassificationParameters.put("copyAllTiePoints", true);
        this.waterClassificationParameters.put("outputSchillerNNValue", this.outputSchillerNNValue);
        this.waterClassificationParameters.put("ccSchillerNNCloudAmbiguousLowerBoundaryValue", this.schillerWaterNNCloudAmbiguousLowerBoundaryValue);
        this.waterClassificationParameters.put("ccSchillerNNCloudAmbiguousSureSeparationValue", this.schillerWaterNNCloudAmbiguousSureSeparationValue);
        this.waterClassificationParameters.put("ccSchillerNNCloudSureSnowSeparationValue", this.schillerWaterNNCloudSureSnowSeparationValue);
    }

    private void computeWaterCloudProduct() {
        this.setWaterClassificationParameters();
        this.classificationInputProducts = new HashMap<String, Product>();
        this.classificationInputProducts.put("l1b", this.sourceProduct);
        this.classificationInputProducts.put("rhotoa", this.rad2reflProduct);
        this.classificationInputProducts.put("waterMask", this.waterMaskProduct);
        this.waterClassificationProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(MerisWaterClassificationOp.class), this.waterClassificationParameters, this.classificationInputProducts);
    }

    private void computeLandCloudProduct() {
        this.setLandClassificationParameters();
        this.landClassificationProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(MerisLandClassificationOp.class), this.landClassificationParameters, this.classificationInputProducts);
    }

    private void mergeLandWater() {
        HashMap<String, Product> mergeInputProducts = new HashMap<String, Product>();
        mergeInputProducts.put("landClassif", this.landClassificationProduct);
        mergeInputProducts.put("waterClassif", this.waterClassificationProduct);
        HashMap<String, Boolean> mergeClassificationParameters = new HashMap<String, Boolean>();
        mergeClassificationParameters.put("copyAllTiePoints", true);
        this.mergedClassificationProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(MerisMergeLandWaterOp.class), mergeClassificationParameters, mergeInputProducts);
    }

    private void postProcess() {
        HashMap<String, Product> input = new HashMap<String, Product>();
        input.put("l1b", this.sourceProduct);
        input.put("merisCloud", this.mergedClassificationProduct);
        input.put("ctp", this.ctpProduct);
        input.put("waterMask", this.waterMaskProduct);
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("computeCloudShadow", Boolean.valueOf(this.computeCloudShadow));
        params.put("refineClassificationNearCoastlines", Boolean.valueOf(true));
        Product classifiedProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(MerisPostProcessOp.class), params, input);
        if (this.computeCloudBuffer) {
            input = new HashMap();
            input.put("classifiedProduct", classifiedProduct);
            params = new HashMap();
            params.put("cloudBufferWidth", Integer.valueOf(this.cloudBufferWidth));
            this.postProcessingProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(CloudBufferOp.class), params, input);
        } else {
            this.postProcessingProduct = classifiedProduct;
        }
    }

    private void copyOutputBands() {
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        MerisUtils.setupMerisClassifBitmask(this.targetProduct);
        if (this.outputRadiance) {
            IdepixIO.addRadianceBands(this.sourceProduct, this.targetProduct, this.radianceBandsToCopy);
        }
        if (this.outputRad2Refl) {
            IdepixIO.addMerisRadiance2ReflectanceBands(this.rad2reflProduct, this.targetProduct, this.reflBandsToCopy);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MerisOp.class);
        }
    }
}

