/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.algorithms.meris.MerisUtils;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;

@OperatorMetadata(alias="Idepix.Meris.Merge.Landwater", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix water/land merge operator for MERIS.")
public class MerisMergeLandWaterOp
extends Operator {
    @SourceProduct(alias="landClassif")
    private Product landClassifProduct;
    @SourceProduct(alias="waterClassif")
    private Product waterClassifProduct;
    private Band waterClassifBand;
    private Band landClassifBand;
    private Band landNNBand;
    private Band waterNNBand;
    private Band mergedClassifBand;
    private Band mergedNNBand;
    private boolean hasNNOutput;

    public void initialize() throws OperatorException {
        Product mergedClassifProduct = IdepixIO.createCompatibleTargetProduct(this.landClassifProduct, "mergedClassif", "mergedClassif", true);
        this.landClassifBand = this.landClassifProduct.getBand("pixel_classif_flags");
        this.waterClassifBand = this.waterClassifProduct.getBand("pixel_classif_flags");
        this.mergedClassifBand = mergedClassifProduct.addBand("pixel_classif_flags", 11);
        FlagCoding flagCoding = MerisUtils.createMerisFlagCoding("pixel_classif_flags");
        this.mergedClassifBand.setSampleCoding((SampleCoding)flagCoding);
        mergedClassifProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        boolean bl = this.hasNNOutput = this.landClassifProduct.containsBand("nn_value") && this.waterClassifProduct.containsBand("nn_value");
        if (this.hasNNOutput) {
            this.landNNBand = this.landClassifProduct.getBand("nn_value");
            this.waterNNBand = this.waterClassifProduct.getBand("nn_value");
            this.mergedNNBand = mergedClassifProduct.addBand("nn_value", 30);
        }
        this.setTargetProduct(mergedClassifProduct);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block6: {
            Tile landNNTile;
            Tile waterNNTile;
            Tile landClassifTile;
            Rectangle rectangle;
            block5: {
                rectangle = targetTile.getRectangle();
                Tile waterClassifTile = this.getSourceTile((RasterDataNode)this.waterClassifBand, rectangle);
                landClassifTile = this.getSourceTile((RasterDataNode)this.landClassifBand, rectangle);
                waterNNTile = null;
                landNNTile = null;
                if (this.hasNNOutput) {
                    waterNNTile = this.getSourceTile((RasterDataNode)this.waterNNBand, rectangle);
                    landNNTile = this.getSourceTile((RasterDataNode)this.landNNBand, rectangle);
                }
                if (targetBand != this.mergedClassifBand) break block5;
                for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                    this.checkForCancellation();
                    for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                        boolean isLand = landClassifTile.getSampleBit(x, y, 10);
                        int sample = isLand ? landClassifTile.getSampleInt(x, y) : waterClassifTile.getSampleInt(x, y);
                        targetTile.setSample(x, y, sample);
                    }
                }
                break block6;
            }
            if (!this.hasNNOutput || targetBand != this.mergedNNBand) break block6;
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    boolean isLand = landClassifTile.getSampleBit(x, y, 10);
                    float sample = isLand ? landNNTile.getSampleFloat(x, y) : waterNNTile.getSampleFloat(x, y);
                    targetTile.setSample(x, y, sample);
                }
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MerisMergeLandWaterOp.class);
        }
    }
}

