/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.InputStream;
import java.util.Map;
import org.esa.s3tbx.idepix.algorithms.meris.MerisUtils;
import org.esa.s3tbx.idepix.core.util.IdepixIO;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.s3tbx.processor.rad2refl.Rad2ReflConstants;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

@OperatorMetadata(alias="Idepix.Meris.Land", version="1.0", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Idepix land pixel classification operator for MERIS.")
public class MerisLandClassificationOp
extends Operator {
    @Parameter(defaultValue="false", label=" Write NN value to the target product.", description=" If applied, write Schiller NN value to the target product ")
    private boolean outputSchillerNNValue;
    @Parameter(defaultValue="2.0", label=" NN cloud ambiguous lower boundary", description=" NN cloud ambiguous lower boundary")
    double schillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.7", label=" NN cloud ambiguous/sure separation value", description=" NN cloud ambiguous cloud ambiguous/sure separation value")
    double schillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.05", label=" NN cloud sure/snow separation value (MERIS only)", description=" NN cloud ambiguous cloud sure/snow separation value")
    double schillerNNCloudSureSnowSeparationValue;
    @SourceProduct(alias="l1b", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="rhotoa")
    private Product rad2reflProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    Band cloudFlagBand;
    private Band[] merisReflBands;
    private Band landWaterBand;
    public static final String MERIS_LAND_NET_NAME = "11x8x5x3_1062.5_land.net";
    ThreadLocal<SchillerNeuralNetWrapper> merisLandNeuralNet;

    public void initialize() throws OperatorException {
        this.setBands();
        this.readSchillerNeuralNets();
        this.createTargetProduct();
        this.landWaterBand = this.waterMaskProduct.getBand("land_water_fraction");
    }

    private void readSchillerNeuralNets() {
        InputStream merisLandIS = ((Object)((Object)this)).getClass().getResourceAsStream(MERIS_LAND_NET_NAME);
        this.merisLandNeuralNet = SchillerNeuralNetWrapper.create(merisLandIS);
    }

    public void setBands() {
        this.merisReflBands = new Band[Rad2ReflConstants.MERIS_REFL_BAND_NAMES.length];
        for (int i = 0; i < EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            int suffixStart = Rad2ReflConstants.MERIS_REFL_BAND_NAMES[i].indexOf("_");
            String reflBandname = Rad2ReflConstants.MERIS_REFL_BAND_NAMES[i].substring(0, suffixStart);
            this.merisReflBands[i] = this.rad2reflProduct.getBand(reflBandname + "_" + (i + 1));
        }
    }

    void createTargetProduct() throws OperatorException {
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sceneWidth, sceneHeight);
        this.cloudFlagBand = this.targetProduct.addBand("pixel_classif_flags", 11);
        FlagCoding flagCoding = MerisUtils.createMerisFlagCoding("pixel_classif_flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.outputSchillerNNValue) {
            this.targetProduct.addBand("nn_value", 30);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        Tile waterFractionTile = this.getSourceTile((RasterDataNode)this.landWaterBand, rectangle);
        Band merisL1bFlagBand = this.sourceProduct.getBand("l1_flags");
        Tile merisL1bFlagTile = this.getSourceTile((RasterDataNode)merisL1bFlagBand, rectangle);
        Tile[] merisReflectanceTiles = new Tile[EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS];
        float[] merisReflectance = new float[EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS];
        for (int i = 0; i < EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
            merisReflectanceTiles[i] = this.getSourceTile((RasterDataNode)this.merisReflBands[i], rectangle);
        }
        Band cloudFlagTargetBand = this.targetProduct.getBand("pixel_classif_flags");
        Tile cloudFlagTargetTile = targetTiles.get(cloudFlagTargetBand);
        Tile nnTargetTile = null;
        if (this.outputSchillerNNValue) {
            Band nnTargetBand = this.targetProduct.getBand("nn_value");
            nnTargetTile = targetTiles.get(nnTargetBand);
        }
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.checkForCancellation();
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    int waterFraction = waterFractionTile.getSampleInt(x, y);
                    this.initCloudFlag(merisL1bFlagTile, targetTiles.get(cloudFlagTargetBand), merisReflectance, y, x);
                    if (!this.isLandPixel(x, y, merisL1bFlagTile, waterFraction)) {
                        cloudFlagTargetTile.setSample(x, y, 10, false);
                        cloudFlagTargetTile.setSample(x, y, 1, false);
                        cloudFlagTargetTile.setSample(x, y, 6, false);
                        if (nnTargetTile == null) continue;
                        nnTargetTile.setSample(x, y, Float.NaN);
                        continue;
                    }
                    for (int i = 0; i < EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS; ++i) {
                        merisReflectance[i] = merisReflectanceTiles[i].getSampleFloat(x, y);
                    }
                    SchillerNeuralNetWrapper nnWrapper = this.merisLandNeuralNet.get();
                    double[] inputVector = nnWrapper.getInputVector();
                    for (int i = 0; i < inputVector.length; ++i) {
                        inputVector[i] = Math.sqrt(merisReflectance[i]);
                    }
                    double[] nnOutput = nnWrapper.getNeuralNet().calc(inputVector);
                    if (!cloudFlagTargetTile.getSampleBit(x, y, 0)) {
                        cloudFlagTargetTile.setSample(x, y, 2, false);
                        cloudFlagTargetTile.setSample(x, y, 3, false);
                        cloudFlagTargetTile.setSample(x, y, 1, false);
                        cloudFlagTargetTile.setSample(x, y, 6, false);
                        if (nnOutput[0] > this.schillerNNCloudAmbiguousLowerBoundaryValue && nnOutput[0] <= this.schillerNNCloudAmbiguousSureSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 2, true);
                            cloudFlagTargetTile.setSample(x, y, 1, true);
                        }
                        if (nnOutput[0] > this.schillerNNCloudAmbiguousSureSeparationValue && nnOutput[0] <= this.schillerNNCloudSureSnowSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 3, true);
                            cloudFlagTargetTile.setSample(x, y, 1, true);
                        }
                        if (nnOutput[0] > this.schillerNNCloudSureSnowSeparationValue) {
                            cloudFlagTargetTile.setSample(x, y, 6, true);
                        }
                    }
                    if (nnTargetTile == null) continue;
                    nnTargetTile.setSample(x, y, nnOutput[0]);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to provide GA cloud screening:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isLandPixel(int x, int y, Tile merisL1bFlagTile, int waterFraction) {
        if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
            if (waterFraction <= 100) {
                return waterFraction == 0;
            }
            return merisL1bFlagTile.getSampleBit(x, y, 4);
        }
        return merisL1bFlagTile.getSampleBit(x, y, 4);
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        GeoCoding geoCoding = this.getSourceProduct().getSceneGeoCoding();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    void initCloudFlag(Tile merisL1bFlagTile, Tile targetTile, float[] merisReflectances, int y, int x) {
        boolean l1Invalid = merisL1bFlagTile.getSampleBit(x, y, 7);
        boolean reflectancesValid = IdepixIO.areAllReflectancesValid(merisReflectances);
        targetTile.setSample(x, y, 0, l1Invalid || !reflectancesValid);
        targetTile.setSample(x, y, 1, false);
        targetTile.setSample(x, y, 3, false);
        targetTile.setSample(x, y, 2, false);
        targetTile.setSample(x, y, 6, false);
        targetTile.setSample(x, y, 4, false);
        targetTile.setSample(x, y, 5, false);
        targetTile.setSample(x, y, 12, false);
        targetTile.setSample(x, y, 9, false);
        targetTile.setSample(x, y, 10, true);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MerisLandClassificationOp.class);
        }
    }
}

