/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.landsat8;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import org.esa.s3tbx.idepix.algorithms.landsat8.OtsuBinarize;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

@OperatorMetadata(alias="Idepix.Landsat8.Otsu", version="2.2", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Landsat 8 Otsu binarization: provides product with binarized R, G, and B image.")
public class OtsuBinarizeOp
extends Operator {
    public static final String OTSU_BINARY_BAND_NAME = "OTSU_BINARY";
    public static final String OTSU_GREY_BAND_NAME = "OTSU_GREY";
    @SourceProduct(alias="l8source", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="clost", description="The CLOST product.")
    Product clostProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @Parameter(defaultValue="GREY", valueSet={"GREY", "BINARY"}, description="OTSU processing mode (grey or binary target image)", label="OTSU processing mode (grey or binary target image)")
    private String otsuMode;

    public void initialize() throws OperatorException {
        Band redBand = this.sourceProduct.getBand("red");
        Band greenBand = this.sourceProduct.getBand("green");
        Band blueBand = this.sourceProduct.getBand("blue");
        Band cirrusBand = this.sourceProduct.getBand("cirrus");
        Band aerosolBand = this.sourceProduct.getBand("coastal_aerosol");
        Band panBand = this.sourceProduct.getBand("panchromatic");
        Band clostBand = this.clostProduct.getBand("CLOST");
        RasterDataNode[] rgbChannelNodes = new RasterDataNode[]{clostBand};
        try {
            ImageInfo clostImageInfo = ProductUtils.createImageInfo((RasterDataNode[])rgbChannelNodes, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
            BufferedImage clostImageRgb = ProductUtils.createRgbImage((RasterDataNode[])rgbChannelNodes, (ImageInfo)clostImageInfo, (ProgressMonitor)ProgressMonitor.NULL);
            BufferedImage clostImageGray = OtsuBinarize.toGray(clostImageRgb);
            BufferedImage clostImageBinarized = OtsuBinarize.binarize(clostImageGray);
            Product otsuProduct = this.otsuMode.equals("GREY") ? this.createGreyProduct(clostImageGray) : this.createBinarizedProduct(clostImageBinarized);
            ProductUtils.copyBand((String)"CLOST", (Product)this.clostProduct, (Product)otsuProduct, (boolean)true);
            this.setTargetProduct(otsuProduct);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot do OTSU binarization: " + e.getMessage());
        }
    }

    private Product createBinarizedProduct(BufferedImage sourceImage) {
        Product product = new Product(this.sourceProduct.getName() + "_binary", this.sourceProduct.getProductType() + " (binarized)", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        product.setSceneGeoCoding(this.sourceProduct.getSceneGeoCoding());
        product.setDescription("Product holding RGB Image transformed to binary");
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceImage);
        RenderedOp bandImage = this.getBandSourceImage(planarImage, 0);
        Band band = product.addBand(OTSU_BINARY_BAND_NAME, ImageManager.getProductDataType((int)bandImage.getSampleModel().getDataType()));
        band.setSourceImage((RenderedImage)bandImage);
        band.setUnit("dl");
        band.setDescription("RGB Image transformed to binary");
        Band sourceProductReferenceBand = this.sourceProduct.getBand("red");
        band.setNoDataValue(sourceProductReferenceBand.getNoDataValue());
        band.setNoDataValueUsed(sourceProductReferenceBand.isNoDataValueUsed());
        product.getBand(OTSU_BINARY_BAND_NAME).setValidPixelExpression(sourceProductReferenceBand.getValidPixelExpression());
        return product;
    }

    private Product createGreyProduct(BufferedImage sourceImage) {
        Product product = new Product(this.sourceProduct.getName() + "_grey", this.sourceProduct.getProductType() + " (greyscaled)", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        product.setSceneGeoCoding(this.sourceProduct.getSceneGeoCoding());
        product.setDescription("Product holding RGB Image transformed to greyscale");
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceImage);
        RenderedOp bandImage = this.getBandSourceImage(planarImage, 0);
        Band band = product.addBand(OTSU_GREY_BAND_NAME, ImageManager.getProductDataType((int)bandImage.getSampleModel().getDataType()));
        band.setSourceImage((RenderedImage)bandImage);
        band.setUnit("dl");
        band.setDescription("RGB Image transformed to greyscale");
        Band sourceProductReferenceBand = this.sourceProduct.getBand("red");
        band.setNoDataValue(sourceProductReferenceBand.getNoDataValue());
        band.setNoDataValueUsed(sourceProductReferenceBand.isNoDataValueUsed());
        product.getBand(OTSU_GREY_BAND_NAME).setValidPixelExpression(sourceProductReferenceBand.getValidPixelExpression());
        return product;
    }

    private RenderedOp getBandSourceImage(PlanarImage planarImage, int i) {
        boolean noSourceImageTiling;
        RenderedOp bandImage = BandSelectDescriptor.create((RenderedImage)planarImage, (int[])new int[]{i}, null);
        int tileWidth = bandImage.getTileWidth();
        int tileHeight = bandImage.getTileHeight();
        ImageLayout imageLayout = new ImageLayout();
        boolean bl = noSourceImageTiling = tileWidth == bandImage.getWidth() && tileHeight == bandImage.getHeight();
        if (noSourceImageTiling) {
            tileWidth = Math.min(bandImage.getWidth(), 512);
            tileHeight = Math.min(bandImage.getHeight(), 512);
            imageLayout.setTileWidth(tileWidth);
            imageLayout.setTileHeight(tileHeight);
        }
        imageLayout.setSampleModel((SampleModel)new SingleBandedSampleModel(bandImage.getSampleModel().getDataType(), tileWidth, tileHeight));
        bandImage = FormatDescriptor.create((RenderedImage)bandImage, (Integer)bandImage.getSampleModel().getDataType(), (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        return bandImage;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OtsuBinarizeOp.class);
        }
    }
}

