/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.landsat8;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class OtsuBinarize {
    public static int[] imageHistogram(BufferedImage input) {
        int i;
        int[] histogram = new int[256];
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = 0; i < input.getWidth(); ++i) {
            for (int j = 0; j < input.getHeight(); ++j) {
                int red;
                int n = red = new Color(input.getRGB(i, j)).getRed();
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public static BufferedImage toGray(BufferedImage original) {
        BufferedImage lum = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
        for (int i = 0; i < original.getWidth(); ++i) {
            for (int j = 0; j < original.getHeight(); ++j) {
                int alpha = new Color(original.getRGB(i, j)).getAlpha();
                int red = new Color(original.getRGB(i, j)).getRed();
                int green = new Color(original.getRGB(i, j)).getGreen();
                int blue = new Color(original.getRGB(i, j)).getBlue();
                red = (int)(0.21 * (double)red + 0.71 * (double)green + 0.07 * (double)blue);
                int newPixel = OtsuBinarize.colorToRGB(alpha, red, red, red);
                lum.setRGB(i, j, newPixel);
            }
        }
        return lum;
    }

    public static BufferedImage binarize(BufferedImage original) {
        int threshold = OtsuBinarize.otsuTreshold(original);
        BufferedImage binarized = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
        for (int i = 0; i < original.getWidth(); ++i) {
            for (int j = 0; j < original.getHeight(); ++j) {
                int red = new Color(original.getRGB(i, j)).getRed();
                int alpha = new Color(original.getRGB(i, j)).getAlpha();
                int newPixel = red > threshold ? 255 : 1;
                newPixel = OtsuBinarize.colorToRGB(alpha, newPixel, newPixel, newPixel);
                binarized.setRGB(i, j, newPixel);
            }
        }
        return binarized;
    }

    private static int otsuTreshold(BufferedImage original) {
        int[] histogram = OtsuBinarize.imageHistogram(original);
        int total = original.getHeight() * original.getWidth();
        float sum = 0.0f;
        for (int i = 0; i < 256; ++i) {
            sum += (float)(i * histogram[i]);
        }
        float sumB = 0.0f;
        int wB = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            float mF;
            float varBetween;
            if ((wB += histogram[i]) == 0) continue;
            int wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(i * histogram[i])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    private static int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }
}

