/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.landsat8;

import java.awt.Color;
import java.util.Random;
import javax.media.jai.Histogram;
import org.esa.s3tbx.idepix.core.IdepixFlagCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.BitSetter;

public class Landsat8Utils {
    public static FlagCoding createLandsat8FlagCoding(String flagId) {
        FlagCoding flagCoding = IdepixFlagCoding.createDefaultFlagCoding(flagId);
        flagCoding.addFlag("IDEPIX_CLOUD_SHIMEZ", BitSetter.setFlag((int)0, (int)12), "Pixels which are either cloud_sure or cloud_ambiguous[SHIMEZ]");
        flagCoding.addFlag("IDEPIX_CLOUD_SHIMEZ_BUFFER", BitSetter.setFlag((int)0, (int)13), "A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with SHIMEZ test");
        flagCoding.addFlag("IDEPIX_CLOUD_HOT", BitSetter.setFlag((int)0, (int)14), "Pixels which are either cloud_sure or cloud_ambiguous[HOT]");
        flagCoding.addFlag("IDEPIX_CLOUD_HOT_BUFFER", BitSetter.setFlag((int)0, (int)15), "A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with HOT test");
        flagCoding.addFlag("IDEPIX_CLOUD_OTSU", BitSetter.setFlag((int)0, (int)16), "Pixels which are either cloud_sure or cloud_ambiguous[OTSU]");
        flagCoding.addFlag("IDEPIX_CLOUD_OTSU_BUFFER", BitSetter.setFlag((int)0, (int)17), "A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with OTSU test");
        flagCoding.addFlag("IDEPIX_CLOUD_CLOST", BitSetter.setFlag((int)0, (int)18), "Pixels which are either cloud_sure or cloud_ambiguous[CLOST]");
        flagCoding.addFlag("IDEPIX_CLOUD_CLOST_BUFFER", BitSetter.setFlag((int)0, (int)19), "A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with CLOST test");
        return flagCoding;
    }

    public static void setupLandsat8ClassifBitmask(Product classifProduct) {
        int index = IdepixFlagCoding.setupDefaultClassifBitmask(classifProduct);
        int w = classifProduct.getSceneRasterWidth();
        int h = classifProduct.getSceneRasterHeight();
        Random r = new Random();
        Mask mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_SHIMEZ", (String)"Pixels which are either cloud_sure or cloud_ambiguous[SHIMEZ]", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_SHIMEZ", (Color)Color.magenta, (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_SHIMEZ_BUFFER", (String)"A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with SHIMEZ test", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_SHIMEZ_BUFFER", (Color)Color.orange, (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_HOT", (String)"Pixels which are either cloud_sure or cloud_ambiguous[HOT]", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_HOT", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_HOT_BUFFER", (String)"A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with HOT test", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_HOT_BUFFER", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_OTSU", (String)"Pixels which are either cloud_sure or cloud_ambiguous[OTSU]", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_OTSU", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_OTSU_BUFFER", (String)"A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with OTSU test", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_OTSU_BUFFER", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_CLOST", (String)"Pixels which are either cloud_sure or cloud_ambiguous[CLOST]", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_CLOST", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index++, (ProductNode)mask);
        mask = Mask.BandMathsType.create((String)"IDEPIX_CLOUD_CLOST_BUFFER", (String)"A buffer of n pixels around a cloud. Applied to pixels classified as 'cloud' with CLOST test", (int)w, (int)h, (String)"pixel_classif_flags.IDEPIX_CLOUD_CLOST_BUFFER", (Color)IdepixFlagCoding.getRandomColour(r), (double)0.5);
        classifProduct.getMaskGroup().add(index, (ProductNode)mask);
    }

    public static int getWavelengthFromString(String wvlString) {
        if (wvlString.toUpperCase().contains("PANCHROMATIC")) {
            return 590;
        }
        return Integer.parseInt(wvlString);
    }

    public static double getHistogramBinAtNPercentOfMaximum(Stx stx, double percent) {
        Histogram h = stx.getHistogram();
        double highValue = h.getHighValue()[0];
        double lowValue = h.getLowValue()[0];
        int numBins = h.getNumBins(0);
        double binWidth = (highValue - lowValue) / (double)numBins;
        double peakValue = Landsat8Utils.getHistogramPeakValue(h);
        for (int i = numBins - 1; i >= 0; --i) {
            double currValue = highValue - (double)(numBins - i) * binWidth;
            if (!((double)h.getBins()[0][i] >= percent * peakValue / 100.0)) continue;
            return currValue;
        }
        return peakValue;
    }

    private static double getHistogramPeakValue(Histogram h) {
        int peakValue = 0;
        for (int i = 0; i < h.getNumBins(0); ++i) {
            if (h.getBins()[0][i] <= peakValue) continue;
            peakValue = h.getBins()[0][i];
        }
        return peakValue;
    }
}

