/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.landsat8;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.idepix.algorithms.CloudBuffer;
import org.esa.s3tbx.idepix.algorithms.CloudShadowFronts;
import org.esa.s3tbx.idepix.core.util.OperatorUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Idepix.Landsat8.Postprocess", version="2.2", internal=true, authors="Marco Peters, Marco Zuehlke, Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Refines the Landsat-8 pixel classification.")
public class Landsat8PostProcessOp
extends Operator {
    @Parameter(defaultValue="2", label="Width of cloud buffer (# of pixels)")
    private int cloudBufferWidth;
    @Parameter(defaultValue="false", label=" Compute a cloud buffer")
    private boolean computeCloudBuffer;
    private boolean computeCloudShadow = false;
    @Parameter(defaultValue="false", label=" Refine pixel classification near coastlines (time consuming!)", description="Refine pixel classification near coastlines. ")
    private boolean refineClassificationNearCoastlines;
    @Parameter(label=" Cloud classification band suffix")
    private String cloudClassifBandSuffix;
    @SourceProduct(alias="landsatCloud")
    private Product landsatCloudProduct;
    @SourceProduct(alias="waterMask", optional=true)
    private Product waterMaskProduct;
    private Band waterFractionBand;
    private Band origCloudFlagBand;
    private GeoCoding geoCoding;
    private RectangleExtender rectCalculator;

    public void initialize() throws OperatorException {
        if (!(this.computeCloudBuffer || this.computeCloudShadow || this.refineClassificationNearCoastlines)) {
            this.setTargetProduct(this.landsatCloudProduct);
        } else {
            Product postProcessedCloudProduct = OperatorUtils.createCompatibleProduct(this.landsatCloudProduct, "postProcessedCloud", "postProcessedCloud");
            if (this.waterMaskProduct != null) {
                this.waterFractionBand = this.waterMaskProduct.getBand("land_water_fraction");
            }
            this.geoCoding = this.landsatCloudProduct.getSceneGeoCoding();
            String cloudClassifBandName = "pixel_classif_flags";
            this.origCloudFlagBand = this.landsatCloudProduct.getBand("pixel_classif_flags");
            int extendedWidth = 64;
            int extendedHeight = 64;
            this.rectCalculator = new RectangleExtender(new Rectangle(this.landsatCloudProduct.getSceneRasterWidth(), this.landsatCloudProduct.getSceneRasterHeight()), extendedWidth, extendedHeight);
            ProductUtils.copyBand((String)"pixel_classif_flags", (Product)this.landsatCloudProduct, (Product)postProcessedCloudProduct, (boolean)false);
            this.setTargetProduct(postProcessedCloudProduct);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle srcRectangle = this.rectCalculator.extend(targetRectangle);
        Tile sourceFlagTile = this.getSourceTile((RasterDataNode)this.origCloudFlagBand, srcRectangle);
        Tile waterFractionTile = null;
        if (this.waterFractionBand != null) {
            waterFractionTile = this.getSourceTile((RasterDataNode)this.waterFractionBand, srcRectangle);
        }
        for (int y = srcRectangle.y; y < srcRectangle.y + srcRectangle.height; ++y) {
            this.checkForCancellation();
            for (int x = srcRectangle.x; x < srcRectangle.x + srcRectangle.width; ++x) {
                if (!targetRectangle.contains(x, y)) continue;
                this.combineFlags(x, y, sourceFlagTile, targetTile);
                this.postProcess(x, y, targetTile, srcRectangle, sourceFlagTile, waterFractionTile, 12, 13);
                this.postProcess(x, y, targetTile, srcRectangle, sourceFlagTile, waterFractionTile, 14, 15);
                this.postProcess(x, y, targetTile, srcRectangle, sourceFlagTile, waterFractionTile, 16, 17);
                this.postProcess(x, y, targetTile, srcRectangle, sourceFlagTile, waterFractionTile, 18, 19);
                this.postProcess(x, y, targetTile, srcRectangle, sourceFlagTile, waterFractionTile, 3, 4);
                targetTile.setSample(x, y, 1, targetTile.getSampleBit(x, y, 3));
            }
        }
        if (this.computeCloudShadow) {
            // empty if block
        }
    }

    private void postProcess(int x, int y, Tile targetTile, Rectangle srcRectangle, Tile sourceFlagTile, Tile waterFractionTile, int cloudFlagBit, int cloudBufferFlagBit) {
        boolean isCloudAfterRefinement;
        boolean isCloud = sourceFlagTile.getSampleBit(x, y, cloudFlagBit);
        if (this.refineClassificationNearCoastlines && waterFractionTile != null && this.isNearCoastline(x, y, waterFractionTile, srcRectangle)) {
            targetTile.setSample(x, y, 9, true);
            this.refineSnowIceFlaggingForCoastlines(x, y, sourceFlagTile, targetTile);
            if (isCloud) {
                this.refineCloudFlaggingForCoastlines(x, y, cloudFlagBit, sourceFlagTile, waterFractionTile, targetTile, srcRectangle);
            }
        }
        if (isCloudAfterRefinement = targetTile.getSampleBit(x, y, cloudFlagBit)) {
            targetTile.setSample(x, y, 6, false);
            if (this.computeCloudBuffer) {
                CloudBuffer.computeSimpleCloudBuffer(x, y, targetTile, targetTile, this.cloudBufferWidth, cloudFlagBit, cloudBufferFlagBit);
            }
        }
    }

    private void combineFlags(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        int sourceFlags = sourceFlagTile.getSampleInt(x, y);
        int computedFlags = targetTile.getSampleInt(x, y);
        targetTile.setSample(x, y, sourceFlags | computedFlags);
    }

    private boolean isCoastlinePixel(int x, int y, Tile waterFractionTile) {
        int waterFraction;
        boolean isCoastline = false;
        if (this.getGeoPos((int)x, (int)y).lat > -58.0 && (waterFraction = waterFractionTile.getSampleInt(x, y)) <= 100) {
            isCoastline = waterFraction < 100 && waterFraction > 0;
        }
        return isCoastline;
    }

    private GeoPos getGeoPos(int x, int y) {
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos((double)x, (double)y);
        this.geoCoding.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    private boolean isNearCoastline(int x, int y, Tile waterFractionTile, Rectangle rectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, rectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, rectangle.y + rectangle.height - 1);
        int waterFractionCenter = waterFractionTile.getSampleInt(x, y);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                if (!rectangle.contains(i, j) || !(!(this.landsatCloudProduct.getSceneGeoCoding() instanceof TiePointGeoCoding) && !(this.landsatCloudProduct.getSceneGeoCoding() instanceof CrsGeoCoding) ? waterFractionTile.getSampleInt(i, j) != waterFractionCenter : this.isCoastlinePixel(i, j, waterFractionTile))) continue;
                return true;
            }
        }
        return false;
    }

    private void refineCloudFlaggingForCoastlines(int x, int y, int cloudFlagBit, Tile sourceFlagTile, Tile waterFractionTile, Tile targetTile, Rectangle srcRectangle) {
        boolean windowWidth = true;
        int LEFT_BORDER = Math.max(x - 1, srcRectangle.x);
        int RIGHT_BORDER = Math.min(x + 1, srcRectangle.x + srcRectangle.width - 1);
        int TOP_BORDER = Math.max(y - 1, srcRectangle.y);
        int BOTTOM_BORDER = Math.min(y + 1, srcRectangle.y + srcRectangle.height - 1);
        boolean removeCloudFlag = true;
        if (CloudShadowFronts.isPixelSurrounded(x, y, sourceFlagTile, cloudFlagBit)) {
            removeCloudFlag = false;
        } else {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            block0: for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    boolean is_cloud = sourceFlagTile.getSampleBit(i, j, cloudFlagBit);
                    if (!is_cloud || !targetTileRectangle.contains(i, j) || this.isNearCoastline(i, j, waterFractionTile, srcRectangle)) continue;
                    removeCloudFlag = false;
                    continue block0;
                }
            }
        }
        if (removeCloudFlag) {
            targetTile.setSample(x, y, 12, false);
            targetTile.setSample(x, y, 18, false);
            targetTile.setSample(x, y, 14, false);
            targetTile.setSample(x, y, 16, false);
            targetTile.setSample(x, y, 1, false);
            targetTile.setSample(x, y, 3, false);
            targetTile.setSample(x, y, 2, false);
        }
    }

    private void refineSnowIceFlaggingForCoastlines(int x, int y, Tile sourceFlagTile, Tile targetTile) {
        boolean isSnowIce = sourceFlagTile.getSampleBit(x, y, 6);
        if (isSnowIce) {
            targetTile.setSample(x, y, 6, false);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(Landsat8PostProcessOp.class);
        }
    }
}

