/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.landsat8;

import org.esa.s3tbx.idepix.algorithms.landsat8.Landsat8Constants;
import org.esa.s3tbx.idepix.algorithms.landsat8.Landsat8PixelProperties;

public class Landsat8Algorithm
implements Landsat8PixelProperties {
    private static final int NN_CATEGORY_CLEAR_SKY = 1;
    private static final int NN_CATEGORY_NON_CLEAR_SKY = 3;
    private static final int NN_CATEGORY_CLOUD = 4;
    private static final int NN_CATEGORY_CLEAR_SKY_SNOW_ICE = 5;
    private float[] l8SpectralBandData;
    private int brightnessBandLand;
    private float brightnessThreshLand;
    private int brightnessBand1Water;
    private float brightnessWeightBand1Water;
    private int brightnessBand2Water;
    private float brightnessWeightBand2Water;
    private float brightnessThreshWater;
    private int whitenessBand1Land;
    private int whitenessBand2Land;
    private float whitenessThreshLand;
    private int whitenessBand1Water;
    private int whitenessBand2Water;
    private float whitenessThreshWater;
    private boolean isLand;
    private boolean isInvalid;
    private boolean applyShimezCloudTest;
    private float shimezDiffThresh;
    private float shimezMeanThresh;
    private boolean applyHotCloudTest;
    private float hotThresh;
    private double clostThresh;
    private boolean applyClostCloudTest;
    private float clostValue;
    private float otsuValue;
    private boolean applyOtsuCloudTest;
    private double[] nnResult;
    private double darkGlintThresholdTest1;
    private double darkGlintThresholdTest2;
    private int darkGlintThresholdTest1Wvl;
    private int darkGlintThresholdTest2Wvl;
    double nnCloudAmbiguousLowerBoundaryValue;
    double nnCloudAmbiguousSureSeparationValue;
    double nnCloudSureSnowSeparationValue;

    @Override
    public boolean isInvalid() {
        return this.isInvalid;
    }

    @Override
    public boolean isCloud() {
        return this.isCloudSure();
    }

    @Override
    public boolean isCloudAmbiguous() {
        return !this.isInvalid() && this.getNnClassification()[0] == 3;
    }

    @Override
    public boolean isCloudSure() {
        boolean isCloudShimez = this.applyShimezCloudTest && this.isCloudShimez();
        boolean isCloudClost = this.applyClostCloudTest && this.isCloudClost();
        boolean isCloudOtsu = this.applyOtsuCloudTest && this.isCloudOtsu();
        boolean nnCloud = this.nnResult[0] == 4.0;
        return !this.isInvalid() && (isCloudShimez || isCloudClost || isCloudOtsu || nnCloud && !this.isLand());
    }

    @Override
    public boolean isCloudBuffer() {
        return false;
    }

    @Override
    public boolean isCloudShadow() {
        return false;
    }

    @Override
    public boolean isSnowIce() {
        return this.nnResult[0] == 5.0;
    }

    @Override
    public boolean isGlintRisk() {
        return false;
    }

    @Override
    public boolean isCoastline() {
        return false;
    }

    @Override
    public boolean isLand() {
        return this.isLand;
    }

    @Override
    public boolean isBright() {
        if (this.isLand()) {
            Integer landBandIndex = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.brightnessBandLand);
            return !this.isInvalid() && this.l8SpectralBandData[landBandIndex] > this.brightnessThreshLand;
        }
        Integer waterBand1Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.brightnessBand1Water);
        Integer waterBand2Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.brightnessBand2Water);
        float brightnessWaterValue = this.brightnessWeightBand1Water * this.l8SpectralBandData[waterBand1Index] + this.brightnessWeightBand2Water * this.l8SpectralBandData[waterBand2Index];
        return !this.isInvalid() && brightnessWaterValue > this.brightnessThreshWater;
    }

    @Override
    public boolean isWhite() {
        if (this.isLand()) {
            Integer whitenessBand1Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.whitenessBand1Land);
            Integer whitenessBand2Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.whitenessBand2Land);
            float whiteness = this.l8SpectralBandData[whitenessBand1Index] / this.l8SpectralBandData[whitenessBand2Index];
            return !this.isInvalid() && whiteness < this.whitenessThreshLand;
        }
        Integer whitenessBand1Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.whitenessBand1Water);
        Integer whitenessBand2Index = Landsat8Constants.LANDSAT8_SPECTRAL_WAVELENGTH_MAP.get(this.whitenessBand2Water);
        float whiteness = this.l8SpectralBandData[whitenessBand1Index] / this.l8SpectralBandData[whitenessBand2Index];
        return !this.isInvalid() && whiteness < this.whitenessThreshWater;
    }

    public void setNnResult(double[] nnResult) {
        this.nnResult = nnResult;
    }

    public double[] getNnResult() {
        return this.nnResult;
    }

    public int[] getNnClassification() {
        return this.classifyNNResult(this.nnResult);
    }

    public boolean isCloudShimez() {
        double blueGreenRatio = this.l8SpectralBandData[1] / this.l8SpectralBandData[2];
        double redGreenRatio = this.l8SpectralBandData[3] / this.l8SpectralBandData[2];
        double mean = (double)(this.l8SpectralBandData[1] + this.l8SpectralBandData[2] + this.l8SpectralBandData[3]) / 3.0;
        return Math.abs(blueGreenRatio - 1.0) < (double)this.shimezDiffThresh && Math.abs(redGreenRatio - 1.0) < (double)this.shimezDiffThresh && mean > (double)this.shimezMeanThresh;
    }

    public boolean isCloudHot() {
        double hot = (double)this.l8SpectralBandData[1] - 0.5 * (double)this.l8SpectralBandData[3];
        return hot > (double)this.hotThresh;
    }

    public boolean isCloudClost() {
        if (this.applyOtsuCloudTest) {
            return (double)this.clostValue > this.clostThresh;
        }
        double clost = this.l8SpectralBandData[0] * this.l8SpectralBandData[1] * this.l8SpectralBandData[7] * this.l8SpectralBandData[8];
        return clost > this.clostThresh;
    }

    public boolean isCloudOtsu() {
        return this.otsuValue > 128.0f;
    }

    public void setL8SpectralBandData(float[] l8SpectralBandData) {
        this.l8SpectralBandData = l8SpectralBandData;
    }

    public void setIsLand(boolean isLand) {
        this.isLand = isLand;
    }

    public void setInvalid(boolean isInvalid) {
        this.isInvalid = isInvalid;
    }

    public void setBrightnessBandLand(int brightnessBandLand) {
        this.brightnessBandLand = brightnessBandLand;
    }

    public void setBrightnessThreshLand(float brightnessThreshLand) {
        this.brightnessThreshLand = brightnessThreshLand;
    }

    public void setBrightnessBand1Water(int brightnessBand1Water) {
        this.brightnessBand1Water = brightnessBand1Water;
    }

    public void setBrightnessWeightBand1Water(float brightnessWeightBand1Water) {
        this.brightnessWeightBand1Water = brightnessWeightBand1Water;
    }

    public void setBrightnessBand2Water(int brightnessBand2Water) {
        this.brightnessBand2Water = brightnessBand2Water;
    }

    public void setBrightnessWeightBand2Water(float brightnessWeightBand2Water) {
        this.brightnessWeightBand2Water = brightnessWeightBand2Water;
    }

    public void setBrightnessThreshWater(float brightnessThreshWater) {
        this.brightnessThreshWater = brightnessThreshWater;
    }

    public void setWhitenessBand1Land(int whitenessBand1Land) {
        this.whitenessBand1Land = whitenessBand1Land;
    }

    public void setWhitenessBand2Land(int whitenessBand2Land) {
        this.whitenessBand2Land = whitenessBand2Land;
    }

    public void setWhitenessThreshLand(float whitenessThreshLand) {
        this.whitenessThreshLand = whitenessThreshLand;
    }

    public void setWhitenessThreshWater(float whitenessThreshWater) {
        this.whitenessThreshWater = whitenessThreshWater;
    }

    public void setWhitenessBand1Water(int whitenessBand1Water) {
        this.whitenessBand1Water = whitenessBand1Water;
    }

    public void setWhitenessBand2Water(int whitenessBand2Water) {
        this.whitenessBand2Water = whitenessBand2Water;
    }

    public void setApplyShimezCloudTest(boolean applyShimezCloudTest) {
        this.applyShimezCloudTest = applyShimezCloudTest;
    }

    public void setShimezDiffThresh(float shimezDiffThresh) {
        this.shimezDiffThresh = shimezDiffThresh;
    }

    public void setShimezMeanThresh(float shimezMeanThresh) {
        this.shimezMeanThresh = shimezMeanThresh;
    }

    public void setApplyHotCloudTest(boolean applyHotCloudTest) {
        this.applyHotCloudTest = applyHotCloudTest;
    }

    public void setHotThresh(float hotThresh) {
        this.hotThresh = hotThresh;
    }

    public void setClostThresh(double clostThresh) {
        this.clostThresh = clostThresh;
    }

    public void setApplyClostCloudTest(boolean applyClostCloudTest) {
        this.applyClostCloudTest = applyClostCloudTest;
    }

    public void setClostValue(float clostValue) {
        this.clostValue = clostValue;
    }

    public void setOtsuValue(float otsuValue) {
        this.otsuValue = otsuValue;
    }

    public void setApplyOtsuCloudTest(boolean applyOtsuCloudTest) {
        this.applyOtsuCloudTest = applyOtsuCloudTest;
    }

    public void setDarkGlintThresholdTest1(double darkThreshold865) {
        this.darkGlintThresholdTest1 = darkThreshold865;
    }

    public void setDarkGlintThresholdTest1Wvl(int darkGlintThresholdTest1Wvl) {
        this.darkGlintThresholdTest1Wvl = darkGlintThresholdTest1Wvl;
    }

    public void setDarkGlintThresholdTest2(double darkThreshold1610) {
        this.darkGlintThresholdTest2 = darkThreshold1610;
    }

    public void setDarkGlintThresholdTest2Wvl(int darkGlintThresholdTest2Wvl) {
        this.darkGlintThresholdTest2Wvl = darkGlintThresholdTest2Wvl;
    }

    private int[] classifyNNResult(double[] netResult) {
        double netResultValue = netResult[0];
        int[] nnClassification = new int[netResult.length];
        nnClassification[0] = netResultValue < this.nnCloudAmbiguousLowerBoundaryValue ? 1 : (netResultValue >= this.nnCloudAmbiguousLowerBoundaryValue && netResultValue < this.nnCloudAmbiguousSureSeparationValue ? 3 : (netResultValue >= this.nnCloudAmbiguousSureSeparationValue && netResultValue < this.nnCloudSureSnowSeparationValue ? 4 : 5));
        return nnClassification;
    }

    public void setNnCloudAmbiguousLowerBoundaryValue(double nnCloudAmbiguousLowerBoundaryValue) {
        this.nnCloudAmbiguousLowerBoundaryValue = nnCloudAmbiguousLowerBoundaryValue;
    }

    public void setNnCloudAmbiguousSureSeparationValue(double nnCloudAmbiguousSureSeparationValue) {
        this.nnCloudAmbiguousSureSeparationValue = nnCloudAmbiguousSureSeparationValue;
    }

    public void setNnCloudSureSnowSeparationValue(double nnCloudSureSnowSeparationValue) {
        this.nnCloudSureSnowSeparationValue = nnCloudSureSnowSeparationValue;
    }
}

