/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.idepix.algorithms.avhrr.AbstractAvhrrClassificationOp;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAcUtils;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAlgorithm;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrAuxdata;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrConstants;
import org.esa.s3tbx.idepix.core.util.SchillerNeuralNetWrapper;
import org.esa.s3tbx.idepix.core.util.SunPosition;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;

@OperatorMetadata(alias="Idepix.Avhrr.Usgs.Classification", version="2.2", internal=true, authors="Olaf Danne", copyright="(c) 2016 by Brockmann Consult", description="Basic operator for pixel classification from AVHRR L1b data.")
public class AvhrrUSGSClassificationOp
extends AbstractAvhrrClassificationOp {
    @SourceProduct(alias="aacl1b", description="The source product.")
    Product sourceProduct;
    @SourceProduct(alias="waterMask")
    private Product waterMaskProduct;
    @TargetProduct(description="The target product.")
    Product targetProduct;
    @Parameter(defaultValue="2.15", label=" Schiller NN cloud ambiguous lower boundary ", description=" Schiller NN cloud ambiguous lower boundary ")
    double avhrracSchillerNNCloudAmbiguousLowerBoundaryValue;
    @Parameter(defaultValue="3.45", label=" Schiller NN cloud ambiguous/sure separation value ", description=" Schiller NN cloud ambiguous cloud ambiguous/sure separation value ")
    double avhrracSchillerNNCloudAmbiguousSureSeparationValue;
    @Parameter(defaultValue="4.45", label=" Schiller NN cloud sure/snow separation value ", description=" Schiller NN cloud ambiguous cloud sure/snow separation value ")
    double avhrracSchillerNNCloudSureSnowSeparationValue;
    ElevationModel getasseElevationModel;

    public void prepareInputs() throws OperatorException {
        this.setNoaaId();
        this.readSchillerNets();
        this.createTargetProduct();
        this.computeSunPosition();
        if (this.sourceProduct.getSceneGeoCoding() == null) {
            this.sourceProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(this.sourceProduct.getTiePointGrid("latitude"), this.sourceProduct.getTiePointGrid("longitude")));
        }
        try {
            this.vzaTable = AvhrrAuxdata.getInstance().createLine2ViewZenithTable();
            this.rad2BTTable = AvhrrAuxdata.getInstance().createRad2BTTable(this.noaaId);
        }
        catch (IOException e) {
            throw new OperatorException("Failed to get VZA from auxdata - cannot proceed: ", (Throwable)e);
        }
        String demName = "GETASSE30";
        ElevationModelDescriptor demDescriptor = ElevationModelRegistry.getInstance().getDescriptor("GETASSE30");
        if (demDescriptor == null || !demDescriptor.canBeDownloaded()) {
            throw new OperatorException("DEM cannot be downloaded: GETASSE30.");
        }
        this.getasseElevationModel = demDescriptor.createDem(Resampling.BILINEAR_INTERPOLATION);
    }

    static double computeRelativeAzimuth(double vaaRad, double saaRad) {
        return AvhrrUSGSClassificationOp.correctRelAzimuthRange(vaaRad, saaRad);
    }

    static double[] computeAzimuthAngles(double sza, double vza, GeoPos satPosition, GeoPos pointPosition, SunPosition sunPosition) {
        double latPoint = pointPosition.getLat();
        double lonPoint = pointPosition.getLon();
        double latSat = satPosition.getLat();
        double lonSat = satPosition.getLon();
        double latPointRad = latPoint * (Math.PI / 180);
        double lonPointRad = lonPoint * (Math.PI / 180);
        double latSatRad = latSat * (Math.PI / 180);
        double lonSatRad = lonSat * (Math.PI / 180);
        double latSunRad = sunPosition.getLat() * (Math.PI / 180);
        double lonSunRad = sunPosition.getLon() * (Math.PI / 180);
        double greatCirclePointToSatRad = AvhrrUSGSClassificationOp.computeGreatCircleFromPointToSat(latPointRad, lonPointRad, latSatRad, lonSatRad);
        double vaaRad = Math.abs(vza) >= 0.09 && greatCirclePointToSatRad > 0.0 ? AvhrrUSGSClassificationOp.computeVaa(latPointRad, lonPointRad, latSatRad, lonSatRad, greatCirclePointToSatRad) : 0.0;
        double saaRad = AvhrrUSGSClassificationOp.computeSaa(sza, latPointRad, lonPointRad, latSunRad, lonSunRad);
        return new double[]{saaRad, vaaRad, greatCirclePointToSatRad};
    }

    static double correctRelAzimuthRange(double vaaRad, double saaRad) {
        double relAzimuth = saaRad - vaaRad;
        if (relAzimuth < -Math.PI) {
            relAzimuth += Math.PI * 2;
        } else if (relAzimuth > Math.PI) {
            relAzimuth -= Math.PI * 2;
        }
        return Math.abs(relAzimuth);
    }

    static double computeGreatCircleFromPointToSat(double latPointRad, double lonPointRad, double latSatRad, double lonSatRad) {
        double greatCirclePointToSat = 6370.997 * Math.acos(Math.cos(latPointRad) * Math.cos(latSatRad) * Math.cos(lonPointRad - lonSatRad) + Math.sin(latPointRad) * Math.sin(latSatRad));
        return greatCirclePointToSat / 6370.997;
    }

    static double computeSaa(double sza, double latPointRad, double lonPointRad, double latSunRad, double lonSunRad) {
        double arg = (Math.sin(latSunRad) - Math.sin(latPointRad) * Math.cos(sza * (Math.PI / 180))) / (Math.cos(latPointRad) * Math.sin(sza * (Math.PI / 180)));
        arg = Math.min(Math.max(arg, -1.0), 1.0);
        double saaRad = Math.acos(arg);
        if (Math.sin(lonSunRad - lonPointRad) < 0.0) {
            saaRad = Math.PI * 2 - saaRad;
        }
        return saaRad;
    }

    static double computeVaa(double latPointRad, double lonPointRad, double latSatRad, double lonSatRad, double greatCirclePointToSatRad) {
        double arg = (Math.sin(latSatRad) - Math.sin(latPointRad) * Math.cos(greatCirclePointToSatRad)) / (Math.cos(latPointRad) * Math.sin(greatCirclePointToSatRad));
        arg = Math.min(Math.max(arg, -1.0), 1.0);
        double vaaRad = Math.acos(arg);
        if (Math.sin(lonSatRad - lonPointRad) < 0.0) {
            vaaRad = Math.PI * 2 - vaaRad;
        }
        return vaaRad;
    }

    @Override
    void readSchillerNets() {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("6x3_114.1.net");){
            this.avhrracNeuralNet = SchillerNeuralNetWrapper.create(is);
        }
        catch (IOException e) {
            throw new OperatorException("Cannot read Schiller neural nets: " + e.getMessage());
        }
    }

    @Override
    GeoPos computeSatPosition(int y) {
        return this.getGeoPos(this.sourceProduct.getSceneRasterWidth() / 2, y);
    }

    @Override
    void runAvhrrAcAlgorithm(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int targetSamplesIndex;
        AvhrrAlgorithm aacAlgorithm = new AvhrrAlgorithm();
        aacAlgorithm.setNoaaId(this.noaaId);
        aacAlgorithm.setDistanceCorr(this.getDistanceCorr());
        double sza = sourceSamples[0].getDouble();
        double latitude = sourceSamples[1].getDouble();
        double longitude = sourceSamples[2].getDouble();
        aacAlgorithm.setLatitude(latitude);
        aacAlgorithm.setLongitude(longitude);
        aacAlgorithm.setSza(sza);
        double vza = Math.abs(this.vzaTable.getVza(x));
        GeoPos satPosition = this.computeSatPosition(y);
        GeoPos pointPosition = this.getGeoPos(x, y);
        double[] azimuthAngles = AvhrrUSGSClassificationOp.computeAzimuthAngles(sza, vza, satPosition, pointPosition, this.sunPosition);
        double saaRad = azimuthAngles[0];
        double vaaRad = azimuthAngles[1];
        double relAzi = AvhrrUSGSClassificationOp.computeRelativeAzimuth(saaRad, vaaRad) * 57.29577951308232;
        double altitude = this.computeGetasseAltitude(x, y);
        double[] avhrrRadiance = new double[AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES.length];
        double albedo1 = sourceSamples[3].getDouble();
        double albedo2 = sourceSamples[4].getDouble();
        double d = this.getDistanceCorr() * Math.cos(sza * (Math.PI / 180));
        double albedo1Norm = albedo1 / d;
        double albedo2Norm = albedo2 / d;
        if (albedo1 >= 0.0 && albedo2 >= 0.0 && !AvhrrAcUtils.anglesInvalid(sza, vza, azimuthAngles[0], azimuthAngles[1])) {
            avhrrRadiance[0] = this.convertBetweenAlbedoAndRadiance(albedo1, sza, 0, 0);
            avhrrRadiance[1] = this.convertBetweenAlbedoAndRadiance(albedo2, sza, 0, 1);
            avhrrRadiance[2] = sourceSamples[5].getDouble();
            avhrrRadiance[3] = sourceSamples[6].getDouble();
            avhrrRadiance[4] = sourceSamples[7].getDouble();
            aacAlgorithm.setRadiance(avhrrRadiance);
            float waterFraction = Float.NaN;
            if (this.getGeoPos((int)x, (int)y).lat > -58.0) {
                waterFraction = sourceSamples[8].getFloat();
            }
            SchillerNeuralNetWrapper nnWrapper = (SchillerNeuralNetWrapper)this.avhrracNeuralNet.get();
            double[] inputVector = nnWrapper.getInputVector();
            inputVector[0] = sza;
            inputVector[1] = vza;
            inputVector[2] = relAzi;
            inputVector[3] = Math.sqrt(avhrrRadiance[0]);
            inputVector[4] = Math.sqrt(avhrrRadiance[1]);
            inputVector[5] = Math.sqrt(avhrrRadiance[3]);
            inputVector[6] = Math.sqrt(avhrrRadiance[4]);
            aacAlgorithm.setRadiance(avhrrRadiance);
            aacAlgorithm.setWaterFraction(waterFraction);
            double[] nnOutput = nnWrapper.getNeuralNet().calc(inputVector);
            aacAlgorithm.setNnOutput(nnOutput);
            aacAlgorithm.setAmbiguousLowerBoundaryValue(this.avhrracSchillerNNCloudAmbiguousLowerBoundaryValue);
            aacAlgorithm.setAmbiguousSureSeparationValue(this.avhrracSchillerNNCloudAmbiguousSureSeparationValue);
            aacAlgorithm.setSureSnowSeparationValue(this.avhrracSchillerNNCloudSureSnowSeparationValue);
            aacAlgorithm.setReflCh1(albedo1Norm / 100.0);
            aacAlgorithm.setReflCh2(albedo2Norm / 100.0);
            double btCh3 = AvhrrAcUtils.convertRadianceToBt(this.noaaId, this.rad2BTTable, avhrrRadiance[2], 3, waterFraction);
            aacAlgorithm.setBtCh3(btCh3);
            double btCh4 = AvhrrAcUtils.convertRadianceToBt(this.noaaId, this.rad2BTTable, avhrrRadiance[3], 4, waterFraction);
            aacAlgorithm.setBtCh4(btCh4);
            double btCh5 = AvhrrAcUtils.convertRadianceToBt(this.noaaId, this.rad2BTTable, avhrrRadiance[4], 5, waterFraction);
            aacAlgorithm.setBtCh5(btCh5);
            aacAlgorithm.setElevation(altitude);
            double albedo3 = this.calculateReflectancePartChannel3b(avhrrRadiance[2], btCh4, btCh5, sza);
            aacAlgorithm.setReflCh3(albedo3);
            this.setClassifFlag(targetSamples, aacAlgorithm);
            targetSamplesIndex = 1;
            targetSamples[targetSamplesIndex++].set(vza);
            targetSamples[targetSamplesIndex++].set(sza);
            targetSamples[targetSamplesIndex++].set(vaaRad * 57.29577951308232);
            targetSamples[targetSamplesIndex++].set(saaRad * 57.29577951308232);
            targetSamples[targetSamplesIndex++].set(relAzi);
            targetSamples[targetSamplesIndex++].set(altitude);
            targetSamples[targetSamplesIndex++].set(btCh3);
            targetSamples[targetSamplesIndex++].set(btCh4);
            targetSamples[targetSamplesIndex++].set(btCh5);
            targetSamples[targetSamplesIndex++].set(albedo1Norm / 100.0);
            targetSamples[targetSamplesIndex++].set(albedo2Norm / 100.0);
            targetSamples[targetSamplesIndex++].set(albedo3);
        } else {
            targetSamplesIndex = 0;
            targetSamples[targetSamplesIndex++].set(0, true);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            targetSamples[targetSamplesIndex++].set(Float.NaN);
            avhrrRadiance[0] = Double.NaN;
            avhrrRadiance[1] = Double.NaN;
        }
        if (this.aacCopyRadiances) {
            for (int i = 2; i < AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES.length; ++i) {
                targetSamples[targetSamplesIndex + (i - 2)].set(avhrrRadiance[i]);
            }
        }
    }

    private double computeGetasseAltitude(float x, float y) {
        double altitude;
        PixelPos pixelPos = new PixelPos((double)(x + 0.5f), (double)(y + 0.5f));
        GeoPos geoPos = this.sourceProduct.getSceneGeoCoding().getGeoPos(pixelPos, null);
        try {
            altitude = this.getasseElevationModel.getElevation(geoPos);
        }
        catch (Exception e) {
            e.printStackTrace();
            altitude = 0.0;
        }
        return altitude;
    }

    @Override
    void setClassifFlag(WritableSample[] targetSamples, AvhrrAlgorithm algorithm) {
        targetSamples[0].set(0, algorithm.isInvalid());
        targetSamples[0].set(1, algorithm.isCloud());
        targetSamples[0].set(2, algorithm.isCloudAmbiguous());
        targetSamples[0].set(3, algorithm.isCloudSure());
        targetSamples[0].set(4, algorithm.isCloudBuffer());
        targetSamples[0].set(5, algorithm.isCloudShadow());
        targetSamples[0].set(6, algorithm.isSnowIce());
        targetSamples[0].set(9, algorithm.isCoastline());
        targetSamples[0].set(10, algorithm.isLand());
    }

    @Override
    String getProductDatestring() {
        int productNameStartIndex = this.sourceProduct.getName().indexOf("ao");
        return this.sourceProduct.getName().substring(productNameStartIndex + 4, productNameStartIndex + 10);
    }

    @Override
    void setNoaaId() {
        int productNameStartIndex = this.sourceProduct.getName().indexOf("ao");
        this.noaaId = this.sourceProduct.getName().substring(productNameStartIndex + 2, productNameStartIndex + 4);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        int i;
        int index = 0;
        sampleConfigurer.defineSample(index++, "sun_zenith");
        sampleConfigurer.defineSample(index++, "latitude");
        sampleConfigurer.defineSample(index++, "longitude");
        for (i = 0; i < 2; ++i) {
            sampleConfigurer.defineSample(index++, AvhrrConstants.AVHRR_AC_ALBEDO_BAND_NAMES[i]);
        }
        for (i = 0; i < 3; ++i) {
            sampleConfigurer.defineSample(index++, AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES[i + 2]);
        }
        sampleConfigurer.defineSample(index, "land_water_fraction", this.waterMaskProduct);
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        int index = 0;
        sampleConfigurer.defineSample(index++, "pixel_classif_flags");
        sampleConfigurer.defineSample(index++, "vza");
        sampleConfigurer.defineSample(index++, "sza");
        sampleConfigurer.defineSample(index++, "vaa");
        sampleConfigurer.defineSample(index++, "saa");
        sampleConfigurer.defineSample(index++, "rel_azimuth");
        sampleConfigurer.defineSample(index++, "altitude");
        sampleConfigurer.defineSample(index++, "bt_3");
        sampleConfigurer.defineSample(index++, "bt_4");
        sampleConfigurer.defineSample(index++, "bt_5");
        sampleConfigurer.defineSample(index++, "refl_1");
        sampleConfigurer.defineSample(index++, "refl_2");
        sampleConfigurer.defineSample(index++, "rt_3");
        if (this.aacCopyRadiances) {
            for (int i = 2; i < AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES.length; ++i) {
                sampleConfigurer.defineSample(index++, AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES[i]);
            }
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        Band classifFlagBand = productConfigurer.addBand("pixel_classif_flags", 11);
        classifFlagBand.setDescription("Pixel classification flag");
        classifFlagBand.setUnit("dl");
        FlagCoding flagCoding = AvhrrAcUtils.createAvhrrAcFlagCoding("pixel_classif_flags");
        classifFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.getTargetProduct().getFlagCodingGroup().add((ProductNode)flagCoding);
        productConfigurer.copyGeoCoding();
        AvhrrAcUtils.setupAvhrrAcClassifBitmask(this.getTargetProduct());
        Band vzaBand = productConfigurer.addBand("vza", 30);
        vzaBand.setDescription("view zenith angle");
        vzaBand.setUnit("dl");
        vzaBand.setNoDataValue(Double.NaN);
        vzaBand.setNoDataValueUsed(true);
        Band szaBand = productConfigurer.addBand("sza", 30);
        szaBand.setDescription("sun zenith angle");
        szaBand.setUnit("dl");
        szaBand.setNoDataValue(Double.NaN);
        szaBand.setNoDataValueUsed(true);
        Band vaaBand = productConfigurer.addBand("vaa", 30);
        vaaBand.setDescription("view azimuth angle");
        vaaBand.setUnit("dl");
        vaaBand.setNoDataValue(Double.NaN);
        vaaBand.setNoDataValueUsed(true);
        Band saaBand = productConfigurer.addBand("saa", 30);
        saaBand.setDescription("sun azimuth angle");
        saaBand.setUnit("dl");
        saaBand.setNoDataValue(Double.NaN);
        saaBand.setNoDataValueUsed(true);
        Band relaziBand = productConfigurer.addBand("rel_azimuth", 30);
        relaziBand.setDescription("relative azimuth");
        relaziBand.setUnit("deg");
        relaziBand.setNoDataValue(Double.NaN);
        relaziBand.setNoDataValueUsed(true);
        Band altitudeBand = productConfigurer.addBand("altitude", 30);
        altitudeBand.setDescription("Altitude from GETASSE");
        altitudeBand.setUnit("m");
        altitudeBand.setNoDataValue(Double.NaN);
        altitudeBand.setNoDataValueUsed(true);
        Band bt3Band = productConfigurer.addBand("bt_3", 30);
        bt3Band.setDescription("Channel 3 brightness temperature");
        bt3Band.setUnit("K");
        bt3Band.setNoDataValue(Double.NaN);
        bt3Band.setNoDataValueUsed(true);
        Band bt4Band = productConfigurer.addBand("bt_4", 30);
        bt4Band.setDescription("Channel 4 brightness temperature");
        bt4Band.setUnit("K");
        bt4Band.setNoDataValue(Double.NaN);
        bt4Band.setNoDataValueUsed(true);
        Band bt5Band = productConfigurer.addBand("bt_5", 30);
        bt5Band.setDescription("Channel 5 brightness temperature");
        bt5Band.setUnit("K");
        bt5Band.setNoDataValue(Double.NaN);
        bt5Band.setNoDataValueUsed(true);
        Band refl1Band = productConfigurer.addBand("refl_1", 30);
        refl1Band.setDescription("Channel 1 TOA reflectance");
        refl1Band.setUnit("dl");
        refl1Band.setNoDataValue(Double.NaN);
        refl1Band.setNoDataValueUsed(true);
        Band refl2Band = productConfigurer.addBand("refl_2", 30);
        refl2Band.setDescription("Channel 2 TOA reflectance");
        refl2Band.setUnit("dl");
        refl2Band.setNoDataValue(Double.NaN);
        refl2Band.setNoDataValueUsed(true);
        Band refl3Band = productConfigurer.addBand("rt_3", 30);
        refl3Band.setDescription("Channel 3 reflective part (rt3)");
        refl3Band.setUnit("dl");
        refl3Band.setNoDataValue(Double.NaN);
        refl3Band.setNoDataValueUsed(true);
        if (this.aacCopyRadiances) {
            for (int i = 2; i < AvhrrConstants.AVHRR_AC_RADIANCE_BAND_NAMES.length; ++i) {
                Band radianceBand = productConfigurer.addBand("radiance_" + (i + 1), 30);
                radianceBand.setDescription("TOA radiance band " + (i + 1));
                radianceBand.setUnit("mW/(m^2 sr cm^-1)");
                radianceBand.setNoDataValue(Double.NaN);
                radianceBand.setNoDataValueUsed(true);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AvhrrUSGSClassificationOp.class);
        }
    }
}

