/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms.avhrr;

import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrConstants;
import org.esa.s3tbx.idepix.algorithms.avhrr.AvhrrPixelProperties;
import org.esa.s3tbx.idepix.core.util.IdepixIO;

public class AvhrrAlgorithm
implements AvhrrPixelProperties {
    float waterFraction;
    double[] radiance;
    double[] nnOutput;
    double avhrracSchillerNNCloudAmbiguousLowerBoundaryValue;
    double avhrracSchillerNNCloudAmbiguousSureSeparationValue;
    double avhrracSchillerNNCloudSureSnowSeparationValue;
    double reflCh1;
    double reflCh2;
    double reflCh3;
    double btCh3;
    double btCh4;
    double btCh5;
    double rho3b;
    double emissivity3b;
    double ndsi;
    String noaaId;
    double distanceCorr;
    double sza;
    private double latitude;
    private double longitude;
    private double elevation;

    @Override
    public boolean isInvalid() {
        return !IdepixIO.areAllReflectancesValid(this.radiance);
    }

    @Override
    public boolean isCloud() {
        return this.isCloudAmbiguous() || this.isCloudSure();
    }

    @Override
    public boolean isSnowIce() {
        boolean isSnowIce;
        boolean bl = isSnowIce = !this.isCloudTgct() && this.ndsi > 0.8;
        if (!isSnowIce && this.nnOutput != null) {
            isSnowIce = this.nnOutput[0] > this.avhrracSchillerNNCloudSureSnowSeparationValue && this.nnOutput[0] <= 5.0;
        }
        isSnowIce = false;
        double btCh3Celsius = this.btCh3 - 273.15;
        double btCh4Celsius = this.btCh4 - 273.15;
        double btCh5Celsius = this.btCh5 - 273.15;
        double ratio21 = this.reflCh2 / this.reflCh1;
        double diffbt53 = btCh5Celsius - btCh3Celsius;
        double ratiobt53 = btCh5Celsius / btCh3Celsius;
        double diffrefl1rt3 = this.reflCh1 - this.reflCh3;
        double sumrefl2rt3 = this.reflCh2 + this.reflCh3;
        if (this.latitude > 62.0) {
            boolean condBtCh4 = -15.0 < btCh4Celsius && btCh4Celsius < 1.35;
            boolean condElevation = this.elevation > 300.0;
            boolean cond1 = condBtCh4 && this.reflCh1 > 0.4 && 0.95 <= ratio21 && ratio21 < 1.15 && this.reflCh3 < 0.054 && condElevation && diffbt53 > -14.0 && ratiobt53 > 1.7;
            boolean cond2 = condBtCh4 && this.reflCh1 > 0.4 && 0.8 <= ratio21 && ratio21 < 1.15 && this.reflCh3 < 0.054 && this.reflCh3 > 0.026 && condElevation && diffbt53 > -13.0 && ratiobt53 <= -0.98;
            boolean cond3 = condBtCh4 && this.reflCh1 > 0.4 && 0.8 <= ratio21 && ratio21 < 1.15 && this.reflCh3 < 0.054 && condElevation && diffbt53 > -11.0 && ratiobt53 <= 1.7 && ratiobt53 > -0.98;
            boolean cond4 = diffrefl1rt3 / sumrefl2rt3 > 1.1 && diffbt53 > -8.0;
            boolean snowIceCondition = cond1 || cond2 || cond3 || cond4;
            isSnowIce = this.isLand() && snowIceCondition;
        } else {
            isSnowIce = this.latitude < -62.0 ? -27.0 < btCh4Celsius && btCh4Celsius < 1.35 && this.reflCh1 > 0.75 && ratio21 > 0.85 && ratio21 < 1.15 && this.reflCh3 < 0.03 && diffbt53 > -13.0 || (this.reflCh1 - this.reflCh3) / (this.reflCh2 + this.reflCh3) > 1.05 && this.reflCh1 > 0.55 : this.isLand() && -15.0 < btCh4Celsius && btCh4Celsius < 1.35 && this.reflCh1 > 0.4 && ratio21 > 0.8 && ratio21 < 1.15 && this.reflCh3 < 0.054 && diffbt53 > -14.0 && this.elevation > 1000.0;
        }
        return isSnowIce;
    }

    @Override
    public boolean isCloudAmbiguous() {
        return this.isCloudSure();
    }

    @Override
    public boolean isCloudSure() {
        boolean isCloudFromOldSnowIce;
        if (this.isSnowIce()) {
            return false;
        }
        boolean isCloudAdditional = this.isCloudSnowIceFromDecisionTree();
        if (isCloudAdditional) {
            return true;
        }
        boolean isCloudSureSchiller = this.isCloudSureSchiller();
        if (isCloudSureSchiller) {
            return true;
        }
        boolean bl = isCloudFromOldSnowIce = !this.isCloudTgct() && this.ndsi > 0.8;
        if (!isCloudFromOldSnowIce && this.nnOutput != null) {
            boolean bl2 = isCloudFromOldSnowIce = this.nnOutput[0] > this.avhrracSchillerNNCloudSureSnowSeparationValue && this.nnOutput[0] <= 5.0;
        }
        if (isCloudFromOldSnowIce) {
            return true;
        }
        boolean isResidualCloud = this.isResidualCloud();
        return isResidualCloud;
    }

    private boolean isResidualCloud() {
        if (this.isDesertArea()) {
            return this.reflCh3 < 0.18 && this.reflCh1 > 0.15 && this.btCh4 / this.btCh3 < 0.927 && this.btCh4 < 280.0 || (this.reflCh1 + this.reflCh2 + this.reflCh3) / 3.0 > 0.23 && this.btCh4 < 302.0 && this.btCh4 / this.btCh3 < 0.95 && this.reflCh3 < 0.38 && this.reflCh3 > 0.219;
        }
        return this.reflCh3 < 0.18 && this.reflCh1 > 0.15 && this.btCh4 / this.btCh3 < 0.927 || (this.reflCh1 + this.reflCh2 + this.reflCh3) / 3.0 > 0.2 && this.btCh4 < 302.0 && this.btCh4 / this.btCh3 < 0.95 && this.reflCh3 < 0.4;
    }

    private boolean isCloudSureSchiller() {
        boolean isCloudSureSchiller = this.nnOutput != null ? this.nnOutput[0] >= this.avhrracSchillerNNCloudAmbiguousSureSeparationValue && this.nnOutput[0] < this.avhrracSchillerNNCloudSureSnowSeparationValue : false;
        return isCloudSureSchiller;
    }

    private boolean isCloudSnowIceFromDecisionTree() {
        double ndvi = (this.reflCh2 - this.reflCh1) / (this.reflCh2 + this.reflCh1);
        double rgctThresh = this.getRgctThreshold(ndvi);
        boolean isCloudRGCT = this.isLand() && this.reflCh1 > rgctThresh;
        double rrctThresh = 1.1;
        boolean isCloudRRCT = this.isLand() && !this.isDesertArea() && this.reflCh2 / this.reflCh1 < 1.1;
        double c3atThresh = 0.06;
        boolean isCloudC3AT = this.isLand() && !this.isDesertArea() && this.rho3b > 0.06;
        boolean isCloudTGCT = this.btCh4 < 260.0;
        double fmftThresh = this.getFmftThreshold();
        boolean isCloudFMFT = this.btCh4 - this.btCh5 > fmftThresh;
        double bt34 = this.btCh3 - this.btCh4;
        double tmftMinThresh = this.getTmftMinThreshold(bt34);
        double tmftMaxThresh = this.getTmftMaxThreshold(bt34);
        boolean isClearTMFT = bt34 > tmftMinThresh && bt34 < tmftMaxThresh;
        boolean isCloudEmissivity = this.emissivity3b > 0.022;
        boolean isCloudAdditional = false;
        if (!isClearTMFT && isCloudEmissivity) {
            if (isCloudRGCT && isCloudFMFT) {
                isCloudAdditional = true;
            }
            if (this.isDesertArea() && (isCloudFMFT || Math.abs(this.latitude) < 60.0 && isCloudTGCT) || !this.isDesertArea() && isCloudRRCT && isCloudFMFT || !this.isDesertArea() && isCloudRRCT && Math.abs(this.latitude) < 60.0 && isCloudTGCT || !this.isDesertArea() && isCloudRRCT && isCloudC3AT) {
                isCloudAdditional = true;
            }
        }
        return isCloudAdditional;
    }

    private boolean isCloudTgct() {
        return this.btCh4 < 260.0;
    }

    private double getTmftMinThreshold(double bt34) {
        int tmftMinThresholdIndexRow = (int)((this.btCh4 - 190.0) / 10.0);
        tmftMinThresholdIndexRow = Math.max(0, tmftMinThresholdIndexRow);
        tmftMinThresholdIndexRow = Math.min(13, tmftMinThresholdIndexRow);
        int tmftMinThresholdIndexColumn = (int)((bt34 - 7.5) / 15.0) + 1;
        tmftMinThresholdIndexColumn = Math.max(0, tmftMinThresholdIndexColumn);
        tmftMinThresholdIndexColumn = Math.min(3, tmftMinThresholdIndexColumn);
        int tmftMinThresholdIndex = 4 * tmftMinThresholdIndexRow + tmftMinThresholdIndexColumn;
        return AvhrrConstants.tmftTestMinThresholds[tmftMinThresholdIndex];
    }

    private double getTmftMaxThreshold(double bt34) {
        int tmftMaxThresholdIndexRow = (int)((this.btCh4 - 190.0) / 10.0);
        tmftMaxThresholdIndexRow = Math.max(0, tmftMaxThresholdIndexRow);
        tmftMaxThresholdIndexRow = Math.min(13, tmftMaxThresholdIndexRow);
        int tmftMaxThresholdIndexColumn = (int)((bt34 - 7.5) / 15.0) + 1;
        tmftMaxThresholdIndexColumn = Math.max(0, tmftMaxThresholdIndexColumn);
        tmftMaxThresholdIndexColumn = Math.min(3, tmftMaxThresholdIndexColumn);
        int tmftMaxThresholdIndex = 4 * tmftMaxThresholdIndexRow + tmftMaxThresholdIndexColumn;
        return AvhrrConstants.tmftTestMaxThresholds[tmftMaxThresholdIndex];
    }

    private double getFmftThreshold() {
        int fmftThresholdIndex = (int)(this.btCh4 - 200.0);
        fmftThresholdIndex = Math.max(0, fmftThresholdIndex);
        fmftThresholdIndex = Math.min(120, fmftThresholdIndex);
        return AvhrrConstants.fmftTestThresholds[fmftThresholdIndex];
    }

    private boolean isDesertArea() {
        return this.latitude >= 10.0 && this.latitude < 35.0 && this.longitude >= -20.0 && this.longitude < 30.0 || this.latitude >= 5.0 && this.latitude < 50.0 && this.longitude >= 30.0 && this.longitude < 60.0 || this.latitude >= 25.0 && this.latitude < 50.0 && this.longitude >= 60.0 && this.longitude < 110.0 || this.latitude >= -31.0 && this.latitude < 19.0 && this.longitude >= 121.0 && this.longitude < 141.0 || this.latitude >= 35.0 && this.latitude < 50.0 && this.longitude >= 110.0 && this.longitude < 127.0;
    }

    private double getRgctThreshold(double ndvi) {
        double rgctThresh = Double.MAX_VALUE;
        if (ndvi < -0.05) {
            rgctThresh = 0.8;
        } else if (ndvi >= -0.05 && ndvi < 0.0) {
            rgctThresh = 0.6;
        } else if (ndvi >= 0.0 && ndvi < 0.05) {
            rgctThresh = 0.5;
        } else if (ndvi >= 0.05 && ndvi < 0.1) {
            rgctThresh = 0.4;
        } else if (ndvi >= 0.1 && ndvi < 0.15) {
            rgctThresh = 0.35;
        } else if (ndvi >= 0.15 && ndvi < 0.25) {
            rgctThresh = 0.3;
        } else if (ndvi >= 0.25) {
            rgctThresh = 0.25;
        }
        return rgctThresh;
    }

    @Override
    public boolean isCloudBuffer() {
        return false;
    }

    @Override
    public boolean isCloudShadow() {
        return false;
    }

    @Override
    public boolean isCoastline() {
        return this.waterFraction < 100.0f && this.waterFraction > 0.0f;
    }

    @Override
    public boolean isLand() {
        return this.waterFraction == 0.0f;
    }

    @Override
    public boolean isGlintRisk() {
        return false;
    }

    public void setReflCh1(double reflCh1) {
        this.reflCh1 = reflCh1;
    }

    public void setReflCh2(double reflCh2) {
        this.reflCh2 = reflCh2;
    }

    public void setReflCh3(double reflCh3) {
        this.reflCh3 = reflCh3;
    }

    public void setBtCh3(double btCh3) {
        this.btCh3 = btCh3;
    }

    public void setBtCh4(double btCh4) {
        this.btCh4 = btCh4;
    }

    public void setBtCh5(double btCh5) {
        this.btCh5 = btCh5;
    }

    public void setRadiance(double[] rad) {
        this.radiance = rad;
    }

    public void setWaterFraction(float waterFraction) {
        this.waterFraction = waterFraction;
    }

    public void setNnOutput(double[] nnOutput) {
        this.nnOutput = nnOutput;
    }

    public void setAmbiguousLowerBoundaryValue(double avhrracSchillerNNCloudAmbiguousLowerBoundaryValue) {
        this.avhrracSchillerNNCloudAmbiguousLowerBoundaryValue = avhrracSchillerNNCloudAmbiguousLowerBoundaryValue;
    }

    public void setAmbiguousSureSeparationValue(double avhrracSchillerNNCloudAmbiguousSureSeparationValue) {
        this.avhrracSchillerNNCloudAmbiguousSureSeparationValue = avhrracSchillerNNCloudAmbiguousSureSeparationValue;
    }

    public void setSureSnowSeparationValue(double avhrracSchillerNNCloudSureSnowSeparationValue) {
        this.avhrracSchillerNNCloudSureSnowSeparationValue = avhrracSchillerNNCloudSureSnowSeparationValue;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setSza(double sza) {
        this.sza = sza;
    }

    public void setDistanceCorr(double distanceCorr) {
        this.distanceCorr = distanceCorr;
    }

    public void setNoaaId(String noaaId) {
        this.noaaId = noaaId;
    }

    public float getWaterFraction() {
        return this.waterFraction;
    }
}

