/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.algorithms;

import java.awt.Rectangle;
import org.esa.snap.core.gpf.Tile;

public class CloudBuffer {
    public static void computeSimpleCloudBuffer(int x, int y, Tile sourceFlagTile, Tile targetTile, int cloudBufferWidth, int cloudFlagBit, int cloudBufferFlagBit) {
        Rectangle rectangle = targetTile.getRectangle();
        int LEFT_BORDER = Math.max(x - cloudBufferWidth, rectangle.x);
        int RIGHT_BORDER = Math.min(x + cloudBufferWidth, rectangle.x + rectangle.width - 1);
        int TOP_BORDER = Math.max(y - cloudBufferWidth, rectangle.y);
        int BOTTOM_BORDER = Math.min(y + cloudBufferWidth, rectangle.y + rectangle.height - 1);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                boolean is_already_cloud = sourceFlagTile.getSampleBit(i, j, cloudFlagBit);
                if (is_already_cloud || !rectangle.contains(i, j)) continue;
                targetTile.setSample(i, j, cloudBufferFlagBit, true);
            }
        }
    }

    public static void computeSimpleCloudBuffer(int x, int y, Tile targetTile, Rectangle extendedRectangle, int cloudBufferWidth, int cloudBufferFlagBit) {
        Rectangle rectangle = targetTile.getRectangle();
        int LEFT_BORDER = Math.max(x - cloudBufferWidth, extendedRectangle.x);
        int RIGHT_BORDER = Math.min(x + cloudBufferWidth, extendedRectangle.x + extendedRectangle.width - 1);
        int TOP_BORDER = Math.max(y - cloudBufferWidth, extendedRectangle.y);
        int BOTTOM_BORDER = Math.min(y + cloudBufferWidth, extendedRectangle.y + extendedRectangle.height - 1);
        for (int i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
            for (int j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                if (!rectangle.contains(i, j)) continue;
                targetTile.setSample(i, j, cloudBufferFlagBit, true);
            }
        }
    }

    public static void computeCloudBufferLC(Tile targetTile, int cloudFlagBit, int cloudBufferFlagBit) {
        int j;
        int i;
        int BOTTOM_BORDER;
        int TOP_BORDER;
        int RIGHT_BORDER;
        int LEFT_BORDER;
        Rectangle rectangle = targetTile.getRectangle();
        for (int y = rectangle.y; y < rectangle.y + rectangle.height - 1; ++y) {
            for (int x = rectangle.x; x < rectangle.x + rectangle.width - 1; ++x) {
                if (!targetTile.getSampleBit(x, y, cloudFlagBit)) continue;
                int bufferWidth = 1;
                LEFT_BORDER = Math.max(x - bufferWidth, rectangle.x);
                RIGHT_BORDER = Math.min(x + bufferWidth, rectangle.x + rectangle.width - 1);
                TOP_BORDER = Math.max(y - bufferWidth, rectangle.y);
                BOTTOM_BORDER = Math.min(y + bufferWidth, rectangle.y + rectangle.height - 1);
                if (targetTile.getSampleBit(x + 1, y, cloudFlagBit) && targetTile.getSampleBit(x, y + 1, cloudFlagBit) && targetTile.getSampleBit(x + 1, y + 1, cloudFlagBit)) {
                    bufferWidth = 2;
                    LEFT_BORDER = Math.max(x - bufferWidth, rectangle.x);
                    RIGHT_BORDER = Math.min(x + 1 + bufferWidth, rectangle.x + rectangle.width - 1);
                    TOP_BORDER = Math.max(y - bufferWidth, rectangle.y);
                    BOTTOM_BORDER = Math.min(y + 1 + bufferWidth, rectangle.y + rectangle.height - 1);
                }
                for (i = LEFT_BORDER; i <= RIGHT_BORDER; ++i) {
                    for (j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                        targetTile.setSample(i, j, cloudBufferFlagBit, true);
                    }
                }
            }
        }
        int bufferWidth = 1;
        int ySouth = rectangle.y + rectangle.height - 1;
        for (int x = rectangle.x; x < rectangle.x + rectangle.width - 1; ++x) {
            LEFT_BORDER = Math.max(x - bufferWidth, rectangle.x);
            RIGHT_BORDER = Math.min(x + bufferWidth, rectangle.x + rectangle.width - 1);
            TOP_BORDER = Math.max(rectangle.y, ySouth - bufferWidth);
            if (!targetTile.getSampleBit(x, ySouth, cloudFlagBit)) continue;
            for (int i2 = LEFT_BORDER; i2 <= RIGHT_BORDER; ++i2) {
                for (int j2 = TOP_BORDER; j2 <= ySouth; ++j2) {
                    targetTile.setSample(i2, j2, cloudBufferFlagBit, true);
                }
            }
        }
        int xEast = rectangle.x + rectangle.width - 1;
        for (int y = rectangle.y; y < rectangle.y + rectangle.height - 1; ++y) {
            int LEFT_BORDER2 = Math.max(rectangle.x, xEast - bufferWidth);
            TOP_BORDER = Math.max(y - bufferWidth, rectangle.y);
            BOTTOM_BORDER = Math.min(y + bufferWidth, rectangle.y + rectangle.height - 1);
            if (!targetTile.getSampleBit(xEast, y, cloudFlagBit)) continue;
            for (i = LEFT_BORDER2; i <= xEast; ++i) {
                for (j = TOP_BORDER; j <= BOTTOM_BORDER; ++j) {
                    targetTile.setSample(i, j, cloudBufferFlagBit, true);
                }
            }
        }
        if (targetTile.getSampleBit(xEast, ySouth, cloudFlagBit)) {
            for (int i3 = Math.max(rectangle.x, xEast - 1); i3 <= xEast; ++i3) {
                for (int j3 = Math.max(rectangle.y, ySouth - 1); j3 <= ySouth; ++j3) {
                    targetTile.setSample(i3, j3, cloudBufferFlagBit, true);
                }
            }
        }
    }
}

