/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.esa.s3tbx.idepix.ui.IdepixDefaultForm;
import org.esa.s3tbx.idepix.ui.SourceProductSelectionListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.AppContext;

public class IdepixDefaultDialog
extends SingleTargetProductDialog {
    private List<SourceProductSelector> sourceProductSelectorList;
    private Map<Field, SourceProductSelector> sourceProductSelectorMap;
    private String operatorName;
    private Map<String, Object> parameterMap;
    private IdepixDefaultForm form;
    private String targetProductNameSuffix;
    private AppContext appContext;
    private OperatorSpi operatorSpi;
    private String helpID;

    public IdepixDefaultDialog(String operatorName, AppContext appContext, String title, String helpID, String targetProductNameSuffix) {
        super(appContext, title, helpID);
        this.helpID = helpID;
        this.operatorName = operatorName;
        this.appContext = appContext;
        this.targetProductNameSuffix = targetProductNameSuffix;
        System.setProperty("gpfMode", "GUI");
        this.initialize(operatorName);
    }

    protected Product createTargetProduct() throws Exception {
        HashMap<String, Product> sourceProducts = this.createSourceProductsMap();
        return GPF.createProduct((String)this.operatorName, this.parameterMap, sourceProducts);
    }

    public int show() {
        this.initSourceProductSelectors();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.releaseSourceProductSelectors();
        super.hide();
    }

    private void initialize(String operatorName) {
        this.operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (this.operatorSpi == null) {
            throw new IllegalArgumentException("operatorName");
        }
        this.parameterMap = new LinkedHashMap<String, Object>(17);
        this.form = new IdepixDefaultForm(this.operatorSpi, this.parameterMap);
        this.initComponents();
        this.form.initialize();
    }

    private void initComponents() {
        this.setupSourceProductSelectorList(this.operatorSpi);
        if (!this.sourceProductSelectorList.isEmpty()) {
            this.setSourceProductSelectorToolTipTexts();
        }
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        JPanel ioParametersPanel = new JPanel((LayoutManager)tableLayout);
        for (SourceProductSelector selector : this.sourceProductSelectorList) {
            ioParametersPanel.add(selector.createDefaultPanel());
        }
        ioParametersPanel.add(this.getTargetProductSelector().createDefaultPanel());
        ioParametersPanel.add(tableLayout.createVerticalSpacer());
        TargetProductSelectorModel targetProductSelectorModel = this.getTargetProductSelector().getModel();
        SourceProductSelectionListener sourceProductSelectionListener = new SourceProductSelectionListener(targetProductSelectorModel, this.targetProductNameSuffix);
        this.sourceProductSelectorList.get(0).addSelectionChangeListener((SelectionChangeListener)sourceProductSelectionListener);
        this.form.add("I/O Parameters", ioParametersPanel);
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(this.operatorSpi.getOperatorDescriptor(), null, this.parameterMap, null);
        OperatorMenu menuSupport = new OperatorMenu((Component)this.getJDialog(), this.operatorSpi.getOperatorDescriptor(), parameterSupport, this.appContext, this.helpID);
        this.getJDialog().setJMenuBar(menuSupport.createDefaultMenu());
    }

    private HashMap<String, Product> createSourceProductsMap() {
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>(8);
        for (Field field : this.sourceProductSelectorMap.keySet()) {
            SourceProductSelector selector = this.sourceProductSelectorMap.get(field);
            String key = field.getName();
            SourceProduct annot = field.getAnnotation(SourceProduct.class);
            if (!annot.alias().isEmpty()) {
                key = annot.alias();
            }
            sourceProducts.put(key, selector.getSelectedProduct());
        }
        return sourceProducts;
    }

    private void initSourceProductSelectors() {
        for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
            sourceProductSelector.initProducts();
        }
    }

    private void releaseSourceProductSelectors() {
        for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
            sourceProductSelector.releaseProducts();
        }
    }

    private void setupSourceProductSelectorList(OperatorSpi operatorSpi) {
        Field[] fields;
        this.sourceProductSelectorList = new ArrayList<SourceProductSelector>(3);
        this.sourceProductSelectorMap = new HashMap<Field, SourceProductSelector>(3);
        for (Field field : fields = operatorSpi.getOperatorClass().getDeclaredFields()) {
            SourceProduct annot = field.getAnnotation(SourceProduct.class);
            if (annot == null) continue;
            AnnotatedSourceProductFilter productFilter = new AnnotatedSourceProductFilter(annot);
            SourceProductSelector sourceProductSelector = new SourceProductSelector(this.appContext);
            sourceProductSelector.setProductFilter((ProductFilter)productFilter);
            this.sourceProductSelectorList.add(sourceProductSelector);
            this.sourceProductSelectorMap.put(field, sourceProductSelector);
        }
    }

    private void setSourceProductSelectorToolTipTexts() {
        for (Field field : this.sourceProductSelectorMap.keySet()) {
            SourceProductSelector selector = this.sourceProductSelectorMap.get(field);
            SourceProduct annot = field.getAnnotation(SourceProduct.class);
            String description = annot.description();
            if (description.isEmpty()) continue;
            selector.getProductNameComboBox().setToolTipText(description);
        }
    }

    private static class AnnotatedSourceProductFilter
    implements ProductFilter {
        private final SourceProduct annot;

        private AnnotatedSourceProductFilter(SourceProduct annot) {
            this.annot = annot;
        }

        public boolean accept(Product product) {
            if (!this.annot.type().isEmpty() && !product.getProductType().matches(this.annot.type())) {
                return false;
            }
            for (String bandName : this.annot.bands()) {
                if (product.containsBand(bandName)) continue;
                return false;
            }
            return true;
        }
    }
}

