/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew.util;

public class WaterProcessorOzone {
    private WaterProcessorOzone() {
    }

    public static double O3tau(double l, double O3du) {
        return O3du / 1000.0 * WaterProcessorOzone.O3excoeff(l);
    }

    public static double O3excoeff(double l) {
        int no3data = 69;
        double[] lambda = new double[]{205.0, 210.0, 215.0, 220.0, 225.0, 230.0, 235.0, 240.0, 245.0, 250.0, 255.0, 260.0, 265.0, 270.0, 275.0, 280.0, 285.0, 290.0, 295.0, 300.0, 305.0, 310.0, 315.0, 320.0, 325.0, 330.0, 335.0, 340.0, 345.0, 350.0, 355.0, 360.0, 365.0, 380.0, 400.0, 420.0, 440.0, 450.0, 460.0, 470.0, 480.0, 490.0, 500.0, 510.0, 520.0, 530.0, 540.0, 550.0, 560.0, 570.0, 580.0, 590.0, 600.0, 610.0, 620.0, 630.0, 640.0, 650.0, 660.0, 670.0, 680.0, 690.0, 700.0, 710.0, 720.0, 730.0, 740.0, 750.0, 1800.0};
        double[] excoeff = new double[]{9.5, 14.5, 26.0, 45.9, 75.8, 116.2, 161.5, 211.1, 256.0, 283.9, 292.9, 282.9, 248.9, 201.5, 147.0, 99.0, 60.6, 34.6, 19.2, 9.8, 4.9, 2.64, 1.17, 0.622, 0.302, 0.144, 0.0765, 0.0381, 0.0159, 0.00631, 0.00237, 0.00125, 5.2E-4, 1.0E-7, 1.0E-7, 1.0E-7, 0.0024, 0.0036, 0.0065, 0.0088, 0.016, 0.0197, 0.03, 0.039, 0.046, 0.063, 0.074, 0.084, 0.096, 0.115, 0.116, 0.11, 0.121, 0.121, 0.104, 0.09, 0.079, 0.063, 0.055, 0.043, 0.034, 0.027, 0.023, 0.019, 0.015, 0.012, 0.011, 0.01, 1.0E-6};
        return WaterProcessorOzone.inpol(lambda, excoeff, no3data, l);
    }

    private static double inpol(double[] x, double[] y, int n, double xi) {
        boolean found = false;
        for (int i = 0; i < n - 1 && !found; ++i) {
            if (!(xi >= x[i]) || !(xi <= x[i + 1])) continue;
            found = true;
            return y[i] + (xi - x[i]) * (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        return Double.NaN;
    }
}

