/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew;

import java.awt.Color;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.s3tbx.fub.wew.WaterProcessorOpConstant;
import org.esa.s3tbx.fub.wew.util.NN_AtmCorr;
import org.esa.s3tbx.fub.wew.util.NN_CHL;
import org.esa.s3tbx.fub.wew.util.NN_TSM;
import org.esa.s3tbx.fub.wew.util.NN_YellowSubstance;
import org.esa.s3tbx.fub.wew.util.WaterProcessorOzone;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

@OperatorMetadata(alias="FUB.Water", authors="Thomas Schroeder, Michael Schaale", copyright="Institute for Space Sciences (WeW), Freie Universitaet Berlin", category="Optical/Thematic Water Processing", version="4.0.1", description="FUB/WeW WATER Processor to retrieve case II water properties and atmospheric properties")
public class WaterProcessorOp
extends PixelOperator {
    private float[] solarFlux;
    private Band[] inputBands = new Band[EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS];
    private Raster validMaskData;
    @SourceProduct(label="Source product", description="The MERIS L1b or L1P source product used for the processing.")
    private Product sourceProduct;
    @Parameter(description="Whether chlorophyll-a concentration band shall be computed", defaultValue="true", label="Compute chlorophyll-a concentration band")
    private boolean computeCHL;
    @Parameter(description="Whether yellow substances band shall be computed", defaultValue="true", label="Compute yellow substances band")
    private boolean computeYS;
    @Parameter(description="Whether total suspended matter band shall be computed", defaultValue="true", label="Compute total suspended matter band")
    private boolean computeTSM;
    @Parameter(description="Whether atmospheric correction bands shall be computed", defaultValue="true", label="Compute water leaving reflectances and AOT bands")
    private boolean computeAtmCorr;
    @Parameter(description="Expert parameter. Performs a check whether the 'l1_flags.SUSPECT' shall be considered in an expression.This parameter is only considered when the expression contains the term 'and not l1_flags.SUSPECT'", defaultValue="true", label="Check whether 'l1_flags.SUSPECT' is valid")
    private boolean checkWhetherSuspectIsValid;
    @Parameter(description="Band maths expression which defines valid pixels. If the expression is empty,all pixels will be considered.", defaultValue="not l1_flags.GLINT_RISK and not l1_flags.BRIGHT and not l1_flags.INVALID and not l1_flags.SUSPECT", label="Use valid pixel expression")
    private String expression;
    private Sensor sensor;

    private static FlagCoding createResultFlagCoding() {
        FlagCoding resultFlagCoding = new FlagCoding("result_flags");
        resultFlagCoding.setDescription("RESULT Flag Coding");
        for (int i = 0; i < WaterProcessorOpConstant.RESULT_ERROR_NAMES.length; ++i) {
            MetadataAttribute attribute = new MetadataAttribute(WaterProcessorOpConstant.RESULT_ERROR_NAMES[i], 12);
            attribute.getData().setElemInt(WaterProcessorOpConstant.RESULT_ERROR_VALUES[i]);
            attribute.setDescription(WaterProcessorOpConstant.RESULT_ERROR_TEXTS[i]);
            resultFlagCoding.addAttribute(attribute);
        }
        return resultFlagCoding;
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.sensor = this.getSensor();
        String[] sourceRasterNames = this.sensor.getRasterNames();
        for (int i = 0; i < this.inputBands.length; ++i) {
            String radianceBandName = sourceRasterNames[i];
            Band radianceBand = this.sourceProduct.getBand(radianceBandName);
            if (radianceBand == null) {
                throw new OperatorException(String.format("Missing input band '%s'.", radianceBandName));
            }
            if ((double)radianceBand.getSpectralWavelength() <= 0.0) {
                throw new OperatorException(String.format("Input band '%s' does not have wavelength information.", radianceBandName));
            }
            this.inputBands[i] = radianceBand;
        }
        this.solarFlux = this.getSolarFlux(this.sourceProduct, this.inputBands);
        if (this.checkWhetherSuspectIsValid) {
            this.checkWhetherSuspectIsValid();
        }
        PlanarImage validMaskImage = this.createValidMaskImage(this.sourceProduct, this.expression);
        this.validMaskData = validMaskImage.getData();
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        String[] sourceRasterNames = this.sensor.getRasterNames();
        for (int i = 0; i < sourceRasterNames.length; ++i) {
            sampleConfigurer.defineSample(i, sourceRasterNames[i]);
        }
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        String[] bandNames = new String[]{};
        if (this.computeCHL) {
            bandNames = StringUtils.addToArray((String[])bandNames, (String)WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_NAMES[0]);
        }
        if (this.computeYS) {
            bandNames = StringUtils.addToArray((String[])bandNames, (String)WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_NAMES[1]);
        }
        if (this.computeTSM) {
            bandNames = StringUtils.addToArray((String[])bandNames, (String)WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_NAMES[2]);
        }
        if (this.computeAtmCorr) {
            bandNames = StringUtils.addArrays((String[])bandNames, (String[])WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_NAMES);
            bandNames = StringUtils.addArrays((String[])bandNames, (String[])WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_NAMES);
        }
        bandNames = StringUtils.addToArray((String[])bandNames, (String)"result_flags");
        for (int i = 0; i < bandNames.length; ++i) {
            sampleConfigurer.defineSample(i, bandNames[i]);
        }
    }

    protected void computePixel(int xpos, int ypos, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int stage;
        float dazi;
        int n;
        float aset = -1.0f;
        int width = 1;
        int nbands = this.inputBands.length;
        float[] toa = new float[nbands];
        int[] resultFlags = new int[width];
        double[] wavelength = new double[nbands];
        double[] exO3 = new double[nbands];
        int ls = 0;
        float[] a = new float[width];
        float[][] ipixel = new float[2][1];
        float[][] ipixels = new float[2][1];
        float[][] opixel = new float[2][1];
        for (int i = 0; i < nbands; ++i) {
            wavelength[i] = this.inputBands[i].getSpectralWavelength();
            exO3[i] = WaterProcessorOzone.O3excoeff(wavelength[i]);
        }
        double d2r = Math.acos(-1.0) / 180.0;
        int inodes = NN_YellowSubstance.compute(ipixel, -1, opixel, 1, width, resultFlags, 0, a);
        int onodes_1 = NN_YellowSubstance.compute(ipixel, 1, opixel, -1, width, resultFlags, 0, a);
        int onodes_2 = NN_AtmCorr.compute(ipixel, 1, opixel, -1, width, resultFlags, 0, a);
        int num_toa = 12;
        int output_planes = 0;
        if (this.computeCHL) {
            ++output_planes;
        }
        if (this.computeYS) {
            ++output_planes;
        }
        if (this.computeTSM) {
            ++output_planes;
        }
        if (this.computeAtmCorr) {
            output_planes += WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_NAMES.length + WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_NAMES.length;
        }
        float[] top = new float[num_toa];
        float[] tops = new float[num_toa];
        double[] o3f = new double[num_toa];
        float[] sof = new float[num_toa];
        float[] aux = new float[2];
        float[] geo = new float[4];
        float[] result = new float[output_planes];
        for (n = 0; n < this.inputBands.length; ++n) {
            toa[n] = sourceSamples[n].getFloat();
        }
        float sza = sourceSamples[16].getFloat();
        float saa = sourceSamples[17].getFloat();
        float vza = sourceSamples[18].getFloat();
        float vaa = sourceSamples[19].getFloat();
        float zw = sourceSamples[20].getFloat();
        float mw = sourceSamples[21].getFloat();
        float press = sourceSamples[22].getFloat();
        float o3 = sourceSamples[23].getFloat();
        boolean x = false;
        resultFlags[0] = 0;
        int resultFlagsNN = 0;
        if (this.validMaskData.getSample(xpos, ypos, 0) == 0) {
            resultFlags[0] = WaterProcessorOpConstant.RESULT_ERROR_VALUES[0];
        }
        int l = 0;
        double TOTAL_OZONE_DU_MOMO = 344.0;
        n = 0;
        while (n <= 6) {
            tops[l] = toa[n];
            sof[l] = this.solarFlux[n];
            top[l] = toa[n] / this.solarFlux[n];
            o3f[l] = Math.exp(-(344.0 - (double)o3) * exO3[n] / 1000.0 * (1.0 / Math.cos((double)vza * d2r) + 1.0 / Math.cos((double)sza * d2r)));
            int n2 = l;
            top[n2] = (float)((double)top[n2] * o3f[l]);
            ++n;
            ++l;
        }
        n = 8;
        while (n <= 9) {
            tops[l] = toa[n];
            sof[l] = this.solarFlux[n];
            top[l] = toa[n] / this.solarFlux[n];
            o3f[l] = Math.exp(-(344.0 - (double)o3) * exO3[n] / 1000.0 * (1.0 / Math.cos((double)vza * d2r) + 1.0 / Math.cos((double)sza * d2r)));
            int n3 = l;
            top[n3] = (float)((double)top[n3] * o3f[l]);
            ++n;
            ++l;
        }
        n = 11;
        while (n <= 13) {
            tops[l] = toa[n];
            sof[l] = this.solarFlux[n];
            top[l] = toa[n] / this.solarFlux[n];
            o3f[l] = Math.exp(-(344.0 - (double)o3) * exO3[n] / 1000.0 * (1.0 / Math.cos((double)vza * d2r) + 1.0 / Math.cos((double)sza * d2r)));
            int n4 = l;
            top[n4] = (float)((double)top[n4] * o3f[l]);
            ++n;
            ++l;
        }
        aux[0] = (float)Math.sqrt(zw * zw + mw * mw);
        aux[1] = press;
        for (dazi = vaa - saa; dazi <= -180.0f; dazi += 360.0f) {
        }
        while (dazi > 180.0f) {
            dazi -= 360.0f;
        }
        float tmp = dazi;
        if (tmp >= 0.0f) {
            dazi = 180.0f - dazi;
        }
        if (tmp < 0.0f) {
            dazi = -180.0f - dazi;
        }
        geo[0] = (float)Math.cos((double)sza * d2r);
        geo[1] = (float)(Math.sin((double)vza * d2r) * Math.cos((double)dazi * d2r));
        geo[2] = (float)(Math.sin((double)vza * d2r) * Math.sin((double)dazi * d2r));
        geo[3] = (float)Math.cos((double)vza * d2r);
        int onodes = onodes_1;
        ipixel = new float[inodes][width];
        ipixels = new float[inodes][width];
        opixel = new float[onodes][width];
        for (l = 0; l < num_toa; ++l) {
            ipixel[l][0] = top[l];
        }
        ipixel[l++][0] = aux[0];
        ipixel[l++][0] = aux[1];
        ipixel[l++][0] = geo[0];
        ipixel[l++][0] = geo[1];
        ipixel[l++][0] = geo[2];
        ipixel[l++][0] = geo[3];
        a[0] = aset;
        ls = l;
        for (l = 0; l < ls; ++l) {
            ipixels[l][0] = ipixel[l][0];
        }
        int resultCounter = 0;
        if (this.computeCHL) {
            stage = 1;
            NN_CHL.compute(ipixel, inodes, opixel, onodes, width, resultFlags, 0, a);
            if ((double)a[0] > -2.1 && (double)a[0] < -1.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
            }
            if ((double)a[0] > -19.1 && (double)a[0] < -18.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            if ((double)a[0] > -22.1 && (double)a[0] < -21.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            result[resultCounter++] = opixel[0][0];
        }
        if (this.computeYS) {
            stage = 2;
            for (l = 0; l < ls; ++l) {
                ipixel[l][0] = ipixels[l][0];
            }
            a[0] = aset;
            NN_YellowSubstance.compute(ipixel, inodes, opixel, onodes, width, resultFlags, 0, a);
            if ((double)a[0] > -2.1 && (double)a[0] < -1.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
            }
            if ((double)a[0] > -19.1 && (double)a[0] < -18.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            if ((double)a[0] > -22.1 && (double)a[0] < -21.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            result[resultCounter++] = opixel[0][0];
        }
        if (this.computeTSM) {
            stage = 3;
            for (l = 0; l < ls; ++l) {
                ipixel[l][0] = ipixels[l][0];
            }
            a[0] = aset;
            NN_TSM.compute(ipixel, inodes, opixel, onodes, width, resultFlags, 0, a);
            if ((double)a[0] > -2.1 && (double)a[0] < -1.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
            }
            if ((double)a[0] > -19.1 && (double)a[0] < -18.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            if ((double)a[0] > -22.1 && (double)a[0] < -21.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            result[resultCounter++] = opixel[0][0];
        }
        if (this.computeAtmCorr) {
            int i;
            stage = 4;
            onodes = onodes_2;
            opixel = new float[onodes][width];
            for (l = 0; l < ls; ++l) {
                ipixel[l][0] = ipixels[l][0];
            }
            a[0] = aset;
            NN_AtmCorr.compute(ipixel, inodes, opixel, onodes, width, resultFlags, 0, a);
            if ((double)a[0] > -2.1 && (double)a[0] < -1.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
            }
            if ((double)a[0] > -19.1 && (double)a[0] < -18.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            if ((double)a[0] > -22.1 && (double)a[0] < -21.9) {
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage - 1];
                resultFlagsNN |= WaterProcessorOpConstant.RESULT_ERROR_VALUES[2 * stage];
            }
            int num_msl = 8;
            for (i = 8; i < onodes; ++i) {
                result[resultCounter + i - 8] = opixel[i][0];
            }
            for (i = 0; i < 8; ++i) {
                int numOfSpectralAerosolOpticalDepths = 4;
                result[resultCounter + 4 + i] = opixel[i][0];
            }
        }
        if (resultFlags[0] != 0) {
            for (n = 0; n < output_planes; ++n) {
                result[n] = 5.0f;
            }
        }
        if (vza >= 40.0f) {
            resultFlags[0] = WaterProcessorOpConstant.RESULT_ERROR_VALUES[0];
        }
        resultFlags[0] = resultFlags[0] | resultFlagsNN;
        for (n = 0; n < output_planes; ++n) {
            targetSamples[n].set(result[n]);
        }
        targetSamples[output_planes].set(resultFlags[0]);
    }

    private void checkWhetherSuspectIsValid() {
        if (!this.expression.contains("and not l1_flags.SUSPECT")) {
            return;
        }
        int height = this.sourceProduct.getSceneRasterHeight();
        int width = this.sourceProduct.getSceneRasterWidth();
        Band l1FlagsInputBand = this.sourceProduct.getBand(this.sensor.getFlagName());
        int[] l1Flags = new int[width];
        int halfHeight = height / 2;
        try {
            l1FlagsInputBand.readPixels(0, halfHeight, width, 1, l1Flags);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String ICOL_PATTERN = "MER_.*1N";
        boolean icolMode = this.sourceProduct.getProductType().matches("MER_.*1N");
        if (icolMode) {
            this.expression = this.expression.replace("and not l1_flags.SUSPECT", "");
            System.out.println("--- Input product is of type icol ---");
            System.out.println("--- Switching to relaxed mask. ---");
        } else {
            PlanarImage validMaskImage = this.createValidMaskImage(this.sourceProduct, this.sensor.getSuspectFlag());
            Raster validData = validMaskImage.getData();
            int k = 0;
            for (int i = 0; i < width; ++i) {
                if (validData.getSample(i, halfHeight, 0) == 0) continue;
                ++k;
            }
            if (k >= width / 2) {
                this.expression = this.expression.replace("and not l1_flags.SUSPECT", "");
                float percent = (float)k / (float)width * 100.0f;
                System.out.println("--- " + percent + " % of the scan line are marked as suspect ---");
                System.out.println("--- Switching to relaxed mask. ---");
            }
        }
    }

    private float[] getSolarFlux(Product product, Band[] bands) {
        float[] dsf = this.getSolarFluxFromMetadata(product);
        if (dsf == null) {
            dsf = new float[bands.length];
            double[] defsol = new double[]{1670.5964, 1824.1444, 1874.9883, 1877.6682, 1754.7749, 1606.6401, 1490.0026, 1431.8726, 1369.2035, 1231.7164, 1220.0767, 1144.9675, 932.3497, 904.8193, 871.0908};
            for (int i = 0; i < bands.length; ++i) {
                Band band = bands[i];
                dsf[i] = band.getSolarFlux();
                if (!((double)dsf[i] <= 0.0)) continue;
                dsf[i] = (float)defsol[i];
            }
        }
        return dsf;
    }

    private float[] getSolarFluxFromMetadata(Product product) {
        MetadataAttribute solarFluxAtt;
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement gadsElem = metadataRoot.getElement("Scaling_Factor_GADS");
        if (gadsElem != null && (solarFluxAtt = gadsElem.getAttribute("sun_spec_flux")) != null) {
            return (float[])solarFluxAtt.getDataElems();
        }
        return null;
    }

    private Sensor getSensor() {
        Stream nodeStream = this.getSourceProduct().getRasterDataNodes().stream();
        List rasterNames = nodeStream.map(ProductNode::getName).collect(Collectors.toList());
        if (rasterNames.containsAll(Arrays.asList(Sensor.OLCI.getRasterNames()))) {
            return Sensor.OLCI;
        }
        if (rasterNames.containsAll(Arrays.asList(Sensor.MERIS.getRasterNames()))) {
            return Sensor.MERIS;
        }
        throw new OperatorException("The operator can't be applied on the sensor");
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        productConfigurer.copyMetadata();
        Product sourceProduct = productConfigurer.getSourceProduct();
        Product targetProduct = productConfigurer.getTargetProduct();
        targetProduct.setProductType(this.getOutputProductType());
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        if (this.computeCHL) {
            this.addConcentrationBand(targetProduct, sceneWidth, sceneHeight, 0);
        }
        if (this.computeYS) {
            this.addConcentrationBand(targetProduct, sceneWidth, sceneHeight, 1);
        }
        if (this.computeTSM) {
            this.addConcentrationBand(targetProduct, sceneWidth, sceneHeight, 2);
        }
        if (this.computeAtmCorr) {
            this.addOpticalDepthBands(targetProduct, sceneWidth, sceneHeight);
            this.addReflectanceBands(targetProduct, sceneWidth, sceneHeight);
        }
        ProductUtils.copyFlagBands((Product)sourceProduct, (Product)targetProduct, (boolean)true);
        if (!targetProduct.containsBand("corr_longitude")) {
            productConfigurer.copyBands(new String[]{"corr_longitude"});
        }
        if (!targetProduct.containsBand("corr_latitude")) {
            productConfigurer.copyBands(new String[]{"corr_latitude"});
        }
        productConfigurer.copyBands(new String[]{"altitude"});
        FlagCoding resultFlagCoding = WaterProcessorOp.createResultFlagCoding();
        targetProduct.getFlagCodingGroup().add((ProductNode)resultFlagCoding);
        Band resultFlagsOutputBand = targetProduct.addBand("result_flags", 21);
        resultFlagsOutputBand.setDescription("FUB/WeW WATER plugin specific flags");
        resultFlagsOutputBand.setSampleCoding((SampleCoding)resultFlagCoding);
        productConfigurer.copyMasks();
        String flagNamePrefix = "result_flags.";
        this.addMasksToTargetProduct(targetProduct, sceneWidth, sceneHeight, flagNamePrefix);
    }

    private void addMasksToTargetProduct(Product targetProduct, int sceneWidth, int sceneHeight, String flagNamePrefix) {
        ProductNodeGroup maskGroup = targetProduct.getMaskGroup();
        Color[] colors = new Color[]{Color.cyan, Color.green, Color.green, Color.yellow, Color.yellow, Color.orange, Color.orange, Color.blue, Color.blue};
        for (int i = 0; i < WaterProcessorOpConstant.RESULT_ERROR_NAMES.length; ++i) {
            maskGroup.add((ProductNode)Mask.BandMathsType.create((String)WaterProcessorOpConstant.RESULT_ERROR_NAMES[i].toLowerCase(), (String)WaterProcessorOpConstant.RESULT_ERROR_TEXTS[i], (int)sceneWidth, (int)sceneHeight, (String)(flagNamePrefix + WaterProcessorOpConstant.RESULT_ERROR_NAMES[i]), (Color)colors[i], (double)WaterProcessorOpConstant.RESULT_ERROR_TRANSPARENCIES[i]));
        }
    }

    private void addReflectanceBands(Product targetProduct, int sceneWidth, int sceneHeight) {
        for (int i = 0; i < WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_NAMES.length; ++i) {
            Band band = this.createBand(WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_NAMES[i], sceneWidth, sceneHeight);
            band.setDescription(WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_DESCRIPTIONS[i]);
            band.setUnit(WaterProcessorOpConstant.OUTPUT_REFLECTANCE_BAND_UNITS[i]);
            band.setSpectralWavelength(WaterProcessorOpConstant.RHO_W_LAMBDA[i]);
            band.setSpectralBandwidth(WaterProcessorOpConstant.RHO_W_BANDW[i]);
            band.setSpectralBandIndex(i);
            band.setNoDataValue(5.0);
            band.setNoDataValueUsed(true);
            targetProduct.addBand(band);
        }
    }

    private void addOpticalDepthBands(Product targetProduct, int sceneWidth, int sceneHeight) {
        for (int i = 0; i < WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_NAMES.length; ++i) {
            Band band = this.createBand(WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_NAMES[i], sceneWidth, sceneHeight);
            band.setDescription(WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_DESCRIPTIONS[i]);
            band.setUnit(WaterProcessorOpConstant.OUTPUT_OPTICAL_DEPTH_BAND_UNITS[i]);
            band.setSpectralWavelength(WaterProcessorOpConstant.TAU_LAMBDA[i]);
            band.setSpectralBandIndex(i);
            band.setNoDataValue(5.0);
            band.setNoDataValueUsed(true);
            targetProduct.addBand(band);
        }
    }

    private void addConcentrationBand(Product targetProduct, int sceneWidth, int sceneHeight, int concentrationBandIndex) {
        Band band = this.createBand(WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_NAMES[concentrationBandIndex], sceneWidth, sceneHeight);
        band.setDescription(WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_DESCRIPTIONS[concentrationBandIndex]);
        band.setUnit(WaterProcessorOpConstant.OUTPUT_CONCENTRATION_BAND_UNITS[concentrationBandIndex]);
        band.setNoDataValueUsed(true);
        band.setNoDataValue(5.0);
        targetProduct.addBand(band);
    }

    private Band createBand(String bandName, int sceneWidth, int sceneHeight) {
        Band band = new Band(bandName, 30, sceneWidth, sceneHeight);
        band.setScalingOffset(0.0);
        band.setScalingFactor(1.0);
        band.setSpectralBandIndex(0);
        return band;
    }

    private String getOutputProductType() throws OperatorException {
        String sourceType = this.sourceProduct.getProductType();
        if (sourceType != null) {
            return String.format("%s_FLH_MCI", sourceType);
        }
        return "FLH_MCI";
    }

    private PlanarImage createValidMaskImage(Product product, String expression) {
        if (StringUtils.isNullOrEmpty((String)expression)) {
            return this.createEmptyMask(product);
        }
        if (product.isCompatibleBandArithmeticExpression(expression)) {
            return VirtualBandOpImage.builder((String)expression, (Product)product).dataType(20).fillValue((Number)0).create();
        }
        String msg = String.format("Parameter 'expression' is not compatible with the source product. Expression is '%s'", expression);
        throw new OperatorException(msg);
    }

    private PlanarImage createEmptyMask(Product product) {
        return ConstantDescriptor.create((Float)Float.valueOf(product.getSceneRasterWidth()), (Float)Float.valueOf(product.getSceneRasterHeight()), (Number[])new Byte[]{(byte)-1}, null);
    }

    private static enum Sensor {
        MERIS(WaterProcessorOpConstant.SOURCE_RASTER_NAMES_MERIS, "l1_flags", "l1_flags.SUSPECT"),
        OLCI(WaterProcessorOpConstant.SOURCE_RASTER_NAMES_OLCI, "quality_flags", "quality_flags.dubious");

        private final String[] bandNames;
        private final String suspectFlag;
        private final String flagName;

        public String[] getRasterNames() {
            return this.bandNames;
        }

        public String getFlagName() {
            return this.flagName;
        }

        public String getSuspectFlag() {
            return this.suspectFlag;
        }

        private Sensor(String[] bandNames, String flagName, String suspectFalg) {
            this.bandNames = bandNames;
            this.flagName = flagName;
            this.suspectFlag = suspectFalg;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WaterProcessorOp.class);
        }
    }
}

