/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew.util;

import org.esa.s3tbx.fub.wew.util.NN_General;

public class NN_TSM {
    private static final double[][] nodes_input_scale_run39 = new double[][]{{0.04165626, 0.01161143}, {0.03520903, 0.01063651}, {0.02920866, 0.01050014}, {0.02699918, 0.01067744}, {0.0232303, 0.01168309}, {0.0175667, 0.01029799}, {0.01578191, 0.009680616}, {0.01385501, 0.008916464}, {0.01205261, 0.008339618}, {0.0116565, 0.008278698}, {0.01021733, 0.007993577}, {0.009918949, 0.00789882}, {1.5, 6.362889}, {980.0, 66.66667}, {0.24683, 0.8368545}, {-0.661312, 1.469582}, {-0.661312, 1.469582}, {0.750111, 0.2776545}};
    private static final double[][] nodes_input_pca_evec_run39 = new double[][]{{0.03030646, 0.04990876, 0.3128123, -0.184219, -0.2513797, 0.09538573, 0.195119, 0.3835894, 0.3698123, 0.4917106, 0.3975749, 0.2658831}, {-0.05552917, -0.09565797, -0.5431954, 0.348249, 0.3146494, -0.2348827, -0.2474442, -0.1222479, 0.1379611, 0.3895831, 0.3001657, 0.2831475}, {0.05598141, 0.09481888, 0.4900537, 0.1291934, 0.1992491, 0.3494936, -0.1366924, -0.528461, -0.3203657, 0.08524408, 0.2723256, 0.2952424}, {-0.0511745, -0.07966258, -0.3737462, -0.5318503, -0.3810696, -0.1142772, 0.1395136, -0.2015426, -0.4233636, -0.08591203, 0.2770854, 0.2945053}, {0.02569358, 0.02863349, 0.08645135, 0.4111902, 0.09114593, -0.1586442, 0.1778414, 0.528713, -0.3604257, -0.4281582, 0.2928889, 0.2798539}, {-0.06058641, -0.04454571, -0.0376922, -0.4818906, 0.5229458, 0.1858861, -0.1765448, 0.112119, 0.3642496, -0.430957, 0.08159291, 0.2896239}, {0.03192693, 0.03268587, 0.0739877, 0.2087469, -0.5793053, -0.07776389, -0.5489588, -0.09887996, 0.3167307, -0.3258202, -0.04081065, 0.2965558}, {0.1232582, 0.03651965, -0.1831944, 0.2582317, -0.06950327, 0.1820014, 0.680478, -0.3267826, 0.3559499, -0.1904502, -0.1519548, 0.2989575}, {0.4172159, 0.3844972, 0.1905789, -0.1822934, 0.1672969, -0.6149912, 0.02340766, -0.0650458, -0.03170411, 0.1108579, -0.3135614, 0.2931637}, {-0.7224088, -0.3363836, 0.2771402, 0.008815814, 0.03517729, -0.2807592, 0.1097266, -0.05093173, -0.02032554, 0.08593423, -0.3154054, 0.2934479}, {0.4590879, -0.6280603, -0.03032013, -0.001221827, -0.006519634, 0.2502223, -0.09914526, 0.1981608, -0.17747, 0.1683298, -0.3743368, 0.2866146}, {-0.2509924, 0.5588953, -0.2554863, 0.01911668, -0.03763345, 0.4265937, -0.113718, 0.251514, -0.1995437, 0.1797657, -0.3817994, 0.2854934}};
    private static final double[][] nodes_hidden_weights_run39 = new double[][]{{-1.02864, 0.3273034, 1.45023, 1.850634, -0.9856938, 0.5441931, 2.119227, -0.7843528, 0.5139969, -0.9630165, -0.07358352, 0.9185026, 5.290683, 0.9091678, 0.3620018, 0.8854066, -1.445607, 0.0375599, -0.5034639, 0.5141245, -0.4724502, 0.7845047, -1.058256, 0.8798043, 0.8173088, -1.224477, -0.9910309, 0.5094386, 0.430652, -0.2221714, -2.395146, 1.503358, 0.5239866, 1.778775, -1.268965, -0.4029132, -1.586325, -0.4030003, 1.358356, 0.8788674, -0.6219935, 0.576816, -0.04358268, 0.6259568, -0.5719956, -1.16517, -0.9640183, 0.5428737, -0.4366238, 0.4735517, -0.2494671, -0.6655799, 1.589269, 0.08133234, -1.307171, 2.791493, 0.08769181, -2.073229, 0.364311, 1.789362, -0.1081592, -1.714342, -1.570524, 0.3845745, 1.076707, 0.5557213, 0.2064193, 1.443529, -0.06455161, -0.2844217, -1.029348, -0.4754765, 0.7271122, 0.8562564, -0.9465616, 0.3721402, -0.05829101, -1.205841, 0.6081762, -0.4098553}, {-0.1513662, -0.141242, -1.355359, 1.58012, -0.3491726, -0.5441911, -0.04757158, 1.358662, -0.07719129, 0.3256148, -0.6179655, -0.7913457, 1.291487, 1.865813, 1.312444, 0.1729584, -0.5829416, 0.6819526, -0.2636668, -2.615658, 0.4543323, -0.9717481, 0.01345715, -1.218729, -0.9060318, 1.86718, 1.705147, -0.780288, 0.0591477, 0.2559791, -1.09836, -0.9302036, 1.377203, -0.8399954, -0.3570192, 0.2746445, -0.003505855, -1.372853, 1.097033, 0.4438565, -0.1185879, 0.484925, 0.9559125, 0.1524073, -0.8691744, -0.545947, -0.8253153, -0.1363966, -0.6217844, -0.5164209, -0.2476145, -1.159885, 0.8113868, -1.626468, 1.603318, 1.181425, -0.6378908, -0.7126339, -0.1457644, 1.641874, -0.3791535, -1.892753, -0.8176998, 0.6507391, 0.6779729, -2.044225, 0.4614784, -0.01208596, -0.7519335, -0.4293145, -0.7622466, 0.08738293, -0.4939852, 0.6653093, 0.613026, 0.602842, 0.9527184, -1.509421, -1.321201, 0.1446165}, {0.7107071, -0.49871, -1.031347, 0.6631881, 1.370709, -4.111377, 1.023866, 0.9085061, -0.3561266, -1.756233, -1.128304, 0.2606159, -19.51462, 2.97186, 0.4017389, -2.721159, -0.04446399, -0.6089693, -1.293759, 0.04276523, 0.7283584, -0.8824133, 1.008613, -1.697539, 0.9204667, 0.3166942, 0.1294861, -0.5347721, 0.4248439, 0.1432067, 4.291277, 1.562832, -1.793363, -1.592543, 1.651411, -0.001671116, -0.8169024, -0.2180657, 1.374536, 0.9392562, 0.610976, -0.4934626, 0.2681007, -0.4485983, 1.370646, -1.435785, -0.9618746, -1.903451, -1.50873, -0.7185509, 2.081986, -1.697802, 0.3972071, 0.3309597, -1.020784, -4.627172, 0.5506887, 0.7282418, 1.085633, 1.510299, 1.071759, -0.3684537, 1.087223, 1.35299, 0.08403855, 1.454523, 0.1686699, -0.3059338, -0.3451367, -0.8203987, 3.024044, 0.7079532, -0.06850714, -0.8129181, 0.5161046, 0.3130742, -0.1316258, 1.930693, 0.4858416, -0.7376671}, {-0.07762396, 0.6227359, 4.341908, 3.206713, -2.188759, 7.882429, -0.3054329, -1.792776, 0.3843426, 4.191176, -2.019327, -0.6305718, 57.70045, -0.9820923, -0.8067748, 14.77471, -1.134736, 2.840463, -1.321009, 0.1629766, -4.107762, 1.644833, -2.780101, 1.706493, 0.1019608, -2.683397, -3.762907, 1.413559, 0.01836276, 2.943215, -10.36286, -2.243308, 5.905794, 4.149498, -0.9176546, -0.9121519, 1.041608, -1.667465, -2.119316, 0.1644846, -2.023599, 0.8867444, -1.710568, -2.581954, -2.771907, -2.043817, -2.16788, -0.06429396, 2.786401, 1.778788, -1.424264, -1.953928, 2.400017, 1.296091, -2.337355, 3.235111, -2.555179, -1.032419, 1.349651, 0.1126638, -1.040495, 2.159661, -0.7299529, -4.176107, 1.101193, -1.429352, 1.810645, 2.538473, 0.9533013, 3.356308, -5.987496, 0.8938388, -1.40009, 0.6335884, -3.956538, 0.1831205, -1.137888, -0.7579974, -3.646068, 2.490107}, {0.5407537, 0.3225077, -1.195118, -0.009209585, -0.5515351, -1.823319, -0.6573718, 2.061948, -0.2834533, -0.2421928, 0.5000776, -0.4738606, -4.07408, 0.7223543, 0.1917774, 2.84743, 0.4607697, -0.773055, -0.8958312, 2.335453, 1.475993, 1.724258, 1.989218, 0.4825041, 1.517378, 2.300138, 0.5703946, 1.458527, -0.03233997, -1.333537, 4.954449, 1.443462, -2.149797, 0.465892, 0.7429065, 1.400349, -1.067723, 1.9798, 2.131769, -1.945057, 1.698011, 0.2206188, 0.8111503, 0.9760413, -1.677718, 0.6835501, 2.110476, -0.1963312, -1.033981, 0.06509496, -0.1911383, 0.759563, 0.5972295, -0.6882876, 1.851074, -4.738149, -0.5585422, 1.000982, 0.07346752, 0.05850136, -0.4339274, -0.5074688, 0.8159048, 1.755665, 0.09913584, 1.076926, -0.8606169, 0.844202, -1.164629, -0.5455661, 5.209866, -1.561608, 2.984425, -0.3071805, 1.268603, 1.152527, 0.9750946, -0.4695968, 0.1492485, 0.5413353}, {-4.111478, 0.986081, 13.28753, 2.436145, -5.468512, 16.48101, -5.23209, -7.35417, 6.839494, 15.76588, -2.130263, -3.305749, 86.36438, -7.346375, -4.713102, 34.1595, -4.895496, 8.014635, -2.478626, -3.465616, -4.132648, 4.957179, -4.503455, 10.70192, 2.428137, -6.509274, -9.658916, 2.671412, -6.70906, 7.822658, -30.82878, -5.827442, 13.88321, 11.97477, -4.794949, -1.309176, 8.752268, -5.887034, -6.282693, 0.07391378, -2.803486, 5.359119, -4.63507, -5.162092, -6.28319, -5.921765, -6.351967, -3.960878, 11.90987, 6.417547, -5.40425, -3.639157, 7.404305, 8.335506, -6.231016, 16.84628, -4.267122, -3.974711, 1.443708, -1.655544, -1.256148, 9.233847, -7.356833, -6.627114, 5.788129, -4.135643, 6.230348, 10.20335, 4.169735, 9.652097, -12.75852, 6.548829, -4.221786, 6.103588, -6.041092, -2.000523, -4.946797, -6.245307, -6.751211, 3.558194}, {-4.063347, 1.892127, 5.641768, 2.465293, -1.946999, 8.167302, -1.999968, -5.044397, 4.029574, 8.4526, -2.431684, -3.222912, 32.97318, -4.250467, -1.68758, 11.88009, -0.5191894, 3.914913, -2.458869, -0.1243346, -6.043478, 2.149151, -4.820219, 4.829615, -0.1017795, -5.690404, -2.682749, 2.948072, -3.038706, 4.03402, -21.22466, -2.916359, 6.908819, 7.259174, -4.68039, -1.740042, 4.326658, -4.453294, -3.866313, 0.6617756, -2.443606, 2.268698, -4.027297, -2.763399, -4.52226, -1.993286, -4.120534, -0.7157414, 4.045464, 2.228764, -5.011538, -3.537691, 1.593213, 3.181492, -4.304257, 14.09592, -2.147154, -1.369212, -1.004619, -1.396837, -1.054845, 3.603155, -4.210173, -7.025674, 1.704426, -2.332328, 3.925208, 4.845739, 1.499455, 4.886853, -7.589726, 3.471988, -2.723701, 3.243072, -4.319954, 0.3362255, -3.438054, -2.316236, -6.69307, 3.044091}, {-0.6147025, -0.7226155, 7.099229, -0.6954497, 1.636326, 14.61316, 1.573823, -1.745396, -0.8483863, 6.847863, -1.202765, 1.685428, 69.37821, 1.548805, 1.826795, 15.4206, 0.6564782, -4.140233, 1.481884, 0.5566636, -0.7747134, -1.453937, -2.373691, 2.74736, -1.688034, -7.280803, 3.186169, 0.1355979, 1.520299, -4.620399, -42.45459, -1.988969, 6.448956, 1.263444, -3.803375, -0.4256859, -1.326386, -0.03717073, -1.375702, 0.6056919, -1.361652, -1.326205, 1.386105, 1.479149, -0.7186177, 0.09709089, -2.255897, 1.673587, -3.173054, -1.880666, -0.8073879, 1.713125, -2.891011, 0.5030514, -4.242791, 32.23316, 0.8228428, 1.34237, -0.3629054, 2.227386, 0.6214462, -4.035555, -2.984075, -7.177989, -3.079872, 1.690334, 0.01948633, -5.617353, -1.482218, -3.522802, -13.1052, -2.233889, -0.1247562, -2.169668, -1.492896, -1.151376, -0.4875574, 0.454842, -4.608017, -3.492397}, {-7.676233, -2.09972, 25.06844, -1.696885, -3.524554, 44.43758, -0.8297911, -17.36607, 0.6757512, 9.371397, -2.975999, -1.392712, -91.87932, -3.291607, 1.213669, 25.84294, -0.7968557, -0.9809002, -1.926156, -0.3007228, -10.79624, -2.914749, -17.23936, 15.24559, -2.228372, -25.51307, 1.224843, -1.001511, 1.478333, -2.423707, -41.91687, -16.94231, 26.34527, 16.36721, -5.60457, -0.3669323, 1.159508, -5.312253, -7.391905, 1.18246, -7.463729, -2.476199, -4.490124, 2.113884, -11.04806, -4.965501, -13.62059, -1.145157, -2.705824, -2.783081, -9.360642, 0.7133185, -1.402998, 4.892941, -16.92367, 51.94911, -2.975311, -4.083529, -0.7629231, -2.17732, -1.064935, -0.3616789, -10.64793, -29.01962, -3.01, -5.70044, -0.803103, -8.596565, -3.303827, -6.007184, -36.32454, -4.760644, -0.7406937, -0.2122352, -13.23181, -0.5929065, -9.217285, -5.406741, -22.80784, 1.135054}, {8.291358, -10.04173, 19.57223, -2.658252, 9.636527, 33.55964, 5.701524, -5.832507, -14.94833, -34.16466, 4.929083, 5.204349, -157.3745, -0.1442399, 2.299665, -61.7789, 1.958858, -5.072369, 1.217968, -0.7753251, 13.22831, -3.275862, 4.128959, 10.89347, -4.279474, -9.950483, -11.8305, -15.22401, -0.01617905, -1.081354, 88.35788, -0.613747, 17.46461, 8.445068, 17.77472, 0.2137866, 2.211863, 9.564369, 11.84998, 0.1796683, 5.021122, -4.112635, 2.860984, 6.237879, 6.235407, 4.111607, 4.764628, 4.208476, -2.476379, -1.410406, 11.91089, 4.005244, -3.444561, -2.538424, 0.1905333, -32.83273, 4.179701, 5.312255, -0.9921808, -0.2802907, 1.042764, -6.835824, 14.87412, 7.055853, 0.166508, -0.1549118, -16.69674, 2.888052, -3.101948, -3.090365, -2.499126, -2.639177, 9.749999, -10.64873, -1.033954, -3.546012, 5.221563, -9.310549, 7.640431, -4.880867}, {6.733712, 4.537154, -9.089794, 4.343091, -0.2827602, -8.253601, -2.242396, 10.48913, 5.704419, 2.118842, -1.016424, -2.173887, 64.63124, -0.08498792, -3.109241, 42.18453, -2.223435, 7.176433, -2.05998, -1.869379, 5.648009, 3.939255, 9.982566, -7.42107, 5.325809, 13.51965, -3.095293, 4.859943, -4.658389, 14.45019, -19.81835, 10.53659, -10.11427, -7.930146, 0.5997236, -0.2133208, 0.4858994, 2.001809, 5.414326, -0.5268777, 5.043309, 7.692229, 1.310841, -4.901385, 6.813241, 1.433493, 9.151952, -0.65231, 7.096129, 7.175983, 4.264324, -4.747308, 5.826045, -1.567729, 11.20266, -14.19859, 1.129634, 0.6723353, 0.2714055, -0.343229, 1.063938, 7.218638, 5.790783, 14.50458, 9.39467, 2.477658, 6.526001, 12.24759, 6.827596, 11.34604, 21.26379, 12.62694, -2.104113, 7.564218, 9.408858, 0.4530832, 7.311638, 2.134646, 12.94808, 3.946217}, {0.05338196, 0.4634211, -0.9310503, 0.7397123, -0.3428113, -1.807961, -0.1057854, 0.5560322, 0.2646176, 13.18115, -0.02778279, -0.2775304, 10.97651, 0.6351651, 0.1708656, 4.340022, 0.05514464, 0.7102168, 0.1356455, 0.05157073, -0.4795812, 0.2283716, 0.5764353, -0.5814183, 0.2202747, 0.8448938, 0.8378996, 0.7537339, -0.02966051, 1.028515, -4.937495, 0.6364199, -0.7584349, -0.2840548, -0.6238548, 1.983442, -0.08091146, -0.4961247, -0.6777866, 0.3558826, -0.001357723, 0.6103896, 0.2677708, -0.4687808, 0.1315603, 0.1433599, 0.1495384, 0.09216937, 0.6901541, 0.2114138, -0.2869359, -0.1853858, 0.5336776, 0.05106291, 0.3087997, 3.628099, 0.3160974, 0.1960341, 0.2962496, -0.110287, -1.117404, 0.6795782, -0.4419985, 0.2451708, 0.6382098, 0.7107745, 0.3992725, 0.8863263, 0.3864293, 0.8853133, -1.107776, 0.6864734, -0.3932107, 0.4452412, 0.4789896, 0.04910907, 0.08671582, 1.232569, 0.07237399, 0.1648006}, {1.830509, 0.1318733, -1.494859, 1.300582, 0.1405917, -2.158315, 1.180338, 3.688906, 0.1278238, 11.96418, 1.827566, 0.7084174, 7.580585, 4.575537, 1.626506, 2.178703, -0.3414717, -0.213505, -0.523027, 0.8682612, -0.7173595, -0.8059945, 3.950594, -5.149857, 0.6209105, 1.559531, 2.637236, -0.9974931, 2.477954, 0.04970768, 1.250335, 3.827616, -1.455764, -3.306997, -1.483128, 0.2068288, -1.313683, 0.4600376, 1.205782, 1.522822, 1.730343, -0.9434625, 1.173195, 1.311357, 3.074514, 1.217432, 1.617501, 2.128302, -0.9671883, -0.8426823, 0.5498269, 0.6543424, 0.6359701, -0.5406398, 1.913158, -0.9829539, 1.205369, 0.6450543, 0.8119066, 2.458279, -0.006599979, -0.2133889, 0.1947732, 0.1142345, -0.652323, 3.460003, 0.3468637, -0.5880261, 0.0909057, -0.2737845, 0.6644548, -0.6391881, 1.247666, 1.466306, 3.68965, 0.4149817, 3.172354, 5.405377, 1.607006, -0.5740986}, {2.640694, -0.3140073, -5.10326, -0.7317924, -0.4038456, 0.3987217, -0.4592411, 3.218122, -0.3495403, 2.357311, -0.3555055, -1.019734, 8.94517, 0.4556632, 1.806462, 6.770195, 1.087796, 2.178936, 1.531114, 0.2015063, 0.8630561, -0.8007429, 2.39603, -2.247521, -0.5311102, 4.694883, 1.658097, -0.9494332, -1.001475, 2.343774, 2.887957, 4.057385, -4.030913, -2.04989, -0.4827554, -1.820504, -0.1971082, -0.2092669, 0.3525952, 1.047139, 1.187431, 1.046007, 1.192408, -1.948878, 1.619399, 1.176467, 1.762047, 1.359441, 1.321678, -0.4846436, -1.345841, -0.2353995, 0.5092087, -1.873571, 4.69843, -0.1781725, 2.348054, 2.311716, 0.4358009, -0.2190884, 0.107663, 2.484361, 1.311288, 4.51841, 1.418976, 3.328067, -0.4513044, 2.694472, 0.004840999, 2.431208, -1.746286, 0.2280715, -0.5161564, 0.3680515, 2.199142, -0.1553135, 1.52308, 4.018511, 2.414243, -0.1850311}, {8.073792, -3.508476, -23.82793, -4.15417, 7.208023, -27.85493, 5.211186, 15.93214, -3.426143, 4.066162, 7.562752, 4.141473, 90.22609, 7.026833, 5.9204, 19.68624, 3.676406, -7.490682, 5.516861, 6.361498, 9.80567, -5.225524, 10.73059, -19.19358, -1.463815, 16.90648, 14.33787, -0.06440561, 7.252646, -4.803939, -17.78234, 13.49489, -23.06633, -20.10117, 6.463083, 0.6142401, -11.61195, 9.331916, 8.525952, -0.3809957, 11.51734, -6.031258, 8.218426, 4.352666, 11.00475, 8.265921, 11.14264, 5.032129, -9.656488, -5.518794, 7.747561, 5.199196, -7.413525, -12.72505, 15.42212, -5.804841, 6.224639, 6.967466, -0.2041288, -0.2356811, 1.377681, -7.075467, 7.505109, 13.14457, -4.973233, 9.758621, -3.46084, -9.792554, -3.063532, -7.598477, 15.29541, -5.884531, 4.772458, -3.567406, 12.86738, 0.6426378, 10.61014, 12.04248, 11.53341, -4.230638}, {10.11676, -1.11073, -17.55928, 2.635584, 7.000262, -24.11216, 6.116018, 14.40935, -1.872577, 4.684581, 5.676786, 2.422895, 13.41053, 7.029678, 5.533219, -1.245908, 1.454253, -2.817385, 2.870106, 2.912728, 9.169914, -3.672344, 12.43489, -12.5215, -0.2361414, 18.47795, 6.327286, -0.5446475, 4.126514, -0.9202047, -7.4733, 14.62712, -16.67613, -12.60912, 6.764418, 0.04983864, -5.84336, 5.907275, 8.866029, 0.9142414, 9.368072, 0.4696032, 6.990384, 2.882905, 10.55887, 5.827017, 11.28397, 5.228642, -2.161305, -1.602108, 10.04425, 3.945145, -2.038405, -6.241516, 14.31854, -18.21287, 6.445075, 5.019635, 1.189316, 1.434825, 0.2460805, -2.981356, 9.353168, 18.95868, 0.1065724, 8.616109, -1.768693, 0.3352798, -0.3354534, -0.3748839, 23.02538, 0.4518397, 3.261335, -1.475701, 12.47696, 2.907939, 10.06894, 9.639229, 17.17139, -2.243676}, {5.479183, -1.305227, -9.953253, -0.9265733, 1.701079, -13.67371, 2.619478, 8.332322, -2.252093, 6.455764, 2.800763, 3.392997, 29.83029, 4.527999, 2.74198, 7.892876, 3.066952, -1.187405, 2.740246, 2.876335, 4.193316, -0.9721033, 7.266235, -9.904804, -3.296724, 9.516911, 5.551584, 1.003427, 3.284963, -1.017867, -1.981972, 5.360139, -10.09195, -8.510015, 2.347901, 0.001290694, -4.173282, 2.983568, 3.172338, 1.052532, 3.272977, -0.559935, 4.045052, 2.819906, 5.188849, 4.196385, 6.247102, 1.486216, -2.06101, -4.098316, 4.012152, 3.355398, -1.992096, -4.9487, 5.600868, -4.019789, 4.388783, 4.615736, -1.526054, 0.7858629, 1.202618, -2.379762, 4.377397, 7.368104, -1.132498, 5.177159, -0.2171323, -4.039821, -1.53152, -2.469372, 9.039371, -1.633688, 1.710964, -1.517216, 6.735516, 0.8190565, 6.143662, 6.186527, 6.92958, -1.845401}, {5.655281, -0.5474563, -11.46856, 0.3171068, 4.036591, -15.56587, 3.969625, 11.04352, 0.701226, 11.12405, 3.190647, 2.931252, 0.1938203, 4.357134, 1.172682, 9.608564, 3.200678, -0.5179715, 2.636964, 2.515579, 6.34782, 0.9294084, 8.373701, -7.676174, -0.3544827, 14.71671, 5.992246, -0.804929, 2.510651, 2.339835, -2.307162, 10.137, -12.32581, -7.439453, 2.951442, 1.944543, -4.232266, 4.834068, 5.615529, 1.048042, 7.150208, 0.127474, 5.379114, 1.344092, 5.441534, 5.066245, 9.920047, 3.183811, 2.039011, 1.717012, 5.062809, 0.5430166, -1.651764, -1.269895, 11.1388, -6.129809, 3.837815, 3.992042, 0.09584884, 2.523199, 0.4451477, 0.4782338, 5.624941, 10.44904, 0.09397913, 3.573355, -0.055957, 1.613003, 0.2188484, 2.280278, 15.03378, 3.4188, 3.132179, -0.8279861, 10.02372, 2.023451, 6.707838, 6.967385, 9.193814, -1.255324}, {0.3451114, -0.9802359, 2.078351, 0.02605871, -0.3635275, 2.219193, 1.826062, -0.4193107, -0.583039, 0.01777046, -0.9993011, -1.060674, 3.915143, 0.06013179, 0.3775353, -1.089239, -0.3478954, 1.133769, -0.08900879, -0.8517134, -0.2296221, -1.172945, -1.23456, 0.9118137, -0.8198795, 0.6240238, -1.905496, 0.956572, 0.273142, 0.4912085, 0.1651377, 2.448041, 0.9321811, -0.2699914, -0.3806816, 1.072583, -0.5002164, 0.3209545, -0.2637818, 1.160337, 0.2305867, 0.7310093, 0.2208905, 1.723846, 0.2386335, 1.400005, -0.1178744, -0.3030411, 0.2272383, 1.46338, 1.180537, -2.051269, 1.413416, 1.23294, 0.6045038, -1.030456, -1.963751, -1.470617, 0.5286313, 0.04164621, 0.5841069, -1.243177, -0.08386297, 2.435309, -0.274628, -1.162998, -2.108996, -1.401231, 0.1352175, -2.035369, -1.435502, -0.9679518, 0.5397961, -0.6349177, -0.2067512, -1.582229, -0.06982567, 0.7912094, -0.4906165, 0.5784472}};
    private static final double[][] nodes_output_weights_run39 = new double[][]{{-5.669656}, {3.130231}, {35.73236}, {3.019328}, {-5.763418}, {61.68781}, {-4.692912}, {-13.23132}, {5.937366}, {22.30954}, {-4.450063}, {-3.424416}, {151.9456}, {-5.814347}, {-4.583418}, {40.28491}, {-3.11589}, {8.564333}, {-3.435397}, {-3.435988}, {-7.620337}, {4.561136}, {-8.853918}, {19.85886}, {2.749105}, {-19.76451}, {-10.43931}, {2.28122}, {-5.918178}, {9.507173}, {-54.71448}, {-10.39111}, {34.65474}, {20.51415}, {-7.200848}, {-0.513216}, {8.653513}, {-6.24677}, {-6.19536}, {-0.508266}, {-6.281495}, {5.905231}, {-5.301845}, {-4.963099}, {-7.50751}, {-5.236133}, {-8.144489}, {-3.338085}, {11.44201}, {6.542197}, {-6.608939}, {-4.832664}, {7.059961}, {9.087248}, {-11.54834}, {35.42155}, {-4.343641}, {-4.573209}, {0.3349311}, {-0.7958422}, {-0.8877248}, {9.495857}, {-7.287066}, {-16.45647}, {6.034534}, {-5.997689}, {5.772654}, {13.93864}, {4.182245}, {11.76804}, {-26.76565}, {9.256895}, {-4.307285}, {5.571597}, {-9.296066}, {-0.7214952}, {-6.782744}, {-8.339615}, {-12.17481}, {3.890761}, {1.653445}};
    private static final double[][] nodes_output_scale_run39 = new double[][]{{-1.3, 3.75}};
    private static final double[] nodes_output_scale_off_run39 = new double[]{0.1};
    private static final int[] nodes_output_scale_flag_run39 = new int[]{0};
    private static final double[][] nodes_output_scale_limits_run39 = new double[][]{{-1.3, 1.7}};

    public static int compute(float[][] in, int getNumNodesInput, float[][] out, int getNumNodesOutput, int width, int[] mask, int errmask, float[] a) {
        int x;
        int nodes_input = 18;
        boolean nodes_output = true;
        boolean nodes_input_bias = true;
        boolean nodes_input_pca = true;
        int nodes_hidden = 80;
        boolean nodes_hidden_bias = true;
        double nodes_hidden_temperature = 1.0;
        double t_input = 0.05555555555555555;
        double t_hidden = 0.0125;
        if (getNumNodesInput <= 0) {
            return 18;
        }
        if (getNumNodesOutput <= 0) {
            return 1;
        }
        if (getNumNodesInput != 18) {
            return -1;
        }
        if (getNumNodesOutput != 1) {
            return -2;
        }
        double[] vt = new double[19];
        double[] vt1 = new double[81];
        int[] rcheck = new int[width];
        for (x = 0; x < width; ++x) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }
        for (x = 0; x < width; ++x) {
            int j;
            int i;
            if (mask[x] != 0) continue;
            if (rcheck[x] != 0) {
                for (i = 0; i < 18 && a[x] > 0.0f; ++i) {
                    if (!(in[i][x] < (float)NN_General.NODES_INPUT_SCALE_LIMITS[i][0]) && !(in[i][x] > (float)NN_General.NODES_INPUT_SCALE_LIMITS[i][1])) continue;
                    int n = x;
                    a[n] = a[n] - 3.0f;
                }
                if (a[x] < 0.0f) {
                    int n = x;
                    mask[n] = mask[n] | errmask;
                }
            }
            for (i = 0; i < 18; ++i) {
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                    in[i][x] = (float)Math.log(in[i][x]);
                }
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] != -2) continue;
                in[i][x] = (float)Math.exp(in[i][x]);
            }
            for (i = 0; i < 18; ++i) {
                in[i][x] = (float)NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float)nodes_input_scale_run39[i][0]) / (float)nodes_input_scale_run39[i][1];
            }
            for (i = 0; i < 18; ++i) {
                vt[i] = in[i][x];
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] != 1) continue;
                vt[i] = 0.0;
                for (j = 0; j < 18; ++j) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[j] != 1) continue;
                    int n = i;
                    vt[n] = vt[n] + (double)in[j][x] * nodes_input_pca_evec_run39[j][i];
                }
            }
            for (i = 0; i < 18; ++i) {
                in[i][x] = (float)vt[i];
            }
            for (i = 0; i < 18; ++i) {
                vt[i] = in[i][x];
            }
            for (i = 18; i < 19; ++i) {
                vt[i] = 1.0;
            }
            for (i = 0; i < 80; ++i) {
                vt1[i] = 0.0;
                for (j = 0; j < 19; ++j) {
                    int n = i;
                    vt1[n] = vt1[n] + vt[j] * nodes_hidden_weights_run39[j][i];
                }
            }
            for (i = 0; i < 80; ++i) {
                vt1[i] = 1.0 / (1.0 + Math.exp(-0.05555555555555555 * vt1[i]));
            }
            for (i = 80; i < 81; ++i) {
                vt1[i] = 1.0;
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = 0.0f;
                for (j = 0; j < 81; ++j) {
                    float[] fArray = out[i];
                    int n = x;
                    fArray[n] = fArray[n] + (float)(vt1[j] * nodes_output_weights_run39[j][i]);
                }
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = (float)(1.0 / (1.0 + Math.exp(-0.0125 * (double)out[i][x])));
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = (float)nodes_output_scale_run39[i][0] + (out[i][x] - (float)nodes_output_scale_off_run39[i]) * (float)nodes_output_scale_run39[i][1];
            }
            for (i = 0; i < 1; ++i) {
                if (nodes_output_scale_flag_run39[i] == -1) {
                    out[i][x] = (float)Math.log(out[i][x]);
                }
                if (nodes_output_scale_flag_run39[i] != -2) continue;
                out[i][x] = (float)Math.exp(out[i][x]);
            }
            if (rcheck[x] == 0) continue;
            for (i = 0; i < 1 && a[x] >= -2.0f; ++i) {
                if (!(out[i][x] < (float)nodes_output_scale_limits_run39[i][0]) && !(out[i][x] > (float)nodes_output_scale_limits_run39[i][1])) continue;
                int n = x;
                a[n] = a[n] - 20.0f;
            }
            if (!(a[x] < 0.0f)) continue;
            int n = x;
            mask[n] = mask[n] | errmask;
        }
        return 0;
    }
}

