/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew.util;

import org.esa.s3tbx.fub.wew.util.NN_General;

public class NN_CHL {
    private static final double[][] nodes_input_scale_run46 = new double[][]{{0.04165578, 0.01161174}, {0.03520901, 0.01063665}, {0.02920864, 0.01050035}, {0.02699881, 0.01067741}, {0.02323033, 0.0116831}, {0.01756723, 0.01029849}, {0.01578173, 0.009680594}, {0.01385489, 0.008916431}, {0.01205267, 0.00833976}, {0.01165661, 0.00827879}, {0.01021728, 0.007993388}, {0.009918789, 0.007898618}, {1.5, 6.362889}, {980.0, 66.66667}, {0.24683, 0.8368545}, {-0.661312, 1.469582}, {-0.661312, 1.469582}, {0.750111, 0.2776545}};
    private static final double[][] nodes_input_pca_evec_run46 = new double[][]{{0.03720327, -0.006549362, 0.290008, -0.201132, -0.2636388, 0.1000999, 0.198887, 0.3842379, 0.3697517, 0.4917516, 0.3975768, 0.2658775}, {-0.07429894, 0.01068907, -0.5029083, 0.3833335, 0.3383938, -0.2430734, -0.254239, -0.1231907, 0.1379914, 0.389595, 0.3001655, 0.2831438}, {0.07845022, -0.01058433, 0.5055317, 0.07206815, 0.1937728, 0.3558653, -0.1338966, -0.5287648, -0.3204458, 0.08516721, 0.272326, 0.2952431}, {-0.07074016, 0.01181506, -0.4342866, -0.4750146, -0.3953407, -0.1178391, 0.1415893, -0.2009202, -0.4232329, -0.08591454, 0.2770834, 0.2945049}, {0.03123067, -0.01055081, 0.1309456, 0.396493, 0.1079823, -0.1593584, 0.1748466, 0.5287397, -0.3604911, -0.4281425, 0.2928995, 0.279853}, {-0.06070631, 0.03621924, -0.08247021, -0.4983808, 0.5022736, 0.186704, -0.17687, 0.1115609, 0.3642774, -0.4309476, 0.08158333, 0.2896247}, {0.03657514, -0.01518169, 0.09115503, 0.2231538, -0.5746984, -0.07423916, -0.5464398, -0.09883767, 0.3168623, -0.3258191, -0.04080405, 0.2965555}, {0.09185909, -0.1000179, -0.1570246, 0.281134, -0.05121132, 0.1760552, 0.6799967, -0.3263152, 0.3558768, -0.1904168, -0.1519412, 0.2989599}, {0.5039719, -0.2352205, 0.2160997, -0.2123316, 0.1521358, -0.6111421, 0.02233613, -0.06475601, -0.03176413, 0.1108682, -0.3135614, 0.2931657}, {-0.6049851, 0.5385982, 0.2386558, -0.01836866, 0.03274459, -0.2786882, 0.1092206, -0.0505336, -0.02032057, 0.08590607, -0.3154111, 0.2934483}, {-0.3997149, -0.6664546, -0.05252006, 0.006949377, -0.004719049, 0.2494778, -0.09866458, 0.1978459, -0.1774924, 0.168327, -0.3743445, 0.2866168}, {0.4332827, 0.4453712, -0.2355489, 0.04329192, -0.03259577, 0.424509, -0.1132328, 0.2511418, -0.1995074, 0.1797701, -0.3817864, 0.2854951}};
    private static final double[][] nodes_hidden_weights_run46 = new double[][]{{-0.5127986, 0.5872741, 0.4411426, 1.344507, -0.7758738, -0.7235078, 2.421909, 0.01923607, 0.2095671, -1.854303, 0.3067815, 0.7324489, -1.439929, 0.9445596, 0.2732355, -4.10689, -1.738242, -0.8901453, 0.4079534, 0.4458184, -0.6862928, 0.8213179, -0.299251, 0.5181425, 1.144172, 1.385928, -0.8248739, 0.5189461, 0.5226253, -0.7908759, 1.64722, 2.149709, -1.716757, 1.433486, -1.394956, -1.465779, -1.882348, -0.2427909, 1.55644, -1.333128, -0.177327, 0.5495471, 0.4280278, 0.2961606, -0.05747508, -0.7513083, -0.400525, -1.173682, -0.5821932, -0.1474722, -0.1536111, -1.052891, 1.410916, 0.03333437, -0.9930057, 1.529344, 0.1895313, -0.3366092, 0.2864338, 2.209214, -0.5772508, -1.957571, -1.591362, 0.4745838, 0.1171258, 0.5930325, -0.1926282, 0.6576979, -3.836553, -0.2504783, -0.5312367, -0.5237725, 0.4766606, 0.3678577, -0.4312671, 0.5830966, 0.476651, -0.8505184, 0.7696922, -0.4072182, -0.9390821, -0.04210852, -1.456445, 0.5233867, -1.134155, 1.603893, 0.5073252, 1.211945, -0.4888498, 1.004863, -0.568474, -1.310794, 0.751539, -0.7107704, 1.56325, -1.522923, 3.047624, -0.1534142, 1.955046, 0.7811737}, {-0.03086223, 0.02346106, -1.44291, 1.426404, -0.3596204, -0.6021846, -0.008177614, 1.55515, -0.1042204, 0.1950469, -0.540629, -0.9378908, 1.064399, 1.795686, 1.227751, -2.803651, -0.7341231, 0.3705561, 0.3165067, -2.708519, 0.1924795, -0.8950356, 0.1903615, -1.114939, -0.6840401, 3.588653, 1.692587, -0.7687381, 0.02051575, 0.1095054, 1.169622, -0.8381531, 0.521698, -0.7104531, -0.5496677, -0.09004661, 0.02875932, -1.431424, 1.078108, -6.814132, -0.04054059, 0.5498323, 1.074416, -0.03113689, -0.8042992, -0.4523238, -0.7276333, -1.650421, -0.5204643, -0.6879292, -0.3433933, -1.40249, 0.8376524, -1.479028, 1.55991, 1.178643, -0.6795714, 0.5303804, -0.1744758, 1.821641, -0.6060833, -1.845941, -0.9743568, 0.4165528, 0.3324597, -2.143277, 0.3869756, -0.1984425, -3.202465, -0.2122254, -0.9261276, 0.1632761, -0.6692447, 0.5372459, 0.6795959, 0.6631287, 1.068918, -1.477327, -1.476734, 0.2204985, 0.1924559, -1.004765, -1.166832, -0.1050871, 0.01313884, -2.106215, -0.4745361, 1.237264, -0.1644034, 0.8202621, -1.283196, -0.4136712, -0.4603846, 0.3425888, -1.494976, 0.05236935, 0.5415043, 0.1604839, -0.4934537, 0.4298064}, {1.352883, 1.34945, -0.707317, -0.807572, 0.72295, -2.487171, 0.8516108, 1.975422, -0.007762858, -0.9210697, -0.8756055, -1.425222, -3.197115, 1.603326, -0.9992384, -18.99149, -1.839617, -2.634727, 3.753211, -1.025298, -2.232048, 0.3269269, 2.075636, 0.1308576, 3.213572, 18.43426, -1.051487, 0.005627586, -0.5392435, -0.4783201, 22.67913, 1.931319, -9.181037, 0.3571902, -0.7726832, -3.425769, 0.220656, -1.185817, 0.5164191, -56.70884, 0.8590321, 0.5531543, 0.7509177, -2.669284, 1.568891, -1.077539, -0.5654035, -18.12088, 0.3288304, -1.696227, 0.6271689, -4.325982, 1.263076, 2.373747, -2.000674, -2.82619, -0.2602996, 13.16487, 0.8694284, 2.852845, -1.046052, 1.02044, -0.9124451, -1.342345, -2.647766, 0.1453673, -0.0146764, -0.9782002, -28.98477, 2.066114, 0.5446665, 2.136242, -2.159251, -1.480626, 0.535495, 0.7263461, 0.3839321, 1.577012, -1.419213, 0.4027827, -1.844903, -0.1365434, -0.1921733, 0.05711406, -1.548073, 4.671999, 0.2048477, -1.058281, 0.2586571, -2.050824, 0.2404677, -2.104983, -0.4304744, -0.08998591, -1.435968, 1.562596, 23.43436, -0.3132435, -1.8216, -0.6299615}, {5.588117, 5.771654, -5.196276, -3.425856, -0.9725067, -2.946342, 2.151807, 7.320869, -1.713146, -1.754712, 1.867271, -4.763624, -8.704128, -2.469006, -3.392507, -30.04741, -6.064856, -8.773853, 12.19746, -1.738451, -10.40658, 3.553547, 6.040166, 0.546747, 6.131941, 28.89395, -3.383471, 2.281311, -0.2460507, -3.289957, 21.05227, 4.221361, -21.70537, 3.214825, -5.674147, -14.98797, -0.3604725, -1.41643, -1.482997, -17.51848, 2.543166, 1.981895, 3.365135, -8.710091, 2.238295, 2.482517, 3.763151, -34.42835, 3.875528, -5.425309, -2.521564, -8.868567, 1.611753, 3.654951, -0.5326183, -4.411193, -2.656364, 21.72192, 0.3424946, 5.793386, -8.577917, 1.862482, -3.739266, -7.274971, -12.27419, -2.764753, -1.786645, -5.89283, -53.74416, 7.519266, -4.080158, 2.281967, -6.818449, -4.771087, 0.9972876, 2.593331, 4.536029, 2.315063, -4.769114, 4.068366, -9.239391, -2.601215, -0.5065892, 0.6001852, -0.6759643, 8.211049, 0.437467, 0.03129493, -2.745959, -10.03424, 0.6336873, -6.364903, 1.550542, 5.407603, 1.369259, 0.908023, 56.67294, -5.10458, -4.236973, 2.598948}, {-1.834918, -1.144287, 2.532951, 3.489994, -0.6074476, 2.178933, -1.358945, -0.1751544, 0.3936138, 1.195904, -0.9915487, 1.637291, 1.48702, 2.283435, 2.23777, -10.87652, 3.65734, 1.581503, 1.267863, 3.981416, 2.564868, 0.2163323, -1.036495, 0.4077188, 0.7820607, 9.839235, 1.85715, 0.7918916, 0.9408977, 0.8952003, 18.96678, -1.145519, -4.845967, 0.3990709, 2.75135, 8.827563, -1.356885, 2.203841, 2.130471, -84.15093, -0.18321, -0.8968477, -1.180663, 3.891321, -4.119871, -0.9510443, -0.4711037, -10.82164, -2.47251, 2.881717, 0.6749327, 3.577859, 0.01760674, -1.880931, 0.8027223, 1.730537, -0.06596847, 6.965985, 0.5609655, -1.928382, 2.16838, -1.417131, 2.420148, 2.210628, 3.113947, 2.44662, 0.5889618, 3.752061, 5.353685, -1.138828, 2.947213, -2.925341, 5.731029, 1.827308, -0.8747456, 0.08462647, -1.399136, -1.01196, 0.4553246, -0.7131851, 1.569227, 1.740112, 0.4387566, -0.1680268, 2.313564, 0.8446504, 0.2247418, 1.015277, 0.1550954, 2.112951, 1.712803, 2.360776, 0.09686406, -1.714227, 0.8272943, -0.3504066, -15.18886, 3.116717, 4.366713, -1.326136}, {-3.306327, -7.735957, 5.599158, 8.364865, 1.505144, 4.627226, -1.055382, -3.738263, 1.638105, 3.670702, -0.2730946, 5.955596, 5.259044, 2.56916, 5.267802, -15.92109, 6.311599, 5.184847, 4.555474, 4.400404, 8.968072, -3.91672, -5.316667, -2.889037, -3.974865, 42.28981, 2.341423, -1.585713, 1.896613, 5.389801, 15.70447, -4.030313, 2.976446, -2.677845, 9.830899, 9.498944, -1.545731, 1.886329, 1.1291, -69.06606, -0.2936392, -3.081717, -3.250263, 8.282053, -4.461303, -3.771111, -4.443964, -9.106223, -2.962334, 6.637461, 4.550842, 9.634565, -1.980642, -4.269017, 0.5076793, 2.426823, 2.130142, 24.34254, 2.131048, -5.735264, 6.559469, -3.378582, 4.881039, 7.012393, 11.78352, 5.347425, 3.501809, 5.43869, -36.51983, -3.807065, 1.051661, -4.078433, 8.041446, 4.946906, -3.015761, -3.530601, -3.348852, -0.2608221, 4.376321, -4.361954, 7.655452, 2.573621, 0.6618983, -4.639479, 1.157284, -4.084773, -3.705652, 2.792275, 5.053955, 8.151063, 0.3896389, 6.623966, -3.672256, -3.945537, 0.01175464, -0.4425615, 26.47739, 6.844576, 7.112192, -1.684655}, {-14.29539, -17.4368, 14.44826, 22.71308, 3.405113, 11.95405, -2.363062, -18.99253, 2.213098, 7.039115, -8.229271, 15.97428, 24.01051, 10.56072, 14.57076, 93.06738, 21.73676, 26.43192, -32.5279, 12.11482, 22.40733, -11.61126, -19.86157, -10.04499, -20.63285, -77.87376, 8.068388, -3.345641, 6.727478, 15.24128, -83.40353, -11.57728, 52.37169, -9.140374, 21.16543, 39.21345, -4.358436, 4.449519, 3.598048, 126.628, -8.666273, -9.159225, -12.94036, 22.52607, -10.94987, -9.08722, -13.08875, 80.36578, -14.54801, 17.38453, 9.846357, 24.55227, -6.635566, -17.13705, 2.220991, 10.34912, 5.835941, -56.8374, 2.015926, -17.42133, 23.08331, -10.02476, 17.34479, 19.95593, 32.91195, 11.71488, 8.306674, 18.64292, 160.9648, -19.45371, 8.918959, -10.96417, 21.3843, 13.89167, -9.422063, -5.572433, -12.69006, -2.07766, 11.71534, -9.472145, 23.92121, 3.775932, 2.252352, -9.444231, 3.681731, -20.28355, -1.231658, 4.677825, 10.27687, 27.54918, -0.6901098, 14.27828, -10.4359, -16.23627, -0.9078479, -5.132616, -141.5259, 20.65318, 18.54206, -8.880925}, {-0.8565353, -1.272805, 0.2651477, -1.429737, -0.2109381, -1.214878, -0.1696926, -2.000853, -0.3779667, 1.196745, -2.09667, 1.033227, 3.235448, -0.004705734, -0.8868623, 113.5299, -1.953699, 2.240431, -14.31527, -1.399302, 3.423341, 0.3908022, -1.136156, -0.1694068, -4.622261, -67.75519, -0.4463461, 1.023714, -1.167196, -3.149421, -112.7578, 0.2658637, 18.80389, -1.447741, -2.369795, -13.54774, 0.2853332, -0.9719453, -1.280875, 137.5854, -1.886171, 0.6505643, 0.3585852, 0.003050753, 0.3824904, -1.2139, -1.410695, 34.90693, 0.02642717, -0.4825277, -0.3325215, 1.689085, -0.1337276, 0.4052961, -0.9105567, 0.6198885, -0.1538776, -43.5655, -0.2286596, 1.252615, 1.831145, -1.350863, -1.79922, 0.0710838, 2.563186, 0.48518, 0.3253613, -2.226355, 53.40136, -3.520195, 0.4655041, -0.2798297, -1.10026, -0.6853272, 0.3287781, -0.3050158, -0.5917823, -0.1424656, -0.5322437, -2.43132, 2.695874, -1.121621, -0.1460533, -0.2496175, -1.408669, -2.181731, -1.016933, -0.7698706, 0.06252892, 2.711806, -1.074213, 0.3291167, -0.3212154, -0.7409858, -0.5802168, -0.2707439, -75.32172, -1.029958, -2.427787, -0.6418096}, {-3.683146, -0.1137055, 0.1093676, -1.353721, -1.642487, -1.522378, -0.2811397, -6.262838, -0.1643361, 0.02186965, -1.751594, 1.223722, 6.979795, 1.953514, 0.8597751, 148.8089, -1.645612, 6.149414, -17.24702, -1.390202, 0.5123547, -3.007276, -0.5381632, -4.261878, -5.321834, -69.10213, 0.8249323, 1.08127, 1.169538, -0.4481871, -50.28622, -1.89809, 2.695106, -2.769352, -1.634349, -14.45991, -2.691027, -0.8068964, -2.293761, -79.07432, -3.355834, -1.717174, -3.096676, -2.976102, -1.300087, -4.073879, -4.871341, 24.01336, -4.522872, -1.548514, -0.5641333, -0.08381326, -0.2115211, -4.189013, -0.2562534, 1.05508, 0.3493386, -46.58295, -0.06419651, -2.089368, 1.696185, -3.359055, 0.4073677, 1.697881, -4.355837, -0.2569014, -0.8018155, -4.385417, 99.79734, -9.063401, -2.694557, -4.314368, -0.6252127, 3.106923, -1.075608, 2.439463, -3.756226, 0.4298554, -0.5508144, -0.7886537, 2.745297, -1.134057, 0.4952866, -2.912815, -0.4594947, -8.635502, 0.2056294, -1.625712, 0.7590871, 0.2535946, -0.04941935, 0.7109369, -2.190778, -3.375707, -1.308337, -1.132995, -241.2103, -1.84832, -1.713615, -0.2661104}, {-3.39252, -14.25146, 4.583967, -0.1597082, 2.769598, 3.357221, 0.06993336, -12.28999, -1.54861, 1.327137, -3.296424, 5.764402, 14.56153, 1.304904, 2.202561, -114.1838, 0.833122, 12.92648, -18.18887, 0.7747151, 14.19277, -2.954723, -14.6708, -1.351679, -13.99743, -23.41388, 1.480504, -5.224564, 2.273477, 2.241954, 122.662, -9.392466, 26.37569, -3.682375, 9.99482, 11.03284, 0.2640785, 3.381726, 0.9017737, -147.5907, -1.494215, -3.056333, -2.031282, 12.31342, -2.329169, -2.049791, -3.003882, 40.01229, -4.582237, 5.479842, 1.046687, 11.01248, -0.08208399, -6.621889, 0.2715683, 4.082793, 0.9402208, -19.67874, -0.3187995, -9.654532, 11.25889, -1.866193, 2.847841, 3.748204, 18.93611, 1.195535, 0.4246589, 2.053682, 4.914061, -13.70717, -0.3670801, -3.474021, 8.946075, -0.1440488, -4.738106, -8.774341, -3.504615, -2.808668, 0.05248463, -2.943622, 14.23132, 2.821801, -1.41117, -0.3501495, -0.8905475, -12.06785, -2.402384, 3.600397, 4.13745, 15.13138, 0.5680113, 3.020561, -0.523759, -9.330059, -0.1498492, -0.5334831, 76.3996, 9.313674, 2.668227, -4.496312}, {2.074557, 1.691501, 1.496361, 9.390691, 0.6782545, 1.881046, -1.299656, 4.819483, 1.249177, 2.685183, -1.843165, 0.3030032, -3.612973, -0.4391717, 5.37827, 23.00949, 8.203108, -3.89204, 12.61047, 6.653288, -2.942088, -2.828006, 0.4619567, -1.686906, 5.077454, 30.76857, 3.11833, -1.486392, 2.351664, 11.52325, -35.39993, 0.7270691, -9.02743, -0.8707408, 0.8819555, 12.96885, -1.882358, 2.62488, 5.298423, 60.63804, -0.5353298, -0.7500148, -0.5353779, 0.9006185, -2.459405, -0.9936161, 0.8414442, -5.489459, 0.7609594, 3.619462, 2.704998, -2.018402, -2.349747, 2.001028, 2.258791, -0.03823281, 3.228426, 25.46947, 1.243099, 0.8209361, -1.512475, 2.189308, 3.878181, 3.032652, -0.729001, 4.553001, 3.914922, 7.65479, -17.19498, 5.559928, 8.462929, 2.916806, 1.852727, 5.017204, -0.6697068, -0.58239, 1.510194, -1.52045, 3.993659, -0.5095174, -2.961852, 3.18692, 2.32764, -1.280291, -0.2839373, 4.299108, -0.2019851, 4.086106, 2.761997, -1.591856, 0.245397, 3.016075, -1.430378, 3.125543, 0.308886, -0.9534749, 7.609602, 0.3166507, 8.920992, 0.2615876}, {-0.01395406, 1.138117, 0.00397061, 1.304513, -0.7232909, 0.1056709, -1.29213, 1.20812, 0.7579986, -0.1502032, -0.6561609, -0.6091535, -1.565854, 3.198395, 0.7315935, 7.363048, 0.7332617, -1.349533, 1.671779, 0.6624227, -1.20584, 0.03450307, 1.381775, -0.07616761, 1.256339, 2.525274, 0.8743837, -0.3307374, 1.0254, 1.051202, -8.810384, 0.779561, -0.8432046, 0.08352669, -0.7396431, 10.51925, 0.4123034, -0.1982141, 0.4409221, 11.1305, -0.2723862, 0.03140333, -0.9171481, -0.646367, 0.02154704, 0.1363431, 0.0473792, -1.337138, 0.3121849, -0.1721974, 0.5284876, -0.6042436, -0.1310655, 0.8464705, -0.906736, -0.2048852, -0.164908, 2.580942, 0.5354367, 0.8581642, -1.18421, -2.507707, 0.06494223, -0.247816, -1.069078, 0.9126305, 0.09370098, 1.00834, -1.748332, 1.393308, 2.090588, -0.2589129, -0.7313439, 0.5167233, 0.18292, -0.221631, 0.3894123, 0.7864162, 2.427254, -0.2080491, -1.05099, -0.2089033, 0.1335798, -0.2908286, 2.543334, 1.368892, -0.2997627, 0.3950833, -0.07308372, -1.187642, -0.384155, 0.06763153, -0.1708159, 0.8809779, -0.6852583, -1.536501, -4.082247, -0.632567, 1.173356, -0.2961746}, {3.460117, 4.348739, -0.4369323, 0.7414432, 0.09155872, -2.220241, 1.046217, 6.661813, 0.5142606, 0.3210036, 2.115863, -3.429734, -6.374058, 1.828723, -0.8176332, 6.163972, -2.443857, -6.718975, 6.584433, -1.333566, -6.247021, 1.771559, 5.222761, 1.062925, 7.371109, -4.226371, -2.224833, 0.4812533, 0.3519909, -0.564794, -2.267486, 4.27101, -3.590032, 2.602937, -4.142928, 8.133478, 2.232455, -0.8993057, 0.1074784, 6.234947, 2.535436, 1.589485, 1.215743, -2.17855, 3.468935, 2.181423, 2.571832, 5.611044, 2.503018, -1.961376, -1.621901, -4.25981, 2.141898, 4.827095, -0.4990435, -2.175932, -1.139387, 2.657871, 0.2480623, 5.147534, -4.908335, 0.3801594, -2.432226, -2.68382, -4.387501, -0.1328824, -0.8888114, -0.3644544, -3.557758, 6.592669, 1.654979, 3.174813, -2.195598, -0.09046417, 2.958037, 1.12468, 4.781672, 1.995378, 0.001347059, 2.333805, -4.147695, -1.583056, -1.894084, 2.790721, 0.06228548, 6.770367, 0.983381, 1.050078, -2.169461, -3.941941, -0.2811117, -1.193185, 2.528802, 6.574355, 0.4612021, -0.07554476, -2.981055, -3.300789, -1.441608, 3.646039}, {3.986224, 2.740437, -4.065297, -0.7474611, -0.01836047, -3.278482, 0.3857413, 4.685664, -0.6531413, -0.9416956, 0.6895335, -3.568116, -3.88157, -0.9981751, 0.3286032, 5.3392, 0.4776851, -4.429964, 4.455369, -0.9555197, -3.879034, 0.6770133, 2.339298, 2.572292, 4.553796, -1.315534, -0.9652743, 0.0750979, -1.758421, 0.07225199, -2.272367, 3.4753, 0.8961282, 2.826068, -1.832354, -0.4583802, 1.456926, -1.250956, -0.6205192, 5.968356, 1.799562, 2.317206, 1.829112, -3.320154, 1.486634, 2.268087, 2.200975, 5.376057, 2.727862, -2.205996, -2.87485, -3.609048, 0.563084, 2.556994, 0.9771296, -2.914879, 0.7274909, 1.401976, -0.1163725, 2.410114, -3.208306, 1.373852, -0.8083346, -0.60505, -1.024593, 0.5392958, -1.78802, -0.07366214, -1.201879, 5.279998, -1.894436, 2.104269, -2.103212, -1.468556, 1.129783, 0.7847288, 2.673771, 1.980956, -0.4780065, 1.609312, -4.878313, 0.4676363, -1.571547, 0.126937, 1.730308, 5.544688, 1.538685, -0.4115024, -1.737252, -3.096973, 1.629192, -2.055648, 1.68408, 3.04518, 0.178081, -0.3447178, -0.7304253, -1.379454, 0.4270972, 2.614602}, {2.793699, 7.622503, -4.660497, -3.948676, 0.2701604, -3.753833, -0.4425319, 13.42667, 0.6406477, -0.8262659, 2.675761, -4.763819, -13.56542, -2.757097, -1.550115, 6.506215, -2.447142, -13.67552, 28.14056, 0.519303, -10.99192, 1.975408, 6.475821, 1.339983, 15.42375, 55.23456, 1.492621, 2.966943, -0.09939972, -0.11852, -15.97767, 4.82566, -35.34433, 1.108843, -5.219376, -0.3212383, 1.202471, 1.08742, -0.2555819, 84.6428, 4.285394, 0.6926531, 1.922483, -6.56458, 2.814913, 2.556135, 2.841899, -47.55319, 3.705801, -2.578448, -2.540785, -9.364042, 0.5855801, 4.452853, 2.093399, -3.433465, -1.496094, 42.95851, -0.2583597, 3.72442, -8.459043, 1.493113, -3.788572, -3.3418, -13.7335, -1.076203, -1.305589, -2.050422, -40.20737, 15.12262, -0.1478691, 3.401549, -5.042671, -0.8576118, 2.120236, 0.4865088, 4.473651, 0.0566206, -2.38939, 3.287161, -13.09622, -0.1220056, 0.595493, 1.696253, 1.271522, 12.7237, 0.2455502, -1.95657, -1.643361, -10.87928, 0.04298243, -1.788123, 1.644463, 7.562836, -0.5328839, 0.9903111, 12.96856, -5.859347, -1.662378, 3.101759}, {3.382723, 3.493813, -0.1365268, 5.822044, 2.284215, 1.648481, 1.913679, 6.36202, 1.261664, 0.9107042, 0.7093813, -2.34876, -6.9132, 1.411155, 3.160777, 12.23432, 1.424152, -6.05433, 14.44658, 1.099506, -4.640552, -1.398788, 2.45153, 2.063766, 7.414336, 31.24858, 1.168788, 0.8713698, 1.093252, 0.9189707, -17.55914, 3.200715, -7.749667, 1.685354, -0.02844769, 12.4719, 1.101776, -0.5178554, 1.486991, 19.27882, 2.162505, 2.342911, 0.69337, 0.9489447, 0.7779703, 0.8873526, 1.604297, -19.84929, 1.816166, 1.005, 2.272119, -0.9345206, 0.3787552, 3.888147, 0.2930639, -1.188067, 0.6351073, 23.3936, 1.064942, 1.554477, -4.075995, -0.3763185, 0.8328371, 1.091036, -1.719453, 1.635852, 0.172161, 3.586581, -27.42064, 8.038473, 2.324507, 2.778735, -0.7743672, 0.7299844, 1.017407, 0.7123955, 2.895312, 0.7016122, 3.650473, 1.730128, -3.233771, 0.2779894, 0.1228348, 0.4975302, -0.2920457, 6.023657, 0.8348048, 1.834934, 0.3867797, -3.151733, -0.2559424, 0.8655474, 0.01845901, 3.86246, 1.295929, 1.538358, 17.02287, 1.030245, 3.303493, -0.4408159}, {5.11713, 6.058349, -3.342086, -3.018066, -1.271472, -2.840104, 0.6094103, 8.864309, -0.4018845, -0.9488258, 1.77639, -3.564531, -10.76531, -1.54383, -2.505391, 7.788655, -1.943871, -8.041384, 11.92494, -1.442265, -8.214111, 4.015705, 7.005883, 0.8255138, 6.97432, 3.389781, -1.189041, 3.152249, -1.129338, -1.103745, -15.71591, 2.585181, -11.76063, 2.121915, -5.2286, 2.396761, 2.166011, -1.482563, -1.16574, 35.01361, 1.749817, 3.820375, 2.643836, -4.588231, 3.080442, 3.311162, 4.338276, -12.61039, 5.179358, -5.121369, -1.878643, -6.089384, 1.996005, 4.798058, -1.709813, -3.689564, -0.271751, 9.673836, -2.192898, 4.456011, -6.523572, 1.804549, -2.958822, -3.99193, -8.50866, -1.575004, -0.5737193, -3.328092, -8.569592, 9.651597, 0.05419388, 4.232025, -5.549121, -2.260747, 2.794271, 1.108601, 5.530581, 0.2523378, -0.9450519, 3.382658, -9.461094, -1.60178, -1.429512, 2.43304, 0.568311, 9.430979, 0.799535, 0.4545601, -3.101347, -8.762598, 0.02553259, -4.500863, 1.442787, 4.585981, -0.3110943, 2.619152, 2.709402, -7.150436, -1.527965, 2.836808}, {2.147769, 2.897424, -0.1131809, 2.153954, 1.801512, -0.5132508, 1.937796, 5.643219, 2.326994, -0.3874764, 0.4816359, -0.8554713, -3.207163, 0.5235803, -0.6571176, -3.261026, 3.285111, -4.464391, 12.24506, 0.8830299, -1.863671, 2.545182, 0.895587, 2.728912, 5.569784, 30.81553, 2.196338, 1.134207, 0.5785025, 2.304837, -8.885468, 2.596961, -7.663393, 2.512415, -0.1202429, 23.31728, 0.05030406, 0.672072, 0.9730315, 3.272611, 3.142854, 1.677645, 1.718661, 0.3928948, 0.001886988, 2.481252, 4.336162, -4.221834, 3.452577, 2.385324, -0.2883706, -2.666954, -0.4916309, 5.247405, 1.539545, -2.400874, -0.4409809, 24.56683, -0.307725, 2.913814, -1.935181, 0.04645559, 0.650591, -0.2381964, 0.6709288, -1.783981, 0.4670951, 1.639326, -6.920802, 6.466471, 2.266229, 4.957048, 0.8161193, 7.483184E-4, 2.753275, 0.8753385, 2.797968, 1.01223, 0.7067858, 1.980497, -2.780553, 1.27483, 2.090197, 0.7289414, 1.145766, 4.867256, -0.6751814, 2.531027, -0.5300686, -1.213717, -1.166065, 0.4154928, 1.283466, 5.233963, 2.092253, 0.5535932, 8.429589, -1.043357, 2.436384, 0.4639569}, {0.3082067, -0.9801579, 2.239483, 0.03099812, -0.3924983, 2.385817, 1.827991, -0.501362, -0.5659168, -0.03076079, -1.026257, -1.071697, 1.101676, 0.03952565, 0.3712403, -1.311231, -0.3541783, 1.144234, -0.08978659, -0.8659158, -0.2812429, -1.175849, -1.317094, 1.020091, -0.8197817, 0.5467497, -1.967725, 0.9889849, 0.2665662, 0.4975046, 0.1632433, 2.407735, 1.073026, -0.1793302, -0.4211858, 1.085389, -0.4691859, 0.2947169, -0.307716, 1.03027, 0.192543, 0.7417465, 0.195422, 1.733651, 0.1947799, 1.386866, -0.178702, -0.3184311, 0.2459541, 1.484355, 1.150561, -2.067786, 1.43703, 1.28035, 0.5490345, -0.883474, -1.9992, -1.47157, 0.536315, 0.03912594, 0.5857609, -1.246479, -0.1329826, 2.392338, -0.2689821, -1.205691, -2.112616, -1.402535, 0.1160252, -2.030774, -1.544992, -0.9701426, 0.5339326, -0.6303475, -0.2736332, -1.594521, -0.1179365, 0.7449095, -0.571976, 0.5902363, 0.2200573, -0.5336633, -1.020168, -0.3940564, 0.05607218, -1.566568, -0.3599421, 0.7684572, -0.1875955, 0.7851294, -1.226189, -0.1852845, 0.9392875, 0.9886471, 0.8400441, -1.657109, 0.82925, 0.6291445, 1.855838, 0.7817575}};
    private static final double[][] nodes_output_weights_run46 = new double[][]{{-6.498447}, {-11.18659}, {7.141798}, {11.83873}, {1.074817}, {6.018702}, {-1.659096}, {-12.94222}, {1.108248}, {2.588811}, {-3.945664}, {7.842213}, {17.51283}, {5.781366}, {6.755374}, {103.1202}, {10.54735}, {17.55498}, {-33.44264}, {5.427427}, {15.79636}, {-5.690646}, {-12.18132}, {-3.819303}, {-14.05099}, {-102.4496}, {3.808777}, {-2.790082}, {3.091351}, {7.491806}, {-103.8401}, {-6.768819}, {81.26829}, {-4.358685}, {11.58635}, {56.6619}, {-2.149229}, {1.987789}, {2.270336}, {229.5486}, {-3.967822}, {-4.168178}, {-5.674131}, {13.22929}, {-5.542926}, {-4.399619}, {-5.841908}, {140.7293}, {-6.590737}, {8.866014}, {4.868539}, {14.97621}, {-3.066182}, {-7.876665}, {0.4323621}, {4.690368}, {2.08655}, {-70.48853}, {1.185709}, {-8.954231}, {13.22306}, {-4.733339}, {7.853796}, {9.012911}, {24.64163}, {5.141197}, {3.237874}, {9.671219}, {179.5104}, {-14.61349}, {5.070764}, {-5.087717}, {11.3719}, {5.909729}, {-4.362403}, {-3.661368}, {-6.275244}, {-1.339217}, {6.661096}, {-4.852365}, {17.0525}, {1.975917}, {1.271128}, {-3.967096}, {1.674895}, {-13.74497}, {-1.476553}, {2.474969}, {4.930406}, {17.64274}, {-0.6230274}, {6.893806}, {-4.209852}, {-8.861739}, {-0.5257071}, {-2.555179}, {-108.1074}, {11.1423}, {9.943105}, {-4.742949}, {2.818717}};
    private static final double[][] nodes_output_scale_run46 = new double[][]{{-1.3, 3.75}};
    private static final double[] nodes_output_scale_off_run46 = new double[]{0.1};
    private static final int[] nodes_output_scale_flag_run46 = new int[]{0};
    private static final double[][] nodes_output_scale_limits_run46 = new double[][]{{-1.3, 1.7}};

    public static int compute(float[][] in, int getNumNodesInput, float[][] out, int getNumNodesOutput, int width, int[] mask, int errmask, float[] a) {
        int x;
        int nodes_input = 18;
        boolean nodes_output = true;
        boolean nodes_input_bias = true;
        boolean nodes_input_pca = true;
        int nodes_hidden = 100;
        boolean nodes_hidden_bias = true;
        double nodes_hidden_temperature = 1.0;
        double t_input = 0.05555555555555555;
        double t_hidden = 0.01;
        if (getNumNodesInput <= 0) {
            return 18;
        }
        if (getNumNodesOutput <= 0) {
            return 1;
        }
        if (getNumNodesInput != 18) {
            return -1;
        }
        if (getNumNodesOutput != 1) {
            return -2;
        }
        double[] vt = new double[19];
        double[] vt1 = new double[101];
        int[] rcheck = new int[width];
        for (x = 0; x < width; ++x) {
            rcheck[x] = 0;
            if (a[x] < 0.0f) {
                rcheck[x] = 1;
            }
            a[x] = 1.0f;
        }
        for (x = 0; x < width; ++x) {
            int j;
            int i;
            if (mask[x] != 0) continue;
            if (rcheck[x] != 0) {
                for (i = 0; i < 18 && a[x] > 0.0f; ++i) {
                    if (!(in[i][x] < (float)NN_General.NODES_INPUT_SCALE_LIMITS[i][0]) && !(in[i][x] > (float)NN_General.NODES_INPUT_SCALE_LIMITS[i][1])) continue;
                    int n = x;
                    a[n] = a[n] - 3.0f;
                }
                if (a[x] < 0.0f) {
                    int n = x;
                    mask[n] = mask[n] | errmask;
                }
            }
            for (i = 0; i < 18; ++i) {
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] == -1) {
                    in[i][x] = (float)Math.log(in[i][x]);
                }
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] != -2) continue;
                in[i][x] = (float)Math.exp(in[i][x]);
            }
            for (i = 0; i < 18; ++i) {
                in[i][x] = (float)NN_General.NODES_INPUT_SCALE_OFF[i] + (in[i][x] - (float)nodes_input_scale_run46[i][0]) / (float)nodes_input_scale_run46[i][1];
            }
            for (i = 0; i < 18; ++i) {
                vt[i] = in[i][x];
                if (NN_General.NODES_INPUT_SCALE_FLAG[i] != 1) continue;
                vt[i] = 0.0;
                for (j = 0; j < 18; ++j) {
                    if (NN_General.NODES_INPUT_SCALE_FLAG[j] != 1) continue;
                    int n = i;
                    vt[n] = vt[n] + (double)in[j][x] * nodes_input_pca_evec_run46[j][i];
                }
            }
            for (i = 0; i < 18; ++i) {
                in[i][x] = (float)vt[i];
            }
            for (i = 0; i < 18; ++i) {
                vt[i] = in[i][x];
            }
            for (i = 18; i < 19; ++i) {
                vt[i] = 1.0;
            }
            for (i = 0; i < 100; ++i) {
                vt1[i] = 0.0;
                for (j = 0; j < 19; ++j) {
                    int n = i;
                    vt1[n] = vt1[n] + vt[j] * nodes_hidden_weights_run46[j][i];
                }
            }
            for (i = 0; i < 100; ++i) {
                vt1[i] = 1.0 / (1.0 + Math.exp(-0.05555555555555555 * vt1[i]));
            }
            for (i = 100; i < 101; ++i) {
                vt1[i] = 1.0;
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = 0.0f;
                for (j = 0; j < 101; ++j) {
                    float[] fArray = out[i];
                    int n = x;
                    fArray[n] = fArray[n] + (float)(vt1[j] * nodes_output_weights_run46[j][i]);
                }
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = (float)(1.0 / (1.0 + Math.exp(-0.01 * (double)out[i][x])));
            }
            for (i = 0; i < 1; ++i) {
                out[i][x] = (float)nodes_output_scale_run46[i][0] + (out[i][x] - (float)nodes_output_scale_off_run46[i]) * (float)nodes_output_scale_run46[i][1];
            }
            for (i = 0; i < 1; ++i) {
                if (nodes_output_scale_flag_run46[i] == -1) {
                    out[i][x] = (float)Math.log(out[i][x]);
                }
                if (nodes_output_scale_flag_run46[i] != -2) continue;
                out[i][x] = (float)Math.exp(out[i][x]);
            }
            if (rcheck[x] == 0) continue;
            for (i = 0; i < 1 && a[x] >= -2.0f; ++i) {
                if (!(out[i][x] < (float)nodes_output_scale_limits_run46[i][0]) && !(out[i][x] > (float)nodes_output_scale_limits_run46[i][1])) continue;
                int n = x;
                a[n] = a[n] - 20.0f;
            }
            if (!(a[x] < 0.0f)) continue;
            int n = x;
            mask[n] = mask[n] | errmask;
        }
        return 0;
    }
}

