/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.AbstractButtonAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.product.ProductExpressionPane;

class WaterVariablesPanel
extends JPanel {
    private final AppContext appContext;
    private BindingContext bindingContext;

    WaterVariablesPanel(AppContext appContext, BindingContext bindingContext) {
        this.appContext = appContext;
        this.bindingContext = bindingContext;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createCheckBoxComponent("computeCHL"), (GridBagConstraints)gbc, (String)"insets=5,fill=HORIZONTAL,weightx=1.0,weighty=1.0,gridy=0");
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createCheckBoxComponent("computeTSM"), (GridBagConstraints)gbc, (String)"gridy=1");
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createCheckBoxComponent("computeYS"), (GridBagConstraints)gbc, (String)"gridy=2");
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createCheckBoxComponent("computeAtmCorr"), (GridBagConstraints)gbc, (String)"gridy=3");
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createCheckBoxComponent("checkWhetherSuspectIsValid"), (GridBagConstraints)gbc, (String)"gridy=4");
        GridBagUtils.addToPanel((JPanel)this, (Component)this.createValidExpressionPanel(), (GridBagConstraints)gbc, (String)"gridy=5,fill=HORIZONTAL,weightx=1.0,weighty=0.0");
        GridBagUtils.addVerticalFiller((JPanel)this, (GridBagConstraints)gbc);
    }

    private JCheckBox createCheckBoxComponent(String propertyName) {
        Property property = this.bindingContext.getPropertySet().getProperty(propertyName);
        JCheckBox checkBox = new JCheckBox(property.getDescriptor().getDisplayName());
        checkBox.setSelected((Boolean)property.getDescriptor().getDefaultValue());
        AbstractButtonAdapter adapter = new AbstractButtonAdapter((AbstractButton)checkBox);
        this.bindingContext.bind(property.getDescriptor().getName(), (ComponentAdapter)adapter);
        return checkBox;
    }

    private JPanel createValidExpressionPanel() {
        final JButton button = new JButton("...");
        Dimension preferredSize = button.getPreferredSize();
        preferredSize.setSize(25.0, preferredSize.getHeight());
        button.setPreferredSize(preferredSize);
        button.setEnabled(this.hasSourceProducts());
        this.bindingContext.getPropertySet().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals("sourceProduct")) {
                    return;
                }
                button.setEnabled(WaterVariablesPanel.this.hasSourceProducts());
            }
        });
        Property property = this.bindingContext.getPropertySet().getProperty("expression");
        final JTextField textField = new JTextField();
        textField.setDropTarget(null);
        textField.setText(property.getDescriptor().getDefaultValue().toString());
        this.bindingContext.bind(property.getDescriptor().getName(), textField);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String expression = WaterVariablesPanel.this.editExpression(textField.getText());
                if (expression != null) {
                    textField.setText(expression);
                    try {
                        WaterVariablesPanel.this.bindingContext.getPropertySet().getProperty("expression").setValue((Object)expression);
                    }
                    catch (ValidationException e) {
                        WaterVariablesPanel.this.appContext.handleError("Invalid expression", (Throwable)e);
                    }
                }
            }
        });
        JPanel validExpressionPanel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        GridBagUtils.addToPanel((JPanel)validExpressionPanel, (Component)new JLabel("Valid expression:"), (GridBagConstraints)gbc, (String)"anchor=NORTHWEST,insets=3,insets.top=6");
        GridBagUtils.addToPanel((JPanel)validExpressionPanel, (Component)textField, (GridBagConstraints)gbc, (String)"gridx=1,weightx=1,fill=HORIZONTAL,insets.top=3,insets.left=24");
        GridBagUtils.addToPanel((JPanel)validExpressionPanel, (Component)button, (GridBagConstraints)gbc, (String)"gridx=2,weightx=0,fill=NONE,insets.top=2,insets.left=3");
        return validExpressionPanel;
    }

    private boolean hasSourceProducts() {
        return this.getSourceProducts().length > 0;
    }

    public Product[] getSourceProducts() {
        Property property = this.bindingContext.getPropertySet().getProperty("sourceProduct");
        if (property == null) {
            return new Product[0];
        }
        return (Product[])property.getValue();
    }

    private String editExpression(String expression) {
        Product product = this.getSourceProducts()[0];
        if (product == null) {
            return null;
        }
        ProductExpressionPane expressionPane = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{product}, (Product)product, (PropertyMap)this.appContext.getPreferences());
        expressionPane.setCode(expression);
        int i = expressionPane.showModalDialog(this.appContext.getApplicationWindow(), "Expression Editor");
        if (i == 1) {
            return expressionPane.getCode();
        }
        return null;
    }
}

