/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fub.wew.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.esa.s3tbx.fub.wew.ui.WaterVariablesPanel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.internal.RasterDataNodeValues;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.AppContext;

class WaterProcessorDialog
extends SingleTargetProductDialog {
    private final String operatorName;
    private final OperatorSpi operatorSpi;
    private DefaultIOParametersPanel ioParametersPanel;
    private final OperatorParameterSupport parameterSupport;
    private final BindingContext bindingContext;
    private JTabbedPane form;
    private PropertyDescriptor[] rasterDataNodeTypeProperties;
    private String targetProductNameSuffix;
    private ProductChangedHandler productChangedHandler;

    public WaterProcessorDialog(String operatorName, AppContext appContext, String title, String helpID) {
        super(appContext, title, 24, helpID);
        this.operatorName = operatorName;
        this.targetProductNameSuffix = "";
        this.operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (this.operatorSpi == null) {
            throw new IllegalArgumentException("operatorName");
        }
        OperatorDescriptor operatorDescriptor = this.operatorSpi.getOperatorDescriptor();
        this.ioParametersPanel = new DefaultIOParametersPanel(this.getAppContext(), operatorDescriptor, this.getTargetProductSelector());
        this.parameterSupport = new OperatorParameterSupport(operatorDescriptor);
        ArrayList sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        PropertySet propertyContainer = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertyContainer);
        if (propertyContainer.getProperties().length > 0 && !sourceProductSelectorList.isEmpty()) {
            Property[] properties = propertyContainer.getProperties();
            ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
            for (Property property : properties) {
                PropertyDescriptor parameterDescriptor = property.getDescriptor();
                if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                rdnTypeProperties.add(parameterDescriptor);
            }
            this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
        }
        this.productChangedHandler = new ProductChangedHandler();
        if (!sourceProductSelectorList.isEmpty()) {
            ((SourceProductSelector)sourceProductSelectorList.get(0)).addSelectionChangeListener((SelectionChangeListener)this.productChangedHandler);
        }
    }

    public int show() {
        this.ioParametersPanel.initSourceProductSelectors();
        if (this.form == null) {
            this.initForm();
            if (this.getJDialog().getJMenuBar() == null) {
                OperatorMenu operatorMenu = this.createDefaultMenuBar();
                this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
            }
        }
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.productChangedHandler.releaseProduct();
        this.ioParametersPanel.releaseSourceProductSelectors();
        super.hide();
    }

    protected Product createTargetProduct() throws Exception {
        HashMap sourceProducts = this.ioParametersPanel.createSourceProductsMap();
        return GPF.createProduct((String)this.operatorName, (Map)this.parameterSupport.getParameterMap(), (Map)sourceProducts);
    }

    public String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    private void initForm() {
        this.form = new JTabbedPane();
        this.form.add("I/O Parameters", (Component)this.ioParametersPanel);
        if (this.bindingContext.getPropertySet().getProperties().length > 0) {
            WaterVariablesPanel waterVariablesPanel = new WaterVariablesPanel(this.getAppContext(), this.bindingContext);
            this.form.add("Processing Parameters", new JScrollPane(waterVariablesPanel));
        }
    }

    private OperatorMenu createDefaultMenuBar() {
        return new OperatorMenu((Component)this.getJDialog(), this.operatorSpi.getOperatorDescriptor(), this.parameterSupport, this.getAppContext(), this.getHelpID());
    }

    private static void updateValueSet(PropertyDescriptor propertyDescriptor, Product product) {
        Object object;
        Object[] values = new String[]{};
        if (product != null && (object = propertyDescriptor.getAttribute("rasterDataNodeType")) != null) {
            Class rasterDataNodeType = (Class)object;
            boolean includeEmptyValue = !propertyDescriptor.isNotNull() && !propertyDescriptor.isNotEmpty() && !propertyDescriptor.getType().isArray();
            values = RasterDataNodeValues.getNames((Product)product, (Class)rasterDataNodeType, (boolean)includeEmptyValue);
        }
        propertyDescriptor.setValueSet(new ValueSet(values));
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    private class ProductChangedHandler
    extends AbstractSelectionChangeListener
    implements ProductNodeListener {
        private Product currentProduct;

        private ProductChangedHandler() {
        }

        public void releaseProduct() {
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                this.currentProduct = null;
            }
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Selection selection = event.getSelection();
            if (selection.equals(Selection.EMPTY)) {
                if (this.currentProduct != null) {
                    this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                    this.currentProduct = null;
                }
                this.updateTargetProductName();
                this.updateValueSets(this.currentProduct);
                this.setSourceProductProperty(new Product[0]);
            } else {
                Product selectedProduct = (Product)selection.getSelectedValue();
                if (selectedProduct != this.currentProduct) {
                    if (this.currentProduct != null) {
                        this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                    }
                    this.currentProduct = selectedProduct;
                    if (this.currentProduct != null) {
                        this.currentProduct.addProductNodeListener((ProductNodeListener)this);
                    }
                    this.updateTargetProductName();
                    this.updateValueSets(this.currentProduct);
                    this.setSourceProductProperty(new Product[]{selectedProduct});
                }
            }
        }

        private void setSourceProductProperty(Product[] products) {
            try {
                if (!WaterProcessorDialog.this.bindingContext.getPropertySet().isPropertyDefined("sourceProduct")) {
                    PropertyDescriptor descriptor = new PropertyDescriptor("sourceProduct", Product[].class);
                    descriptor.setTransient(true);
                    Property property = new Property(descriptor, (PropertyAccessor)new DefaultPropertyAccessor());
                    WaterProcessorDialog.this.bindingContext.getPropertySet().addProperty(property);
                }
                WaterProcessorDialog.this.bindingContext.getPropertySet().getProperty("sourceProduct").setValue((Object)products);
            }
            catch (ValidationException e) {
                String msg = String.format("Cannot display source product.\n%s", e.getMessage());
                WaterProcessorDialog.this.getAppContext().handleError(msg, (Throwable)e);
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleProductNodeEvent(event);
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent(event);
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent(event);
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleProductNodeEvent(event);
        }

        private void updateTargetProductName() {
            String productName = "";
            if (this.currentProduct != null) {
                productName = this.currentProduct.getName();
            }
            TargetProductSelectorModel targetProductSelectorModel = WaterProcessorDialog.this.getTargetProductSelector().getModel();
            targetProductSelectorModel.setProductName(productName + WaterProcessorDialog.this.getTargetProductNameSuffix());
        }

        private void handleProductNodeEvent(ProductNodeEvent event) {
            this.updateValueSets(this.currentProduct);
        }

        private void updateValueSets(Product product) {
            if (WaterProcessorDialog.this.rasterDataNodeTypeProperties != null) {
                for (PropertyDescriptor propertyDescriptor : WaterProcessorDialog.this.rasterDataNodeTypeProperties) {
                    WaterProcessorDialog.updateValueSet(propertyDescriptor, product);
                }
            }
        }
    }
}

