/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class InstrumentTest {
    @Test
    public void testDefaultReflectancesSelector_MERIS() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        InstrumentTest.addBand(product, "a", 412.0f);
        InstrumentTest.addBand(product, "a1", 422.0f);
        InstrumentTest.addBand(product, "a2", 430.0f);
        InstrumentTest.addBand(product, "b", 443.0f);
        InstrumentTest.addBand(product, "c", 490.0f);
        InstrumentTest.addBand(product, "d", 510.0f);
        InstrumentTest.addBand(product, "e", 560.0f);
        InstrumentTest.addBand(product, "e1", 570.0f);
        InstrumentTest.addBand(product, "f", 620.0f);
        InstrumentTest.addBand(product, "g", 665.0f);
        InstrumentTest.addBand(product, "h", 680.0f);
        InstrumentTest.addBand(product, "i", 708.0f);
        InstrumentTest.addBand(product, "j0", 799.0f);
        Instrument.DefaultReflectancesSelector selector = new Instrument.DefaultReflectancesSelector(new double[]{412.691, 442.55902, 489.88202, 509.81903, 559.69403, 619.601, 664.57306, 680.82104, 708.32904}, new String[0]);
        Object[] reflecBands = selector.select(product, null);
        Object[] expecteds = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])reflecBands);
    }

    private static void addBand(Product product, String bandName, float wavelength) {
        Band band = new Band(bandName, 31, 10, 10);
        band.setSpectralWavelength(wavelength);
        product.addBand(band);
    }
}

