/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import org.esa.s3tbx.fu.DetectInstrument;
import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class DetectInstrumentTest {
    @Test
    public void testMERIS() {
        Product product = new Product("dummy", "dummy-mer_r", 2, 2);
        product.setProductType("MER_RR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_FRS_2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_RR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_FR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testOLCI() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("Oa01_reflectance", 10);
        product.addBand("Oa02_reflectance", 10);
        product.addBand("Oa03_reflectance", 10);
        product.addBand("Oa04_reflectance", 10);
        product.addBand("Oa05_reflectance", 10);
        product.addBand("Oa06_reflectance", 10);
        product.addBand("Oa07_reflectance", 10);
        Assert.assertEquals((Object)Instrument.OLCI, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testS2MSI() {
        Product product = new Product("dummy", "S2_MSI_Level-1C", 2, 2);
        Assert.assertEquals((Object)Instrument.S2_MSI, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testMODIS1KM() {
        Product product = new Product("dummy", "dummy-modis1km", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement globalAttributes = new MetadataElement("Global_Attributes");
        globalAttributes.setAttributeString("title", "HMODISA Level-2 Data");
        globalAttributes.setAttributeString("spatialResolution", "1 km");
        root.addElement(globalAttributes);
        Assert.assertEquals((Object)Instrument.MODIS, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testMODIS500() {
        Product product = new Product("dummy", "dummy-modis500", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement mph = new MetadataElement("MPH");
        mph.setAttributeString("identifier_product_doi", "10.5067/MODIS/MOD09A1.006");
        root.addElement(mph);
        Assert.assertEquals((Object)Instrument.MODIS500, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testSEAWIFS() {
        Product product = new Product("dummy", "dummy-seawifs", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement dsd23 = new MetadataElement("Global_Attributes");
        dsd23.setAttributeString("Title", "SeaWiFS Level-2 Data");
        root.addElement(dsd23);
        Assert.assertEquals((Object)Instrument.SEAWIFS, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testCZCS() {
        Product product = new Product("dummy", "dummy-czcs", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement dsd23 = new MetadataElement("Global_Attributes");
        dsd23.setAttributeString("Title", "CZCS Level-2 Data");
        root.addElement(dsd23);
        Assert.assertEquals((Object)Instrument.CZCS, (Object)DetectInstrument.getInstrument((Product)product));
    }
}

