/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import java.awt.Color;
import java.util.Arrays;
import org.esa.s3tbx.fu.BandDefinition;
import org.esa.s3tbx.fu.DetectInstrument;
import org.esa.s3tbx.fu.FuAlgo;
import org.esa.s3tbx.fu.FuResult;
import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;

@OperatorMetadata(alias="FuClassification", version="1.1", category="Optical/Thematic Water Processing", description="Colour classification based on the discrete Forel-Ule scale.", authors=" H.J van der Woerd (IVM), M.R. Wernand (NIOZ), Muhammad Bala (BC), Marco Peters (BC)", copyright="(c) 2016 by Brockmann Consult GmbH")
public class FuOp
extends PixelOperator {
    static Color[] FU_COLORS = new Color[]{new Color(0, 0, 0), new Color(33, 88, 188), new Color(49, 109, 197), new Color(50, 124, 187), new Color(75, 128, 160), new Color(86, 143, 150), new Color(109, 146, 152), new Color(105, 140, 134), new Color(117, 158, 114), new Color(123, 166, 84), new Color(125, 174, 56), new Color(149, 182, 69), new Color(148, 182, 96), new Color(165, 188, 118), new Color(170, 184, 109), new Color(173, 181, 95), new Color(168, 169, 101), new Color(174, 159, 92), new Color(179, 160, 83), new Color(175, 138, 68), new Color(164, 105, 5), new Color(161, 77, 4)};
    private String[] reflecBandNames;
    @SourceProduct(alias="source", label="Reflectance", description="The source product providing reflectances.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(defaultValue="false", description="Weather or not to copy all the bands to the target product from the source product.")
    private boolean copyAllSourceBands;
    @Parameter(label="Input is irradiance reflectance", defaultValue="false", description="If enabled, the source reflectances will be converted to radiance reflectances by dividing it by PI before passing to the algorithm.")
    private boolean inputIsIrradianceReflectance;
    @Parameter(label="Valid pixel expression", description="An expression to filter which pixel are considered.", converter=BooleanExpressionConverter.class)
    private String validExpression;
    @Parameter(label="Reflectance band name pattern", description="The used reflectance band names must match the given pattern. Useful, if there is more then one spectrum in the product.")
    private String reflectanceNamePattern;
    @Parameter(defaultValue="AUTO_DETECT", description="The instrument to compute FU for.")
    private Instrument instrument;
    @Parameter(label="Include intermediate results in output", defaultValue="true", description="Whether or not the intermediate results shall be written to the target output")
    private boolean includeIntermediateResults;
    private FuAlgo fuAlgo;
    private boolean autoDetectedInstrument = false;
    private BandDefinition[] targetBandDefs;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        boolean isValid = true;
        for (Sample sourceSample : sourceSamples) {
            if (sourceSample.getNode().isPixelValid(x, y)) continue;
            isValid = false;
            break;
        }
        if (isValid) {
            RasterDataNode[] sourceNodes = (RasterDataNode[])Arrays.stream(sourceSamples).map(Sample::getNode).toArray(RasterDataNode[]::new);
            double[] spectrum = this.getInputSpectrum(sourceSamples);
            spectrum = this.instrument.preProcess(this.sourceProduct, sourceNodes, spectrum);
            spectrum = this.applyPiToIrradianceSpectrum(spectrum);
            FuResult result = this.fuAlgo.compute(spectrum);
            for (int i = 0; i < this.targetBandDefs.length; ++i) {
                BandDefinition targetBandDef = this.targetBandDefs[i];
                targetBandDef.setTargetSample(result, targetSamples[i]);
            }
        } else {
            for (int i = 0; i < targetSamples.length; ++i) {
                this.targetBandDefs[i].setNoDataValue(targetSamples[i]);
            }
        }
    }

    private double[] getInputSpectrum(Sample[] sourceSamples) {
        return Arrays.stream(sourceSamples).mapToDouble(Sample::getDouble).toArray();
    }

    private double[] applyPiToIrradianceSpectrum(double[] spectrum) {
        if (this.autoDetectedInstrument && this.instrument.isIrradiance() || this.inputIsIrradianceReflectance) {
            return Arrays.stream(spectrum).map(v -> v / Math.PI).toArray();
        }
        return spectrum;
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        Product sourceProduct = this.getSourceProduct();
        if (this.instrument == Instrument.AUTO_DETECT) {
            this.instrument = DetectInstrument.getInstrument(sourceProduct);
            if (this.instrument == null) {
                throw new OperatorException("The instrument can not be automatically detected, please select the instrument in the processing parameter.");
            }
            this.autoDetectedInstrument = true;
        }
        this.fuAlgo = new FuAlgo(this.instrument);
        this.reflecBandNames = this.instrument.getReflectanceBandNames(sourceProduct, this.reflectanceNamePattern);
        this.targetBandDefs = BandDefinition.create(this.includeIntermediateResults, this.instrument);
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        this.targetProduct = productConfigurer.getTargetProduct();
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.copyAllSourceBands) {
            for (Band band : this.sourceProduct.getBands()) {
                if (this.targetProduct.containsBand(band.getName())) continue;
                ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
            this.targetProduct.setAutoGrouping(this.sourceProduct.getAutoGrouping());
        }
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        for (BandDefinition bandDefinition : this.targetBandDefs) {
            bandDefinition.addToProduct(this.targetProduct);
        }
        Band band = this.targetProduct.getBand(this.targetBandDefs[this.targetBandDefs.length - 1].name);
        FuOp.attachIndexCoding(band);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sourceSampleConfigurer) throws OperatorException {
        for (int i = 0; i < this.reflecBandNames.length; ++i) {
            sourceSampleConfigurer.defineSample(i, this.reflecBandNames[i]);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)this.validExpression)) {
            sourceSampleConfigurer.setValidPixelMask(this.validExpression);
        } else {
            String[] validExpressions;
            for (String expression : validExpressions = this.instrument.getValidExpressions()) {
                boolean isCompatible = this.sourceProduct.isCompatibleBandArithmeticExpression(expression);
                if (!isCompatible) continue;
                sourceSampleConfigurer.setValidPixelMask(expression);
            }
        }
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        for (int i = 0; i < this.targetBandDefs.length; ++i) {
            BandDefinition targetBandDef = this.targetBandDefs[i];
            sampleConfigurer.defineSample(i, targetBandDef.name);
        }
    }

    static void attachIndexCoding(Band fuBand) {
        IndexCoding indexCoding = new IndexCoding("Forel-Ule Scale");
        ImageInfo imageInfo = FuOp.createImageInfo(indexCoding);
        fuBand.setImageInfo(imageInfo);
        fuBand.getProduct().getIndexCodingGroup().add((ProductNode)indexCoding);
        fuBand.setSampleCoding((SampleCoding)indexCoding);
    }

    static ImageInfo createImageInfo(IndexCoding indexCoding) {
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[22];
        for (int i = 0; i < points.length; ++i) {
            String name = i != 0 ? String.format("FU_%2d", i) : "undefined";
            indexCoding.addIndex(name, i, "");
            points[i] = new ColorPaletteDef.Point((double)i, FU_COLORS[i], name);
        }
        return new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FuOp.class);
        }
    }
}

