/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;

class DetectInstrument {
    private static final String GLOBAL_ATTRIBUTES = "Global_Attributes";
    private static final String SEAWIFS_TITLE = "SeaWiFS Level-2 Data";
    private static final String CZCS_TITLE = "CZCS Level-2 Data";
    private static final String MODIS_TITLE_VALUE = "HMODISA Level-2 Data";
    private static final String MODIS_1KM_RESOLUTION_VALUE = "1 km";
    private static final String OLCI_PRODUCT_TYPE_START = "OL_2";
    private static final String OLCI_L2_BANDNAME_PATTERN = "Oa\\d+_reflectance";
    private static final String MERIS_L2_TYPE_PATTER = "MER_..._2P";

    DetectInstrument() {
    }

    static Instrument getInstrument(Product product) {
        if (DetectInstrument.meris(product)) {
            return Instrument.MERIS;
        }
        if (DetectInstrument.modis1km(product)) {
            return Instrument.MODIS;
        }
        if (DetectInstrument.modis500m(product)) {
            return Instrument.MODIS500;
        }
        if (DetectInstrument.s2msi(product)) {
            return Instrument.S2_MSI;
        }
        if (DetectInstrument.olci(product)) {
            return Instrument.OLCI;
        }
        if (DetectInstrument.seawifs(product)) {
            return Instrument.SEAWIFS;
        }
        if (DetectInstrument.czcs(product)) {
            return Instrument.CZCS;
        }
        return null;
    }

    private static boolean meris(Product product) {
        Pattern compile = Pattern.compile(MERIS_L2_TYPE_PATTER);
        return compile.matcher(product.getProductType()).matches();
    }

    private static boolean modis1km(Product product) {
        MetadataElement globalAttributes = product.getMetadataRoot().getElement(GLOBAL_ATTRIBUTES);
        return globalAttributes != null && DetectInstrument.isModis(globalAttributes) && DetectInstrument.hasModisResultion(globalAttributes, MODIS_1KM_RESOLUTION_VALUE);
    }

    private static boolean modis500m(Product product) {
        MetadataElement mph = product.getMetadataRoot().getElement("MPH");
        if (mph != null && mph.containsAttribute("identifier_product_doi")) {
            String identDoi = mph.getAttributeString("identifier_product_doi");
            return Pattern.matches(".*/MODIS/M[O|Y]D09A1.006", identDoi);
        }
        return false;
    }

    private static boolean hasModisResultion(MetadataElement globalAttributes, String modis500mResolutionValue) {
        String sensor_name;
        return globalAttributes.containsAttribute("spatialResolution") && (sensor_name = globalAttributes.getAttributeString("spatialResolution")).contains(modis500mResolutionValue);
    }

    private static boolean isModis(MetadataElement globalAttributes) {
        String sensor_name;
        String attribName = "title";
        return globalAttributes != null && globalAttributes.containsAttribute(attribName) && (sensor_name = globalAttributes.getAttributeString(attribName)).contains(MODIS_TITLE_VALUE);
    }

    private static boolean olci(Product product) {
        boolean isOLCI = false;
        List collect = Stream.of(product.getBands()).filter(p -> p.getName().matches(OLCI_L2_BANDNAME_PATTERN)).collect(Collectors.toList());
        boolean checkByType = product.getProductType().contains(OLCI_PRODUCT_TYPE_START);
        if (collect.size() > 0 || checkByType) {
            isOLCI = true;
        }
        return isOLCI;
    }

    private static boolean s2msi(Product product) {
        return product.getProductType().equals("S2_MSI_Level-1C");
    }

    private static boolean seawifs(Product product) {
        String title;
        MetadataElement globalAttributes = product.getMetadataRoot().getElement(GLOBAL_ATTRIBUTES);
        String attribName = "Title";
        return globalAttributes != null && globalAttributes.containsAttribute(attribName) && (title = globalAttributes.getAttributeString(attribName)).equals(SEAWIFS_TITLE);
    }

    private static boolean czcs(Product product) {
        String title;
        MetadataElement globalAttributes = product.getMetadataRoot().getElement(GLOBAL_ATTRIBUTES);
        return globalAttributes != null && globalAttributes.containsAttribute("Title") && (title = globalAttributes.getAttributeString("Title")).equals(CZCS_TITLE);
    }
}

