/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import org.esa.s3tbx.fu.FuAlgo;
import org.esa.s3tbx.fu.FuAlgoFactory;
import org.esa.s3tbx.fu.FuResult;
import org.esa.s3tbx.fu.Instrument;
import org.junit.Assert;
import org.junit.Test;

public class FulAlgoTest {
    @Test
    public void testComputeMeris() {
        FuAlgoFactory factory = new FuAlgoFactory(Instrument.MERIS);
        FuAlgo fuAlgo = factory.create();
        FuResult result = fuAlgo.compute(new double[]{0.00981, 0.011, 0.01296, 0.01311, 0.01193, 0.00298, 0.0016, 0.0014, 8.1E-4});
        Assert.assertEquals((double)0.7982, (double)result.getX3(), (double)1.0E-4);
        Assert.assertEquals((double)1.057, (double)result.getY3(), (double)1.0E-4);
        Assert.assertEquals((double)1.2087, (double)result.getZ3(), (double)1.0E-4);
        Assert.assertEquals((double)0.26052, (double)result.getChrX(), (double)1.0E-4);
        Assert.assertEquals((double)0.34499, (double)result.getChrY(), (double)1.0E-4);
        Assert.assertEquals((double)170.9056, (double)result.getHue(), (double)1.0E-4);
        Assert.assertEquals((double)171.0255, (double)result.getHueAngle(), (double)1.0E-4);
        Assert.assertEquals((long)5L, (long)result.getFuValue());
    }

    @Test
    public void testComputeModis() {
        FuAlgoFactory factory = new FuAlgoFactory(Instrument.MODIS);
        FuAlgo fuAlgo = factory.create();
        FuResult result = fuAlgo.compute(new double[]{0.00242, 0.0031, 0.00345, 0.0039, 0.00358, 5.9E-4, 6.3E-4});
        Assert.assertEquals((double)0.2668, (double)result.getX3(), (double)1.0E-4);
        Assert.assertEquals((double)0.3279, (double)result.getY3(), (double)1.0E-4);
        Assert.assertEquals((double)0.3303, (double)result.getZ3(), (double)1.0E-4);
        Assert.assertEquals((double)0.28842, (double)result.getChrX(), (double)1.0E-4);
        Assert.assertEquals((double)0.35451, (double)result.getChrY(), (double)1.0E-4);
        Assert.assertEquals((double)154.7519, (double)result.getHue(), (double)1.0E-4);
        Assert.assertEquals((double)162.874, (double)result.getHueAngle(), (double)0.001);
        Assert.assertEquals((long)6L, (long)result.getFuValue());
    }

    @Test
    public void testComputeOlci() {
        FuAlgoFactory factory = new FuAlgoFactory(Instrument.OLCI);
        FuAlgo fuAlgo = factory.create();
        FuResult result = fuAlgo.compute(new double[]{0.04376, 0.02783, 0.02534, 0.0208, 0.01462, 0.00549, 4.1E-4, 0.00161, 0.00164, 0.00179, 0.00153});
        Assert.assertEquals((double)0.7186, (double)result.getX3(), (double)1.0E-4);
        Assert.assertEquals((double)0.7878, (double)result.getY3(), (double)1.0E-4);
        Assert.assertEquals((double)2.5595, (double)result.getZ3(), (double)1.0E-4);
        Assert.assertEquals((double)0.17674, (double)result.getChrX(), (double)1.0E-4);
        Assert.assertEquals((double)0.19375, (double)result.getChrY(), (double)1.0E-4);
        Assert.assertEquals((double)221.71018, (double)result.getHue(), (double)1.0E-4);
        Assert.assertEquals((double)221.7655, (double)result.getHueAngle(), (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)result.getFuValue());
    }

    @Test
    public void testComputeSeaWifs() {
        FuAlgoFactory factory = new FuAlgoFactory(Instrument.SEAWIFS);
        FuAlgo fuAlgo = factory.create();
        FuResult result = fuAlgo.compute(new double[]{1.1E-4, 7.4E-4, 0.00125, 0.00159, 0.00178, 3.4E-4});
        Assert.assertEquals((double)0.1228, (double)result.getX3(), (double)1.0E-4);
        Assert.assertEquals((double)0.1551, (double)result.getY3(), (double)1.0E-4);
        Assert.assertEquals((double)0.0876, (double)result.getZ3(), (double)1.0E-4);
        Assert.assertEquals((double)0.33598, (double)result.getChrX(), (double)1.0E-4);
        Assert.assertEquals((double)0.42441, (double)result.getChrY(), (double)1.0E-4);
        Assert.assertEquals((double)88.33525, (double)result.getHue(), (double)1.0E-4);
        Assert.assertEquals((double)100.09454, (double)result.getHueAngle(), (double)1.0E-4);
        Assert.assertEquals((long)8L, (long)result.getFuValue());
    }
}

