/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.s3tbx.fu.FuOp;
import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FuOpTest {
    private static FuOp.Spi operatorSpi;

    @BeforeClass
    public static void setUp() throws Exception {
        operatorSpi = new FuOp.Spi();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)operatorSpi);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)operatorSpi);
    }

    @Test
    public void testFindInstrument() throws Exception {
        Product product = new Product("MER_RR__2P_how_dummy_it_is", "MER_RR__2P");
        Assert.assertEquals((Object)"MER_RR__2P", (Object)product.getProductType());
    }

    @Test
    public void testImageInfoColorPalette() throws Exception {
        ImageInfo indexInfo = FuOp.createImageInfo((IndexCoding)new IndexCoding("Forel-Ule Scale"));
        ColorPaletteDef.Point[] points = indexInfo.getColorPaletteDef().getPoints();
        Assert.assertEquals((long)22L, (long)points.length);
        for (int i = 0; i < points.length; ++i) {
            this.assertFUColor(i, points[i].getColor());
        }
    }

    @Test
    public void testAttachIndexCodingToBand() throws Exception {
        Product product = new Product("test_product", "test", 20, 20);
        Band fuBand = new Band("test_Band", 10, 10, 10);
        product.addBand(fuBand);
        Assert.assertNull((Object)fuBand.getSampleCoding());
        Assert.assertNull((Object)fuBand.getIndexCoding());
        FuOp.attachIndexCoding((Band)fuBand);
        Assert.assertNotNull((Object)fuBand.getSampleCoding());
        Assert.assertNotNull((Object)fuBand.getIndexCoding());
    }

    @Test
    public void testGetTheBandNamsWithCloseWavelength() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        FuOpTest.addBand(product, "a", 500.0f);
        FuOpTest.addBand(product, "a2", 504.0f);
        FuOpTest.addBand(product, "a3", 506.5f);
        FuOpTest.addBand(product, "a4", 508.0f);
        FuOpTest.addBand(product, "b", 600.0f);
        FuOpTest.addBand(product, "c", 620.0f);
        FuOpTest.addBand(product, "d", 700.0f);
        FuOpTest.addBand(product, "e", 712.0f);
        FuOpTest.addBand(product, "f", 720.0f);
        FuOpTest.addBand(product, "g", 799.0f);
        double[] centralWavelength = new double[]{506.0, 603.0, 620.0, 704.0, 720.0, 730.0, 797.0};
        Object[] waveBand = FuOp.findWaveBand((Product)product, (double[])centralWavelength, (double)5.0);
        Object[] expecteds = new String[]{"a3", "b", "c", "d", "f", "g"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])waveBand);
    }

    @Test
    public void testGetTheBandNamsWithTheDifferentWavelength() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        FuOpTest.addBand(product, "a", 500.0f);
        FuOpTest.addBand(product, "b", 600.0f);
        FuOpTest.addBand(product, "c", 620.0f);
        FuOpTest.addBand(product, "d", 700.0f);
        FuOpTest.addBand(product, "e", 712.0f);
        FuOpTest.addBand(product, "f", 720.0f);
        FuOpTest.addBand(product, "g", 799.0f);
        double[] centralWavelength = new double[]{504.0, 602.0, 622.0, 703.0, 713.0, 723.0, 800.0};
        Object[] waveBand = FuOp.findWaveBand((Product)product, (double[])centralWavelength, (double)5.0);
        Object[] expecteds = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])waveBand);
    }

    @Test
    public void testGetTheBandCloseWavelength() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        FuOpTest.addBand(product, "a", 500.0f);
        FuOpTest.addBand(product, "a2", 502.5f);
        FuOpTest.addBand(product, "b", 506.0f);
        double[] centralWavelength = new double[]{501.0, 501.5, 502.0, 505.0, 622.0, 703.0, 713.0, 723.0, 800.0};
        Object[] waveBand = FuOp.findWaveBand((Product)product, (double[])centralWavelength, (double)5.0);
        Object[] expecteds = new String[]{"a", "a2", "a2", "b"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])waveBand);
    }

    @Test
    public void testWithCoastColourLikeInput() throws Exception {
        Product radianceProduct = new Product("CoastColour_L2R", "cc-dummy", 1, 1);
        FuOpTest.addBand(radianceProduct, "reflec_1", 412.691f, 0.0209);
        FuOpTest.addBand(radianceProduct, "reflec_2", 442.559f, 0.0257);
        FuOpTest.addBand(radianceProduct, "reflec_3", 489.882f, 0.038);
        FuOpTest.addBand(radianceProduct, "reflec_4", 509.819f, 0.0416);
        FuOpTest.addBand(radianceProduct, "reflec_5", 559.694f, 0.0423);
        FuOpTest.addBand(radianceProduct, "reflec_6", 619.601f, 0.0113);
        FuOpTest.addBand(radianceProduct, "reflec_7", 664.573f, 0.0063);
        FuOpTest.addBand(radianceProduct, "reflec_8", 680.821f, 0.0056);
        FuOpTest.addBand(radianceProduct, "reflec_9", 708.329f, 0.003);
        FuOpTest.addBand(radianceProduct, "reflec_10", 753.371f, 8.572E-4);
        FuOpTest.addBand(radianceProduct, "reflec_12", 778.409f, 9.388E-4);
        FuOpTest.addBand(radianceProduct, "reflec_13", 864.876f, 3.678E-4);
        HashMap<String, String> radianceParams = new HashMap<String, String>();
        radianceParams.put("validExpression", "true");
        radianceParams.put("instrument", (String)Instrument.MERIS);
        Product radianceResult = GPF.createProduct((String)"FuClassification", radianceParams, (Product)radianceProduct);
        int radianceFuValue = radianceResult.getBand("FU").getSampleInt(0, 0);
        float radianceHueValue = radianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Product irradianceProduct = new Product("CoastColour_L2R", "cc-dummy", 1, 1);
        FuOpTest.addBand(irradianceProduct, "reflec_1", 412.691f, 0.06565928646002667);
        FuOpTest.addBand(irradianceProduct, "reflec_2", 442.559f, 0.08073893119725768);
        FuOpTest.addBand(irradianceProduct, "reflec_3", 489.882f, 0.11938052083641214);
        FuOpTest.addBand(irradianceProduct, "reflec_4", 509.819f, 0.13069025438933538);
        FuOpTest.addBand(irradianceProduct, "reflec_5", 559.694f, 0.13288936924684824);
        FuOpTest.addBand(irradianceProduct, "reflec_6", 619.601f, 0.03549999698556466);
        FuOpTest.addBand(irradianceProduct, "reflec_7", 664.573f, 0.019792033717615697);
        FuOpTest.addBand(irradianceProduct, "reflec_8", 680.821f, 0.017592918860102842);
        FuOpTest.addBand(irradianceProduct, "reflec_9", 708.329f, 0.00942477796076938);
        FuOpTest.addBand(irradianceProduct, "reflec_10", 753.371f, 0.002692973222657171);
        FuOpTest.addBand(irradianceProduct, "reflec_12", 778.409f, 0.002949327183190098);
        FuOpTest.addBand(irradianceProduct, "reflec_13", 864.876f, 0.0011554777779903258);
        HashMap<String, Object> irradianceParams = new HashMap<String, Object>();
        irradianceParams.put("validExpression", "true");
        irradianceParams.put("instrument", Instrument.MERIS);
        irradianceParams.put("inputIsIrradianceReflectance", true);
        Product irradianceResult = GPF.createProduct((String)"FuClassification", irradianceParams, (Product)irradianceProduct);
        int irradianceFuValue = irradianceResult.getBand("FU").getSampleInt(0, 0);
        float irradianceHueValue = irradianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Assert.assertEquals((double)irradianceFuValue, (double)radianceFuValue, (double)1.0E-6);
        Assert.assertEquals((double)irradianceHueValue, (double)radianceHueValue, (double)1.0E-6);
    }

    @Test
    public void testFuValueColor() throws Exception {
        this.assertFUColor(0, new Color(0, 0, 0));
        this.assertFUColor(1, new Color(33, 88, 188));
        this.assertFUColor(2, new Color(49, 109, 197));
        this.assertFUColor(3, new Color(50, 124, 187));
        this.assertFUColor(4, new Color(75, 128, 160));
        this.assertFUColor(5, new Color(86, 143, 150));
        this.assertFUColor(6, new Color(109, 146, 152));
        this.assertFUColor(7, new Color(105, 140, 134));
        this.assertFUColor(8, new Color(117, 158, 114));
        this.assertFUColor(9, new Color(123, 166, 84));
        this.assertFUColor(10, new Color(125, 174, 56));
        this.assertFUColor(11, new Color(149, 182, 69));
        this.assertFUColor(12, new Color(148, 182, 96));
        this.assertFUColor(13, new Color(165, 188, 118));
        this.assertFUColor(14, new Color(170, 184, 109));
        this.assertFUColor(15, new Color(173, 181, 95));
        this.assertFUColor(16, new Color(168, 169, 101));
        this.assertFUColor(17, new Color(174, 159, 92));
        this.assertFUColor(18, new Color(179, 160, 83));
        this.assertFUColor(19, new Color(175, 138, 68));
        this.assertFUColor(20, new Color(164, 105, 5));
        this.assertFUColor(21, new Color(161, 77, 4));
    }

    @Test
    public void testMerisSourceProduct() throws Exception {
        Product radianceProduct = new Product("CoastColour_L2R", "cc-dummy", 1, 1);
        FuOpTest.addBand(radianceProduct, "reflec_1", 412.691f, 0.00981);
        FuOpTest.addBand(radianceProduct, "reflec_2", 442.559f, 0.011);
        FuOpTest.addBand(radianceProduct, "reflec_3", 489.882f, 0.01296);
        FuOpTest.addBand(radianceProduct, "reflec_4", 509.819f, 0.01311);
        FuOpTest.addBand(radianceProduct, "reflec_5", 559.694f, 0.01193);
        FuOpTest.addBand(radianceProduct, "reflec_6", 619.601f, 0.00298);
        FuOpTest.addBand(radianceProduct, "reflec_7", 664.573f, 0.0016);
        FuOpTest.addBand(radianceProduct, "reflec_8", 680.821f, 0.0014);
        FuOpTest.addBand(radianceProduct, "reflec_9", 708.329f, 8.1E-4);
        HashMap<String, String> radianceParams = new HashMap<String, String>();
        radianceParams.put("validExpression", "true");
        radianceParams.put("instrument", (String)Instrument.MERIS);
        Product radianceResult = GPF.createProduct((String)"FuClassification", radianceParams, (Product)radianceProduct);
        int radianceFuValue = radianceResult.getBand("FU").getSampleInt(0, 0);
        float radianceHueValue = radianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Assert.assertEquals((long)5L, (long)radianceFuValue);
        Assert.assertEquals((double)171.02552795410156, (double)radianceHueValue, (double)1.0E-8);
    }

    @Test
    public void testModisSourceProduct() throws Exception {
        Product radianceProduct = new Product("Modis FU_Hue_Value", "dummy", 1, 1);
        FuOpTest.addBand(radianceProduct, "reflec_1", 412.0f, 0.00242);
        FuOpTest.addBand(radianceProduct, "reflec_2", 443.0f, 0.0031);
        FuOpTest.addBand(radianceProduct, "reflec_3", 469.0f, 0.0);
        FuOpTest.addBand(radianceProduct, "reflec_4", 488.0f, 0.00345);
        FuOpTest.addBand(radianceProduct, "reflec_5", 531.0f, 0.0039);
        FuOpTest.addBand(radianceProduct, "reflec_6", 547.0f, 0.0);
        FuOpTest.addBand(radianceProduct, "reflec_7", 555.0f, 0.00358);
        FuOpTest.addBand(radianceProduct, "reflec_8", 645.0f, 0.0);
        FuOpTest.addBand(radianceProduct, "reflec_9", 667.0f, 5.9E-4);
        FuOpTest.addBand(radianceProduct, "reflec_10", 678.0f, 6.3E-4);
        HashMap<String, Instrument> radianceParams = new HashMap<String, Instrument>();
        radianceParams.put("instrument", Instrument.MODIS);
        Product radianceResult = GPF.createProduct((String)"FuClassification", radianceParams, (Product)radianceProduct);
        int radianceFuValue = radianceResult.getBand("FU").getSampleInt(0, 0);
        float radianceHueValue = radianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Assert.assertEquals((long)6L, (long)radianceFuValue);
        Assert.assertEquals((double)162.87364196777344, (double)radianceHueValue, (double)1.0E-8);
    }

    @Test
    public void testOLCISourceProduct() throws Exception {
        Product radianceProduct = new Product("OLCI FU_Hue_Value ", "cc-dummy", 1, 1);
        FuOpTest.addBand(radianceProduct, "reflec_1", 400.0f, 0.04376);
        FuOpTest.addBand(radianceProduct, "reflec_2", 412.5f, 0.02783);
        FuOpTest.addBand(radianceProduct, "reflec_3", 442.5f, 0.02534);
        FuOpTest.addBand(radianceProduct, "reflec_4", 490.0f, 0.0208);
        FuOpTest.addBand(radianceProduct, "reflec_5", 510.0f, 0.01462);
        FuOpTest.addBand(radianceProduct, "reflec_6", 560.0f, 0.00549);
        FuOpTest.addBand(radianceProduct, "reflec_7", 620.0f, 4.1E-4);
        FuOpTest.addBand(radianceProduct, "reflec_8", 665.0f, 0.00161);
        FuOpTest.addBand(radianceProduct, "reflec_9", 673.75f, 0.00164);
        FuOpTest.addBand(radianceProduct, "reflec_10", 681.25f, 0.00179);
        FuOpTest.addBand(radianceProduct, "reflec_11", 708.75f, 0.00153);
        HashMap<String, Instrument> radianceParams = new HashMap<String, Instrument>();
        radianceParams.put("instrument", Instrument.OLCI);
        Product radianceResult = GPF.createProduct((String)"FuClassification", radianceParams, (Product)radianceProduct);
        int radianceFuValue = radianceResult.getBand("FU").getSampleInt(0, 0);
        float radianceHueValue = radianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Assert.assertEquals((long)2L, (long)radianceFuValue);
        Assert.assertEquals((double)221.7655029296875, (double)radianceHueValue, (double)1.0E-8);
    }

    @Test
    public void testSeaWiFSSourceProduct() throws Exception {
        Product radianceProduct = new Product("SeaWIFS FU_Hue_Value", "cc-dummy", 1, 1);
        FuOpTest.addBand(radianceProduct, "reflec_1", 412.0f, 1.1E-4);
        FuOpTest.addBand(radianceProduct, "reflec_2", 443.0f, 7.4E-4);
        FuOpTest.addBand(radianceProduct, "reflec_3", 490.0f, 0.00125);
        FuOpTest.addBand(radianceProduct, "reflec_4", 510.0f, 0.00159);
        FuOpTest.addBand(radianceProduct, "reflec_5", 555.0f, 0.00178);
        FuOpTest.addBand(radianceProduct, "reflec_6", 670.0f, 3.4E-4);
        HashMap<String, Instrument> radianceParams = new HashMap<String, Instrument>();
        radianceParams.put("instrument", Instrument.SEAWIFS);
        Product radianceResult = GPF.createProduct((String)"FuClassification", radianceParams, (Product)radianceProduct);
        int radianceFuValue = radianceResult.getBand("FU").getSampleInt(0, 0);
        float radianceHueValue = radianceResult.getBand("hue_angle").getSampleFloat(0, 0);
        Assert.assertEquals((long)8L, (long)radianceFuValue);
        Assert.assertEquals((double)100.09454345703125, (double)radianceHueValue, (double)1.0E-8);
    }

    private static Band addBand(Product product, String bandName, float wavelength) {
        Band band = new Band(bandName, 31, 10, 10);
        band.setSpectralWavelength(wavelength);
        product.addBand(band);
        return band;
    }

    private static void addBand(Product product, String bandName, float wavelength, double value) {
        Band band = FuOpTest.addBand(product, bandName, wavelength);
        band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(band.getRasterWidth()), (Float)Float.valueOf(band.getRasterHeight()), (Number[])new Double[]{value}, null));
    }

    private void assertFUColor(int fuValue, Color expectedColor) {
        Color fuColor = FuOp.FU_COLORS[fuValue];
        Assert.assertEquals((long)expectedColor.getRed(), (long)fuColor.getRed());
        Assert.assertEquals((long)expectedColor.getGreen(), (long)fuColor.getGreen());
        Assert.assertEquals((long)expectedColor.getBlue(), (long)fuColor.getBlue());
    }
}

