/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import org.esa.s3tbx.fu.FuAlgoImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FuAlgoImplTest {
    private final double[] xFactor = new double[]{2.957, 10.861, 3.744, 3.75, 34.687, 41.853, 7.619, 0.844, 0.189};
    private final double[] yFactor = new double[]{0.112, 1.711, 5.672, 23.263, 48.791, 23.949, 2.944, 0.307, 0.068};
    private final double[] zFactor = new double[]{14.354, 58.356, 28.227, 4.022, 0.618, 0.026, 0.0, 0.0, 0.0};
    private final double[] polyHue = new double[]{-12.0506, 88.9325, -244.696, 305.2361, -164.696, 28.5255};
    private FuAlgoImpl fuAlgoImpl;

    @Before
    public void setUp() throws Exception {
        this.fuAlgoImpl = new FuAlgoImpl();
        this.fuAlgoImpl.setX3Factors(this.xFactor);
        this.fuAlgoImpl.setY3Factors(this.yFactor);
        this.fuAlgoImpl.setZ3Factors(this.zFactor);
        this.fuAlgoImpl.setPolyCoeffs(this.polyHue);
    }

    @Test
    public void testGetTristimulusValue() throws Exception {
        double[] spectrum = new double[]{0.222, 0.219, 0.277, 0.219, 0.235, 0.26, 0.281, 0.287, 0.273};
        Assert.assertEquals((double)26.36134, (double)this.fuAlgoImpl.getTristimulusValue(spectrum, this.xFactor), (double)1.0E-8);
        Assert.assertEquals((double)25.691876, (double)this.fuAlgoImpl.getTristimulusValue(spectrum, this.yFactor), (double)1.0E-8);
        Assert.assertEquals((double)24.818239000000005, (double)this.fuAlgoImpl.getTristimulusValue(spectrum, this.zFactor), (double)1.0E-8);
    }

    @Test
    public void testTristimulusHueAndFUForMERIS() throws Exception {
        double[] constPolyHue = new double[]{-12.0506, 88.9325, -244.696, 305.2361, -164.696, 28.5255};
        double[] spectrum = new double[]{0.00798, 0.01494, 0.027, 0.03116, 0.04357, 0.0281, 0.01942, 0.01863, 0.01472};
        double tristimulusValueX = this.fuAlgoImpl.getTristimulusValue(spectrum, this.xFactor);
        double tristimulusValueY = this.fuAlgoImpl.getTristimulusValue(spectrum, this.yFactor);
        double tristimulusValueZ = this.fuAlgoImpl.getTristimulusValue(spectrum, this.zFactor);
        Assert.assertEquals((double)3.25764687, (double)tristimulusValueX, (double)1.0E-8);
        Assert.assertEquals((double)3.7671588, (double)tristimulusValueY, (double)1.0E-8);
        Assert.assertEquals((double)1.90149494, (double)tristimulusValueZ, (double)1.0E-8);
        double denominator = tristimulusValueX + tristimulusValueY + tristimulusValueZ;
        double chrX = tristimulusValueX / denominator;
        double chrY = tristimulusValueY / denominator;
        Assert.assertEquals((double)0.36494926760034363, (double)chrX, (double)1.0E-8);
        Assert.assertEquals((double)0.4220291209753466, (double)chrY, (double)1.0E-8);
        double hue = this.fuAlgoImpl.getHue(chrX, chrY);
        double hue100 = hue / 100.0;
        Assert.assertEquals((double)70.38108395830288, (double)hue, (double)1.0E-8);
        Assert.assertEquals((double)0.7038108395830288, (double)hue100, (double)1.0E-8);
        double polyHue = this.fuAlgoImpl.getPolyCorr(hue100, constPolyHue);
        double hueMerisPCorr = hue + polyHue;
        byte fuValue = FuAlgoImpl.getFuValue((double)hueMerisPCorr);
        Assert.assertEquals((double)-1.759288220916794, (double)polyHue, (double)1.0E-8);
        Assert.assertEquals((double)68.6217957373861, (double)hueMerisPCorr, (double)1.0E-8);
        Assert.assertEquals((long)11L, (long)fuValue);
    }

    @Test
    public void testGetFumeValue() {
        Assert.assertEquals((long)0L, (long)FuAlgoImpl.getFuValue((double)233.0));
        Assert.assertEquals((long)1L, (long)FuAlgoImpl.getFuValue((double)232.0));
        Assert.assertEquals((long)2L, (long)FuAlgoImpl.getFuValue((double)227.0));
        Assert.assertEquals((long)3L, (long)FuAlgoImpl.getFuValue((double)210.4));
        Assert.assertEquals((long)4L, (long)FuAlgoImpl.getFuValue((double)200.89));
        Assert.assertEquals((long)5L, (long)FuAlgoImpl.getFuValue((double)180.8));
        Assert.assertEquals((long)6L, (long)FuAlgoImpl.getFuValue((double)150.0));
        Assert.assertEquals((long)7L, (long)FuAlgoImpl.getFuValue((double)131.0));
        Assert.assertEquals((long)8L, (long)FuAlgoImpl.getFuValue((double)105.0));
        Assert.assertEquals((long)9L, (long)FuAlgoImpl.getFuValue((double)93.9));
        Assert.assertEquals((long)10L, (long)FuAlgoImpl.getFuValue((double)80.9));
        Assert.assertEquals((long)11L, (long)FuAlgoImpl.getFuValue((double)73.4));
        Assert.assertEquals((long)12L, (long)FuAlgoImpl.getFuValue((double)62.89));
        Assert.assertEquals((long)13L, (long)FuAlgoImpl.getFuValue((double)56.8));
        Assert.assertEquals((long)14L, (long)FuAlgoImpl.getFuValue((double)51.0));
        Assert.assertEquals((long)15L, (long)FuAlgoImpl.getFuValue((double)46.89));
        Assert.assertEquals((long)16L, (long)FuAlgoImpl.getFuValue((double)39.9));
        Assert.assertEquals((long)17L, (long)FuAlgoImpl.getFuValue((double)35.09));
        Assert.assertEquals((long)18L, (long)FuAlgoImpl.getFuValue((double)30.987));
        Assert.assertEquals((long)19L, (long)FuAlgoImpl.getFuValue((double)27.987));
        Assert.assertEquals((long)20L, (long)FuAlgoImpl.getFuValue((double)23.987));
        Assert.assertEquals((long)21L, (long)FuAlgoImpl.getFuValue((double)20.987));
        Assert.assertEquals((long)21L, (long)FuAlgoImpl.getFuValue((double)10.0));
        Assert.assertEquals((long)21L, (long)FuAlgoImpl.getFuValue((double)20.0));
    }

    @Test
    public void testGetHueValue() throws Exception {
        Assert.assertEquals((double)225.0, (double)this.fuAlgoImpl.getHue(0.0, 0.0), (double)1.0E-8);
        Assert.assertEquals((double)50.52753979724931, (double)this.fuAlgoImpl.getHue(5.0, 6.0), (double)1.0E-8);
        Assert.assertEquals((double)37.4570178393783, (double)this.fuAlgoImpl.getHue(40.1, 30.8), (double)1.0E-8);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckNumberOfBands() throws Exception {
        this.fuAlgoImpl.getTristimulusValue(new double[4], this.xFactor);
    }

    @Test
    public void testSummarizationPolyHueMeris() throws Exception {
        double[] constPolyHueForMeris = new double[]{-12.0506, 88.9325, -244.696, 305.2361, -164.696, 28.5255};
        Assert.assertEquals((double)1.2515000000000285, (double)this.fuAlgoImpl.getPolyCorr(1.0, constPolyHueForMeris), (double)1.0E-8);
        Assert.assertEquals((double)-1.7544999999999717, (double)this.fuAlgoImpl.getPolyCorr(2.5, constPolyHueForMeris), (double)1.0E-8);
    }
}

