/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import junit.framework.TestCase;
import org.esa.s3tbx.fu.FuAlgo;
import org.esa.s3tbx.fu.FuAlgoFactory;
import org.esa.s3tbx.fu.FuResult;
import org.esa.s3tbx.fu.Instrument;
import org.junit.Test;

public class FuAlgoFactoryTest {
    @Test
    public void testCreationMeris() throws Exception {
        double[] spectrum = new double[]{0.222, 0.219, 0.277, 0.219, 0.235, 0.26, 0.281, 0.287, 0.273};
        FuAlgoFactory algoFactory = new FuAlgoFactory(Instrument.MERIS);
        FuAlgo algo = algoFactory.create();
        FuResult result = algo.compute(spectrum);
        TestCase.assertEquals((int)20, (int)result.getFuValue());
        TestCase.assertEquals((double)25.92721922205948, (double)result.getHueAngle(), (double)1.0E-8);
    }

    @Test
    public void testCreationModis() throws Exception {
        double[] spectrum = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
        FuAlgoFactory algoFactory = new FuAlgoFactory(Instrument.MODIS);
        FuAlgo algo = algoFactory.create();
        FuResult result = algo.compute(spectrum);
        TestCase.assertEquals((int)18, (int)result.getFuValue());
        TestCase.assertEquals((double)34.596036004742274, (double)result.getHueAngle(), (double)1.0E-8);
    }

    @Test
    public void testCreationSeaWifs() throws Exception {
        double[] spectrum = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        FuAlgoFactory algoFactory = new FuAlgoFactory(Instrument.SEAWIFS);
        FuAlgo algo = algoFactory.create();
        FuResult result = algo.compute(spectrum);
        TestCase.assertEquals((int)17, (int)result.getFuValue());
        TestCase.assertEquals((double)34.97265830605461, (double)result.getHueAngle(), (double)1.0E-8);
    }

    @Test
    public void testCreationOLCI() throws Exception {
        double[] spectrum = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        FuAlgoFactory algoFactory = new FuAlgoFactory(Instrument.OLCI);
        FuAlgo algo = algoFactory.create();
        FuResult result = algo.compute(spectrum);
        TestCase.assertEquals((int)17, (int)result.getFuValue());
        TestCase.assertEquals((double)39.07673192537948, (double)result.getHueAngle(), (double)1.0E-8);
    }
}

