/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import org.esa.s3tbx.fu.DetectInstrument;
import org.esa.s3tbx.fu.Instrument;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class DetectInstrumentTest {
    @Test
    public void testAutoDetectForMERISProduct() {
        Product product = new Product("dummy", "mer_r", 2, 2);
        product.setProductType("MER_RR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_FRS_2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_RR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
        product.setProductType("MER_FR__2P");
        Assert.assertEquals((Object)Instrument.MERIS, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testAutoDetectForOLCIProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("Oa01_radiance", 10);
        product.addBand("Oa02_radiance", 10);
        product.addBand("Oa03_radiance", 10);
        product.addBand("Oa04_radiance", 10);
        product.addBand("Oa05_radiance", 10);
        product.addBand("Oa06_radiance", 10);
        product.addBand("Oa07_radiance", 10);
        Assert.assertEquals((Object)Instrument.OLCI, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testAutoDetectForMODISProduct() {
        Product product = new Product("dummy", "modis", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement dsd23 = new MetadataElement("Global_Attributes");
        dsd23.setAttributeString("title", "HMODISA Level-2 Data");
        root.addElement(dsd23);
        Assert.assertEquals((Object)Instrument.MODIS, (Object)DetectInstrument.getInstrument((Product)product));
    }

    @Test
    public void testAutoDetectForSEAWIFSProduct() {
        Product product = new Product("dummy", "seawifs", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement dsd23 = new MetadataElement("Global_Attributes");
        dsd23.setAttributeString("Title", "SeaWiFS Level-2 Data");
        root.addElement(dsd23);
        Assert.assertEquals((Object)Instrument.SEAWIFS, (Object)DetectInstrument.getInstrument((Product)product));
    }
}

