/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.processor.flh_mci;

import org.esa.snap.core.gpf.OperatorException;

public final class BaselineAlgorithm {
    public static final float DEFAULT_CLOUD_CORRECT = 1.005f;
    private double lambdaFactor = 1.0;
    private double inverseDelta = 1.0;
    private double cloudCorrectionFactor = 1.005f;

    public final void setWavelengths(float lowerLambda, float upperLambda, float signalLambda) throws OperatorException {
        if (lowerLambda < 0.0f || upperLambda < 0.0f || signalLambda < 0.0f) {
            throw new OperatorException("Negative wavelengths");
        }
        double num = signalLambda - lowerLambda;
        if (num == 0.0) {
            throw new OperatorException("Numerator is 0, lower and signal wavelength are identical!");
        }
        double denom = upperLambda - lowerLambda;
        if (denom == 0.0) {
            throw new OperatorException("Denominator is 0, lower and upper wavelength are identical");
        }
        this.inverseDelta = 1.0 / denom;
        this.lambdaFactor = num / denom;
    }

    public final void setCloudCorrectionFactor(float factor) {
        this.cloudCorrectionFactor = factor;
    }

    public final double computeLineHeight(double lower, double upper, double peak) {
        return peak - this.cloudCorrectionFactor * (lower + (upper - lower) * this.lambdaFactor);
    }

    public final double computeSlope(double lower, double upper) {
        return (upper - lower) * this.inverseDelta;
    }
}

