/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.chris.internal.SunPosition;
import org.esa.s3tbx.dataio.chris.internal.SunPositionCalculator;

public class SunPositionCalculatorTest
extends TestCase {
    public void testCalculate() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(2002, 6, 1, 12, 0, 0);
        SunPosition sunPosition = SunPositionCalculator.calculate((Calendar)calendar, (double)55.0, (double)10.0);
        SunPositionCalculatorTest.assertEquals((double)32.59, (double)sunPosition.getZenithAngle(), (double)0.02);
        SunPositionCalculatorTest.assertEquals((double)195.57, (double)sunPosition.getAzimuthAngle(), (double)0.02);
        calendar.set(2004, 8, 1, 14, 0, 0);
        sunPosition = SunPositionCalculator.calculate((Calendar)calendar, (double)55.0, (double)10.0);
        SunPositionCalculatorTest.assertEquals((double)56.69, (double)sunPosition.getZenithAngle(), (double)0.02);
        SunPositionCalculatorTest.assertEquals((double)229.67, (double)sunPosition.getAzimuthAngle(), (double)0.02);
    }
}

