/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import junit.framework.TestCase;
import org.esa.s3tbx.dataio.chris.internal.MaskRefinement;

public class MaskRefinementTest
extends TestCase {
    static final int ROW_COUNT = 2;
    static final int COL_COUNT = 10;

    public void testMaskRefinement() {
        int[] data = new int[20];
        short[] mask = new short[20];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                data[i * 10 + j] = 1;
            }
        }
        MaskRefinement maskRefinement = new MaskRefinement(1.5);
        maskRefinement.refine(data, mask, 10);
        MaskRefinementTest.assertEquals((int)0, (int)mask[0]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[1]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[2]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[3]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[4]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[5]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[6]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[7]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[8]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[9]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[10]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[11]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[12]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[13]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[14]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[15]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[16]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[17]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[18]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[19]);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (j % 2 != 0) continue;
                data[i * 10 + j] = 10;
            }
        }
        maskRefinement.refine(data, mask, 10);
        MaskRefinementTest.assertEquals((int)1, (int)mask[0]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[1]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[2]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[3]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[4]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[5]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[6]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[7]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[8]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[9]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[10]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[11]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[12]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[13]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[14]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[15]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[16]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[17]);
        MaskRefinementTest.assertEquals((int)1, (int)mask[18]);
        MaskRefinementTest.assertEquals((int)0, (int)mask[19]);
    }

    public void testAdjacentDifference() {
        int[] values = new int[]{2, 3, 5, 7, 11, 13, 17, 19};
        double[] diffs = new double[2];
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)1, (double[])diffs);
        MaskRefinementTest.assertEquals((double)1.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)2.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)2, (int)1, (double[])diffs);
        MaskRefinementTest.assertEquals((double)2.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)4.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)2, (double[])diffs);
        MaskRefinementTest.assertEquals((double)3.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)6.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)1, (int)2, (double[])diffs);
        MaskRefinementTest.assertEquals((double)4.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)6.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)0, (int)3, (double[])diffs);
        MaskRefinementTest.assertEquals((double)5.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)10.0, (double)diffs[1], (double)0.0);
        MaskRefinement.adjacentDifference((int[])values, (int)1, (int)3, (double[])diffs);
        MaskRefinementTest.assertEquals((double)8.0, (double)diffs[0], (double)0.0);
        MaskRefinementTest.assertEquals((double)8.0, (double)diffs[1], (double)0.0);
    }

    public void testMedian() {
        try {
            MaskRefinement.median(null);
            MaskRefinementTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MaskRefinement.median((double[])new double[0]);
            MaskRefinementTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MaskRefinementTest.assertEquals((double)1.0, (double)MaskRefinement.median((double[])new double[]{1.0}), (double)0.0);
        MaskRefinementTest.assertEquals((double)2.0, (double)MaskRefinement.median((double[])new double[]{2.0, 1.0, 3.0}), (double)0.0);
        MaskRefinementTest.assertEquals((double)3.0, (double)MaskRefinement.median((double[])new double[]{3.0, 1.0, 4.0, 2.0, 5.0}), (double)0.0);
    }
}

