/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.esa.s3tbx.dataio.chris.internal.SunPosition;

public class SunPositionCalculator {
    public static SunPosition calculate(Calendar calendar, double lat, double lon) {
        Calendar utc = SunPositionCalculator.toUTC(calendar);
        int year = utc.get(1);
        int month = utc.get(2) + 1;
        int date = utc.get(5);
        int hour = utc.get(11);
        int minute = utc.get(12);
        int second = utc.get(13);
        double h = (double)hour + (double)minute / 60.0 + (double)second / 3600.0;
        double d = h / 24.0 + (double)(367 * year - 7 * (year + (month + 9) / 12) / 4 + 275 * month / 9 + date - 730530);
        double w = Math.toRadians(282.9404) + Math.toRadians(4.70935E-5) * d;
        double e = 0.016709 - 1.151E-9 * d;
        double M = Math.toRadians(356.047) + Math.toRadians(0.9856002585) * d;
        double o = Math.toRadians(23.4393) - Math.toRadians(3.563E-7) * d;
        double E = M + e * Math.sin(M) * (1.0 + e * Math.cos(M));
        double v = Math.atan2(Math.sqrt(1.0 - e * e) * Math.sin(E), Math.cos(E) - e);
        double l = v + w;
        double x = Math.cos(l);
        double y = Math.sin(l) * Math.cos(o);
        double z = Math.sin(l) * Math.sin(o);
        double alpha = Math.atan2(y, x);
        double delta = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lst = M + w + Math.PI + h * Math.toRadians(15.0) + Math.toRadians(lon);
        double lha = lst - alpha;
        double phi = Math.toRadians(lat);
        double alt = Math.asin(Math.sin(phi) * Math.sin(delta) + Math.cos(phi) * Math.cos(delta) * Math.cos(lha));
        double xaa = Math.cos(lha) * Math.cos(delta) * Math.sin(phi) - Math.sin(delta) * Math.cos(phi);
        double yaa = Math.sin(lha) * Math.cos(delta);
        double saa = Math.atan2(yaa, xaa) + Math.PI;
        double sza = 1.5707963267948966 - alt;
        return new SunPosition(Math.toDegrees(sza), Math.toDegrees(saa));
    }

    private static Calendar toUTC(Calendar calendar) {
        GregorianCalendar utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(calendar.getTimeInMillis());
        return utc;
    }
}

