/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import com.bc.ceres.core.Assert;
import java.awt.Rectangle;

public class DropoutCorrection {
    private static final int M_WIDTH = 3;
    private static final int M_HEIGHT = 3;
    private static final short VALID = 0;
    private static final short DROPOUT = 1;
    private static final short SATURATED = 2;
    private static final short CORRECTED_DROPOUT = 256;
    private double[] weights;
    private boolean cosmetic;

    public DropoutCorrection() {
        this(Type.N4);
    }

    public DropoutCorrection(Type type) {
        this(type, false);
    }

    public DropoutCorrection(Type type, boolean cosmetic) {
        this.weights = type.getWeights();
        this.cosmetic = cosmetic;
    }

    public void compute(int[][] rciData, short[][] maskData, int rasterWidth, int rasterHeight, Rectangle targetRectangle) {
        this.compute(rciData, maskData, new Rectangle(0, 0, rasterWidth, rasterHeight), 0, rasterWidth, rciData[0], maskData[0], targetRectangle, targetRectangle.x + targetRectangle.y * rasterWidth, rasterWidth);
    }

    public void compute(int[][] sourceRciData, short[][] sourceMaskData, Rectangle sourceRectangle, int sourceOffset, int sourceStride, int[] targetRciData, short[] targetMaskData, Rectangle targetRectangle, int targetOffset, int targetStride) {
        Assert.argument((sourceRciData.length == sourceMaskData.length ? 1 : 0) != 0);
        Assert.argument((boolean)sourceRectangle.contains(targetRectangle));
        double[] w = new double[this.weights.length];
        for (int ty = targetRectangle.y; ty < targetRectangle.y + targetRectangle.height; ++ty) {
            for (int tx = targetRectangle.x; tx < targetRectangle.x + targetRectangle.width; ++tx) {
                int sxy = sourceOffset + (tx - sourceRectangle.x) + (ty - sourceRectangle.y) * sourceStride;
                int txy = targetOffset + (tx - targetRectangle.x) + (ty - targetRectangle.y) * targetStride;
                targetRciData[txy] = sourceRciData[0][sxy];
                targetMaskData[txy] = sourceMaskData[0][sxy];
                if (sourceMaskData[0][sxy] != 1) continue;
                double ws = 0.0;
                double xc = 0.0;
                double ws2 = 0.0;
                double xc2 = 0.0;
                int i = 0;
                int y = ty - 1;
                while (i < 3) {
                    if (y >= sourceRectangle.y && y < sourceRectangle.y + sourceRectangle.height) {
                        int j = 0;
                        int x = tx - 1;
                        while (j < 3) {
                            if (x >= sourceRectangle.x && x < sourceRectangle.x + sourceRectangle.width) {
                                int ij = i * 3 + j;
                                int xy = sourceOffset + (x - sourceRectangle.x) + (y - sourceRectangle.y) * sourceStride;
                                if (this.weights[ij] != 0.0) {
                                    switch (sourceMaskData[0][xy]) {
                                        case 0: {
                                            w[ij] = this.weights[ij] * this.calculateWeight(sxy, xy, sourceRciData, sourceMaskData);
                                            ws += w[ij];
                                            xc += (double)sourceRciData[0][xy] * w[ij];
                                            break;
                                        }
                                        case 2: {
                                            ws2 += this.weights[ij];
                                            xc2 += (double)sourceRciData[0][xy] * this.weights[ij];
                                        }
                                    }
                                }
                            }
                            ++j;
                            ++x;
                        }
                    }
                    ++i;
                    ++y;
                }
                if (ws > 0.0) {
                    targetRciData[txy] = (int)(xc / ws);
                    if (this.cosmetic) continue;
                    targetMaskData[txy] = 256;
                    continue;
                }
                if (ws2 > 0.0) {
                    targetRciData[txy] = (int)(xc2 / ws2);
                    if (this.cosmetic) continue;
                    targetMaskData[txy] = 2;
                    continue;
                }
                targetRciData[txy] = 0;
            }
        }
    }

    private double calculateWeight(int index, int neighborIndex, int[][] rciData, short[][] maskData) {
        double sum = 0.0;
        int count = 0;
        for (int i = 1; i < rciData.length; ++i) {
            if (maskData[i][index] != 0 || maskData[i][neighborIndex] != 0 || rciData[i][index] == 0) continue;
            double d = rciData[i][index] - rciData[i][neighborIndex];
            sum += d * d;
            ++count;
        }
        return count > 0 ? 1.0 / (1.0E-52 + Math.sqrt(sum / (double)count)) : 1.0;
    }

    public static enum Type {
        N2("2-Connected", new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}),
        N4("4-Connected", new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0}),
        N8("8-Connected", new double[]{1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0});

        private final String name;
        private final double[] weights;

        private Type(String name, double[] weights) {
            this.name = name;
            this.weights = weights;
        }

        private double[] getWeights() {
            return this.weights;
        }

        public String toString() {
            return this.name;
        }
    }
}

