/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris;

import java.awt.Color;

public enum Flags {
    DROPOUT(1, "Dropout pixel", Color.red),
    SATURATED(2, "Saturated pixel", Color.orange),
    DROPOUT_CORRECTED(256, "Corrected dropout pixel", Color.green);

    private int mask;
    private Color color;
    private float transparency;
    private String description;

    private Flags(int mask, String description, Color color) {
        this(mask, description, color, 0.5f);
    }

    private Flags(int mask, String description, Color color, float transparency) {
        this.mask = mask;
        this.color = color;
        this.transparency = transparency;
        this.description = description;
    }

    public final int getMask() {
        return this.mask;
    }

    public final String getDescription() {
        return this.description;
    }

    public Color getColor() {
        return this.color;
    }

    public final float getTransparency() {
        return this.transparency;
    }

    public final boolean isSet(int value) {
        return (value & this.mask) != 0;
    }

    public final String toString() {
        return this.name().toLowerCase();
    }
}

