/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.esa.s3tbx.dataio.chris.ChrisConstants;
import org.esa.s3tbx.dataio.chris.ScanLineLayout;
import org.esa.snap.core.util.io.CsvReader;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

class ChrisFile {
    private File file;
    private NetcdfFile ncFile = null;
    private Variable rciImageSds;
    private Variable maskSds;
    private Map<String, String> globalAttributes;
    private Map<Integer, Float> gainInfoMap;
    private float[][] modeInfo;
    private ScanLineLayout scanLineLayout;
    private int sceneRasterHeight;
    private boolean flipped;
    private Map<String, ScanLineLayout> scanLineLayoutMap;

    public ChrisFile(File file) {
        this.file = file;
        try {
            this.scanLineLayoutMap = ChrisFile.readScanLineLayoutMap();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void open() throws IOException {
        if (this.ncFile != null) {
            throw new IllegalStateException("already open");
        }
        try {
            this.ncFile = NetcdfFileOpener.open((Object)this.file.getAbsolutePath());
            this.globalAttributes = ChrisFile.readGlobalAttributes(this.ncFile);
            this.rciImageSds = ChrisFile.getRciSds(this.ncFile);
            this.maskSds = ChrisFile.getMaskSds(this.ncFile);
            this.modeInfo = ChrisFile.readModeInfo(this.ncFile);
            this.gainInfoMap = ChrisFile.readGainInfo(this.ncFile);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOException ioe = new IOException(MessageFormat.format("Failed to open CHRIS file ''{0}'':\n{1}", this.file, e.getMessage()));
            ioe.initCause(e);
            throw ioe;
        }
        this.determineProcessingVersion();
        this.determineSceneRasterHeight();
        this.determineFlipping();
        this.determineScanLineLayout();
    }

    public void close() throws IOException {
        if (this.ncFile == null) {
            return;
        }
        try {
            if (this.globalAttributes != null) {
                this.globalAttributes.clear();
            }
            this.ncFile.close();
        }
        catch (IOException e) {
            IOException ioe = new IOException(MessageFormat.format("Failed to close CHRIS file ''{0}''", this.file));
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.rciImageSds = null;
            this.maskSds = null;
            this.modeInfo = null;
            this.ncFile = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getSceneRasterWidth() {
        return this.scanLineLayout.imagePixelCount;
    }

    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    public int getSpectralBandCount() {
        return this.rciImageSds.getDimension(0).getLength();
    }

    public float getCutOnWavelength(int bandIndex) {
        return this.modeInfo[bandIndex][0];
    }

    public float getCutOffWavelength(int bandIndex) {
        return this.modeInfo[bandIndex][1];
    }

    public float getWavelength(int bandIndex) {
        return this.modeInfo[bandIndex][2];
    }

    public float getBandwidth(int bandIndex) {
        return this.modeInfo[bandIndex][3];
    }

    public int getGainSetting(int bandIndex) {
        return (int)this.modeInfo[bandIndex][4];
    }

    public float getGainValue(int bandIndex) {
        int gainSetting = this.getGainSetting(bandIndex);
        if (this.gainInfoMap.containsKey(gainSetting)) {
            return this.gainInfoMap.get(gainSetting).floatValue();
        }
        return Float.NaN;
    }

    public int getLowRow(int bandIndex) {
        return (int)this.modeInfo[bandIndex][5];
    }

    public int getHighRow(int bandIndex) {
        return (int)this.modeInfo[bandIndex][6];
    }

    public boolean hasMask() {
        return this.maskSds != null;
    }

    public void readRciData(int bandIndex, int offsetX, int offsetY, int stepX, int stepY, int width, int height, int[] data) throws IOException {
        try {
            offsetX += this.scanLineLayout.leadingPixelCount;
            if (this.flipped) {
                offsetY = this.sceneRasterHeight - offsetY - height;
            }
            int[] start = new int[]{bandIndex, offsetY, offsetX};
            int[] stride = new int[]{1, stepY, stepX};
            int[] count = new int[]{1, height, width};
            Section section = new Section(start, count, stride);
            Array array = this.rciImageSds.read(section);
            Object storage = array.getStorage();
            System.arraycopy(storage, 0, data, 0, data.length);
            if (this.flipped) {
                this.flipImage(data, width);
            }
        }
        catch (InvalidRangeException e) {
            IOException ioe = new IOException(MessageFormat.format("Failed to read data from band #{0} of ''{1}''", bandIndex + 1, this.rciImageSds.getFullName()));
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void readMaskData(int bandIndex, int offsetX, int offsetY, int stepX, int stepY, int width, int height, short[] mask) throws IOException {
        try {
            offsetX += this.scanLineLayout.leadingPixelCount;
            if (this.flipped) {
                offsetY = this.sceneRasterHeight - offsetY - height;
            }
            int[] start = new int[]{bandIndex, offsetY, offsetX};
            int[] stride = new int[]{1, stepY, stepX};
            int[] count = new int[]{1, height, width};
            Section section = new Section(start, count, stride);
            Array array = this.maskSds.read(section);
            Object storage = array.getStorage();
            System.arraycopy(storage, 0, mask, 0, mask.length);
            if (this.flipped) {
                this.flipImage(mask, width);
            }
        }
        catch (InvalidRangeException e) {
            IOException ioe = new IOException("Failed to read data from band #" + (bandIndex + 1) + " of '" + this.maskSds.getFullName() + "'");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void flipImage(int[] data, int width) {
        int[] temp = new int[width];
        int lastRowOffset = data.length - width;
        for (int i = 0; i < data.length / 2; i += width) {
            System.arraycopy(data, i, temp, 0, width);
            System.arraycopy(data, lastRowOffset - i, data, i, width);
            System.arraycopy(temp, 0, data, lastRowOffset - i, width);
        }
    }

    private void flipImage(short[] data, int width) {
        short[] temp = new short[width];
        int lastRowOffset = data.length - width;
        for (int i = 0; i < data.length / 2; i += width) {
            System.arraycopy(data, i, temp, 0, width);
            System.arraycopy(data, lastRowOffset - i, data, i, width);
            System.arraycopy(temp, 0, data, lastRowOffset - i, width);
        }
    }

    public String[] getGlobalAttributeNames() {
        Set<String> names = this.globalAttributes.keySet();
        return names.toArray(new String[names.size()]);
    }

    public String getGlobalAttribute(String key) {
        return this.globalAttributes.get(key);
    }

    public String getGlobalAttribute(String key, String defaultValue) {
        String value = this.getGlobalAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getGlobalAttribute(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getGlobalAttribute(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static float[][] readModeInfo(NetcdfFile ncFile) throws IOException {
        Variable modeInfoVar = ncFile.getRootGroup().findVariable("Mode_Information");
        if (modeInfoVar instanceof Structure) {
            Structure modeInfoStruct = (Structure)modeInfoVar;
            int numRecords = modeInfoStruct.getDimension(0).getLength();
            String[] fieldNames = ChrisConstants.VS_NAME_MODE_FIELDS;
            Variable[] fieldVariables = new Variable[fieldNames.length];
            for (int i = 0; i < fieldVariables.length; ++i) {
                fieldVariables[i] = modeInfoStruct.findVariable(fieldNames[i]);
                if (fieldVariables[i] != null) continue;
                throw new IOException("Failed to read 'Mode Info' Structure.");
            }
            float[][] modeInfo = new float[numRecords][fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                Array array = fieldVariables[i].read();
                for (int j = 0; j < numRecords; ++j) {
                    modeInfo[j][i] = array.getFloat(j);
                }
            }
            return modeInfo;
        }
        throw new IOException("Failed to read 'Mode Info' Structure.");
    }

    private static Map<Integer, Float> readGainInfo(NetcdfFile ncFile) throws IOException {
        Variable gainInfoVar = ncFile.getRootGroup().findVariable("Gain_Information");
        if (gainInfoVar instanceof Structure) {
            Structure gainInfoStruct = (Structure)gainInfoVar;
            int recordCount = gainInfoStruct.getDimension(0).getLength();
            Variable gainSetting = gainInfoStruct.findVariable("Gain_Setting");
            Variable gainValue = gainInfoStruct.findVariable("Gain_Value");
            if (gainSetting != null && gainValue != null && recordCount > 0) {
                HashMap<Integer, Float> gainInfoMap = new HashMap<Integer, Float>(recordCount);
                Array settingsArray = gainSetting.read();
                Array valuesArray = gainValue.read();
                for (int i = 0; i < recordCount; ++i) {
                    gainInfoMap.put(settingsArray.getInt(i), Float.valueOf(valuesArray.getFloat(i)));
                }
                return gainInfoMap;
            }
        }
        throw new IOException("Failed to read 'Gain Info' Structure.");
    }

    private static Map<String, String> readGlobalAttributes(NetcdfFile ncFile) {
        List globalNcAttributes = ncFile.getGlobalAttributes();
        TreeMap<String, String> globalAttributes = new TreeMap<String, String>();
        for (Attribute attribute : globalNcAttributes) {
            globalAttributes.put(attribute.getShortName().trim(), attribute.getStringValue().trim());
        }
        return globalAttributes;
    }

    private static Variable getVariable(NetcdfFile ncFile, String sdsName, boolean require) throws IOException {
        try {
            Variable variable = ncFile.getRootGroup().findVariable(sdsName);
            if (variable == null) {
                if (require) {
                    throw new IOException(MessageFormat.format("Missing dataset ''{0}''", sdsName));
                }
                return null;
            }
            return variable;
        }
        catch (IOException e) {
            IOException ioe = new IOException(MessageFormat.format("Failed to access dataset ''{0}''", sdsName));
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static Variable getRciSds(NetcdfFile ncFile) throws IOException {
        Variable sds = ChrisFile.getVariable(ncFile, "RCI_Image", true);
        if (sds.getDimensions().size() != 3) {
            throw new IOException("Wrong number of dimensions, expected 3");
        }
        if (sds.getDataType() != DataType.INT) {
            throw new IOException("Wrong data type, 32-bit integer expected");
        }
        return sds;
    }

    private static Variable getMaskSds(NetcdfFile ncFile) throws IOException {
        Variable sds = ChrisFile.getVariable(ncFile, "Saturation_Reset_Mask", false);
        if (sds != null) {
            if (sds.getDimensions().size() != 3) {
                throw new IOException("Wrong number of dimensions, expected 3");
            }
            if (sds.getDataType() != DataType.SHORT) {
                throw new IOException("Wrong data type, 16-bit integer expected");
            }
        }
        return sds;
    }

    private void determineProcessingVersion() {
        String processingVersion;
        int numAttributes = this.globalAttributes.size();
        switch (numAttributes) {
            case 22: {
                processingVersion = "3.0";
                break;
            }
            case 23: {
                processingVersion = "3.1";
                break;
            }
            case 25: {
                processingVersion = "4.0";
                break;
            }
            case 26: {
                processingVersion = "4.1";
                break;
            }
            default: {
                processingVersion = "unkown";
            }
        }
        this.globalAttributes.put("Processing Version", processingVersion);
    }

    private void determineFlipping() {
        String imageNumber = this.getGlobalAttribute("Image_Number", "0");
        boolean bl = this.flipped = imageNumber.startsWith("2") || imageNumber.startsWith("3");
        if (this.flipped) {
            this.globalAttributes.put("Image_Flipped_Along-Track", "Yes");
        }
    }

    private void determineSceneRasterHeight() {
        int mphNumLines = this.getGlobalAttribute("Number_of_Ground_Lines", Integer.MAX_VALUE);
        int sdsNumLines = this.rciImageSds.getDimension(1).getLength();
        this.sceneRasterHeight = Math.min(mphNumLines, sdsNumLines);
        this.globalAttributes.put("Number_of_Ground_Lines", Integer.toString(this.sceneRasterHeight));
    }

    private void determineScanLineLayout() {
        String mode = this.getGlobalAttribute("CHRIS_Mode").substring(0, 1);
        this.scanLineLayout = this.scanLineLayoutMap != null && mode != null && this.scanLineLayoutMap.get(mode) != null ? this.scanLineLayoutMap.get(mode) : new ScanLineLayout(0, this.rciImageSds.getDimension(2).getLength(), 0);
        this.globalAttributes.put("Number_of_Samples", Integer.toString(this.scanLineLayout.imagePixelCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ScanLineLayout> readScanLineLayoutMap() throws IOException {
        InputStream inputStream = ChrisFile.class.getResourceAsStream("scanLineLayout.csv");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        CsvReader csvReader = new CsvReader((Reader)inputStreamReader, new char[]{','}, true, "#");
        try {
            List recordList = csvReader.readStringRecords();
            HashMap<String, ScanLineLayout> scanLineLayoutMap = new HashMap<String, ScanLineLayout>(recordList.size());
            for (String[] record : recordList) {
                int leadingPixelCount = Integer.parseInt(record[1]);
                int imagePixelCount = Integer.parseInt(record[2]);
                int trailingPixelCount = Integer.parseInt(record[3]);
                scanLineLayoutMap.put(record[0], new ScanLineLayout(leadingPixelCount, imagePixelCount, trailingPixelCount));
            }
            HashMap<String, ScanLineLayout> hashMap = scanLineLayoutMap;
            return hashMap;
        }
        finally {
            try {
                csvReader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

