/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.atsr;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.atsr.AtsrBandReader;
import org.esa.s3tbx.dataio.atsr.AtsrFile;
import org.esa.s3tbx.dataio.atsr.AtsrFileFactory;
import org.esa.s3tbx.dataio.atsr.AtsrProductReaderPlugIn;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.StringUtils;

public class AtsrProductReader
extends AbstractProductReader {
    private AtsrFile _file;

    public AtsrProductReader(AtsrProductReaderPlugIn plugin) {
        super((ProductReaderPlugIn)plugin);
    }

    public void close() throws IOException {
        if (this._file != null) {
            this._file.close();
        }
        super.close();
    }

    protected Product readProductNodesImpl() throws IOException {
        AtsrFileFactory factory = AtsrFileFactory.getInstance();
        Object input = this.getInput();
        if (input instanceof String) {
            this._file = factory.open((String)input);
        } else if (input instanceof File) {
            this._file = factory.open((File)input);
        } else if (input instanceof ImageInputStream) {
            this._file = factory.open((ImageInputStream)input, null);
        }
        return this.createProduct();
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AtsrBandReader reader = this._file.getReader(destBand);
        if (reader == null) {
            throw new IOException("No band reader for band '" + destBand.getName() + "' available!");
        }
        reader.readBandData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
    }

    private Product createProduct() {
        String productName = this._file.getFileName();
        productName = StringUtils.createValidName((String)productName, (char[])new char[]{'.', '_'}, (char)'_');
        Product prodRet = new Product(productName, this._file.getSensorType(), 512, 512, (ProductReader)this);
        prodRet.setFileLocation(this._file.getFile());
        if (!this.isMetadataIgnored()) {
            this.addMetadata(prodRet);
            this.addTiePointGrids(prodRet);
            this.addGeoCoding(prodRet);
        }
        this.addBandsToProduct(prodRet);
        this.addActiveFireBitmaskDefs(prodRet);
        return prodRet;
    }

    private void addActiveFireBitmaskDefs(Product prodRet) {
        String nadirBand = "btemp_nadir_370";
        String fwardBand = "btemp_fward_370";
        if (prodRet.containsBand("btemp_nadir_370")) {
            prodRet.addMask("fire_nadir_1", "btemp_nadir_370 > 312.0", "ATSR active fire (ALGO1)", Color.RED, 0.5);
            prodRet.addMask("fire_nadir_2", "btemp_nadir_370 > 308.0", "ATSR active fire (ALGO2)", Color.RED.darker(), 0.5);
        }
        if (prodRet.containsBand("btemp_fward_370")) {
            prodRet.addMask("fire_fward_1", "btemp_fward_370 > 312.0", "ATSR active fire (ALGO1)", Color.RED, 0.5);
            prodRet.addMask("fire_fward_2", "btemp_fward_370 > 308.0", "ATSR active fire (ALGO2)", Color.RED.darker(), 0.5);
        }
    }

    private void addTiePointGrids(Product prodRet) {
        for (int n = 0; n < this._file.getNumTiePointGrids(); ++n) {
            prodRet.addTiePointGrid(this._file.getTiePointGridAt(n));
        }
    }

    private void addMetadata(Product prodRet) {
        this._file.getMetadata(prodRet.getMetadataRoot());
    }

    private void addGeoCoding(Product prodRet) {
        prodRet.setSceneGeoCoding(this._file.getGeoCoding());
    }

    private void addBandsToProduct(Product prodRet) {
        for (int n = 0; n < this._file.getNumBands(); ++n) {
            Band band = this._file.getBandAt(n);
            prodRet.addBand(band);
            FlagCoding flagCoding = band.getFlagCoding();
            if (flagCoding == null) continue;
            prodRet.getFlagCodingGroup().add((ProductNode)flagCoding);
        }
    }
}

