/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.arc;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.media.jai.OpImage;
import org.esa.s3tbx.arc.ArcCoefficientLoader;
import org.esa.s3tbx.arc.ArcCoefficients;
import org.esa.s3tbx.arc.ArcConstants;
import org.esa.s3tbx.arc.ArcFiles;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;
import org.esa.snap.core.util.converters.GeneralExpressionConverter;

@OperatorMetadata(alias="Arc.SST", category="Optical/Thematic Water Processing", authors="Owen Embury, Marco Peters", copyright="University of Reading, Brockmann Consult GmbH", version="0.1", description="Computes sea surface temperature (SST) from (A)ATSR products.")
public class ArcSstOp
extends PixelOperator {
    private Sensor sensor;
    @SourceProduct(alias="source", description="The path of the (A)ATSR source product", label="(A)ATSR source product")
    private Product sourceProduct;
    @Parameter(defaultValue="30.0", label="Total Column Water Vapour", description="TCWV value to use in SST retrieval", converter=GeneralExpressionConverter.class)
    private String tcwvExpression;
    @Parameter(defaultValue="true", label="Generate ASDI", description="Enables/disables generation of ATSR Saharan Dust Index")
    private boolean asdi;
    @Parameter(defaultValue="ASDI_AATSR", label="ASDI coefficient file", description="Coefficient file for ASDI", valueSet={"ASDI_ATSR1", "ASDI_ATSR2", "ASDI_AATSR"})
    private ArcFiles asdiCoefficientsFile;
    @Parameter(defaultValue="", label="ASDI mask", description="ROI-mask used for the ASDI", converter=BooleanExpressionConverter.class)
    private String asdiMaskExpression;
    @Parameter(defaultValue="true", label="Generate dual-view SST", description="Enables/disables generation of the dual-view SST")
    private boolean dual;
    @Parameter(defaultValue="ARC_D2_AATSR", label="Dual-view coefficient file", description="Coefficient file for the dual-view SST", valueSet={"ARC_D2_ATSR1", "ARC_D2_ATSR2", "ARC_D2_AATSR", "ARC_D2_SLSTR", "ARC_D3_ATSR1", "ARC_D3_ATSR2", "ARC_D3_AATSR", "ARC_D3_SLSTR"})
    private ArcFiles dualCoefficientsFile;
    @Parameter(defaultValue="", label="Dual-view mask", description="ROI-mask used for the dual-view SST", converter=BooleanExpressionConverter.class)
    private String dualMaskExpression;
    @Parameter(defaultValue="true", label="Generate nadir-view SST", description="Enables/disables generation of the nadir-view SST")
    private boolean nadir;
    @Parameter(defaultValue="ARC_N2_AATSR", label="Nadir-view coefficient file", description="Coefficient file for the nadir-view SST", valueSet={"ARC_N2_ATSR1", "ARC_N2_ATSR2", "ARC_N2_AATSR", "ARC_N2_SLSTR", "ARC_N3_ATSR1", "ARC_N3_ATSR2", "ARC_N3_AATSR", "ARC_N3_SLSTR"})
    private ArcFiles nadirCoefficientsFile;
    @Parameter(defaultValue="", label="Nadir-view mask", description="ROI-mask used for the nadir-view SST", converter=BooleanExpressionConverter.class)
    private String nadirMaskExpression;
    @Parameter(defaultValue="-999.0f", label="Invalid SST value", description="Value used to fill invalid SST pixels")
    private float invalidSstValue;
    private transient ArcCoefficients coeff1;
    private transient ArcCoefficients coeff2;
    private transient ArcCoefficients coeff3;
    private transient int nadirMaskIndex;
    private transient int dualMaskIndex;
    private transient int asdiMaskIndex;
    private transient int currentPixel = 0;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        double[] coeff;
        double secfwd;
        double secnad;
        this.checkCancellation();
        if (this.sensor.isAtsr()) {
            secnad = 1.0 / Math.cos(Math.toRadians(90.0f - sourceSamples[6].getFloat()));
            secfwd = 1.0 / Math.cos(Math.toRadians(90.0f - sourceSamples[7].getFloat()));
        } else {
            secnad = 1.0 / Math.cos(Math.toRadians(sourceSamples[6].getFloat()));
            secfwd = 1.0 / Math.cos(Math.toRadians(sourceSamples[7].getFloat()));
        }
        float ir37N = sourceSamples[0].getFloat();
        float ir11N = sourceSamples[1].getFloat();
        float ir12N = sourceSamples[2].getFloat();
        float ir37F = sourceSamples[3].getFloat();
        float ir11F = sourceSamples[4].getFloat();
        float ir12F = sourceSamples[5].getFloat();
        float ntcwv = sourceSamples[8].getFloat();
        if (this.nadir) {
            if (this.nadirMaskIndex >= 0 && !sourceSamples[this.nadirMaskIndex].getBoolean()) {
                targetSamples[0].set(this.invalidSstValue);
            } else if ((double)ir11N < 260.0 || (double)ir12N < 260.0) {
                targetSamples[0].set(this.invalidSstValue);
            } else {
                coeff = this.coeff1.get_Coeffs().getValues(new double[]{ntcwv, 1.75, secnad});
                double nadirSst = coeff[0] * (double)ir37N + coeff[1] * (double)ir11N + coeff[2] * (double)ir12N + coeff[6];
                targetSamples[0].set(nadirSst);
            }
        }
        if (this.dual) {
            if (this.dualMaskIndex >= 0 && !sourceSamples[this.dualMaskIndex].getBoolean()) {
                targetSamples[1].set(this.invalidSstValue);
            } else if ((double)ir11N < 260.0 || (double)ir12N < 260.0 || (double)ir11F < 260.0 || (double)ir12F < 260.0) {
                targetSamples[1].set(this.invalidSstValue);
            } else {
                coeff = this.coeff2.get_Coeffs().getValues(new double[]{ntcwv, secfwd, secnad});
                double dualSst = coeff[0] * (double)ir37N + coeff[1] * (double)ir11N + coeff[2] * (double)ir12N + coeff[3] * (double)ir37F + coeff[4] * (double)ir11F + coeff[5] * (double)ir12F + coeff[6];
                targetSamples[1].set(dualSst);
            }
        }
        if (this.asdi) {
            if (this.asdiMaskIndex >= 0 && !sourceSamples[this.asdiMaskIndex].getBoolean()) {
                targetSamples[2].set(this.invalidSstValue);
            } else if ((double)ir11N < 100.0 || (double)ir12N < 100.0 || (double)ir11F < 100.0 || (double)ir12F < 100.0) {
                targetSamples[2].set(this.invalidSstValue);
            } else {
                coeff = this.coeff3.get_Coeffs().getValues(new double[]{ntcwv, secfwd, secnad});
                double asdi = coeff[0] * (double)ir37N + coeff[1] * (double)ir11N + coeff[2] * (double)ir12N + coeff[3] * (double)ir37F + coeff[4] * (double)ir11F + coeff[5] * (double)ir12F + coeff[6];
                targetSamples[2].set(asdi);
            }
        }
    }

    private void checkCancellation() {
        if (this.currentPixel % 1000 == 0) {
            this.checkForCancellation();
            this.currentPixel = 0;
        }
        ++this.currentPixel;
    }

    protected void configureSourceSamples(SourceSampleConfigurer sc) throws OperatorException {
        String[] sourceRasterNames = this.sensor.getRasterNames();
        for (int i = 0; i < sourceRasterNames.length; ++i) {
            sc.defineSample(i, sourceRasterNames[i]);
        }
        if (this.sensor.isAtsr()) {
            sc.defineComputedSample(sourceRasterNames.length, 30, this.tcwvExpression, new Product[0]);
        }
        this.nadirMaskIndex = -1;
        if (this.nadirMaskExpression != null && !this.nadirMaskExpression.trim().isEmpty()) {
            this.nadirMaskIndex = 10;
            sc.defineComputedSample(this.nadirMaskIndex, 20, this.nadirMaskExpression, new Product[0]);
        }
        this.dualMaskIndex = -1;
        if (this.dualMaskExpression != null && !this.dualMaskExpression.trim().isEmpty()) {
            this.dualMaskIndex = 11;
            sc.defineComputedSample(this.dualMaskIndex, 20, this.dualMaskExpression, new Product[0]);
        }
        this.asdiMaskIndex = -1;
        if (this.asdiMaskExpression != null && !this.asdiMaskExpression.trim().isEmpty()) {
            this.asdiMaskIndex = 12;
            sc.defineComputedSample(this.asdiMaskIndex, 20, this.asdiMaskExpression, new Product[0]);
        }
    }

    protected void configureTargetSamples(TargetSampleConfigurer sc) throws OperatorException {
        if (this.nadir) {
            sc.defineSample(0, this.coeff1.getName());
        }
        if (this.dual) {
            sc.defineSample(1, this.coeff2.getName());
        }
        if (this.asdi) {
            sc.defineSample(2, this.coeff3.getName());
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        if (this.nadir) {
            this.createBand(productConfigurer, this.coeff1);
        }
        if (this.dual) {
            this.createBand(productConfigurer, this.coeff2);
        }
        if (this.asdi) {
            this.createBand(productConfigurer, this.coeff3);
        }
    }

    private void createBand(ProductConfigurer productConfigurer, ArcCoefficients coeff) {
        Band nadirSstBand = productConfigurer.addBand(coeff.getName(), 30);
        nadirSstBand.setUnit("K");
        nadirSstBand.setDescription(coeff.getDescription());
        nadirSstBand.setGeophysicalNoDataValue((double)this.invalidSstValue);
        nadirSstBand.setNoDataValueUsed(true);
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.sensor = this.getSensor();
        File auxdataDir = this.installAuxiliaryData();
        this.initNadirCoefficients(auxdataDir);
    }

    private void initNadirCoefficients(File auxdataDir) throws OperatorException {
        ArcCoefficientLoader loader = new ArcCoefficientLoader();
        try {
            if (this.nadir) {
                this.coeff1 = loader.load(new File(auxdataDir, this.nadirCoefficientsFile.getFilename()).toURI().toURL());
            }
            if (this.dual) {
                this.coeff2 = loader.load(new File(auxdataDir, this.dualCoefficientsFile.getFilename()).toURI().toURL());
            }
            if (this.asdi) {
                this.coeff3 = loader.load(new File(auxdataDir, this.asdiCoefficientsFile.getFilename()).toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private File installAuxiliaryData() {
        Path auxDataDir = SystemUtils.getAuxDataPath().resolve("arc").toAbsolutePath();
        Path sourcePath = ResourceInstaller.findModuleCodeBasePath(((Object)((Object)this)).getClass()).resolve("auxdata/arc");
        ResourceInstaller installer = new ResourceInstaller(sourcePath, auxDataDir);
        try {
            installer.install(".*", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        return auxDataDir.toFile();
    }

    private static boolean isMasked(OpImage maskOpImage, int x, int y) {
        int tileY;
        if (maskOpImage == null) {
            return true;
        }
        int tileX = maskOpImage.XToTileX(x);
        Raster tile = maskOpImage.getTile(tileX, tileY = maskOpImage.YToTileY(y));
        return tile.getSample(x, y, 0) != 0;
    }

    private Sensor getSensor() {
        Stream nodeStream = this.getSourceProduct().getRasterDataNodes().stream();
        List rasterNames = nodeStream.map(ProductNode::getName).collect(Collectors.toList());
        if (rasterNames.containsAll(Arrays.asList(Sensor.AATSR.getRasterNames()))) {
            return Sensor.AATSR;
        }
        if (rasterNames.containsAll(Arrays.asList(Sensor.SLSTR.getRasterNames()))) {
            return Sensor.SLSTR;
        }
        throw new OperatorException("The operator can't be applied on the sensor");
    }

    private static enum Sensor {
        AATSR(ArcConstants.SOURCE_RASTER_NAMES_AATSR, true),
        SLSTR(ArcConstants.SOURCE_RASTER_NAMES_SLSTR, false);

        private final String[] bandNames;
        private final boolean atsr;

        public String[] getRasterNames() {
            return this.bandNames;
        }

        public boolean isAtsr() {
            return this.atsr;
        }

        private Sensor(String[] bandNames, boolean atsr) {
            this.bandNames = bandNames;
            this.atsr = atsr;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ArcSstOp.class);
        }
    }
}

