/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.arc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import org.esa.s3tbx.arc.ArcCoefficients;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.math.VectorLookupTable;

public class ArcCoefficientLoader {
    private static final String _nameKey = "name";
    private static final String _descriptionKey = "description";
    private static final String _secnadkey = "secnad";
    private static final String _secfwdkey = "secfwd";
    private static final String _wvbandkey = "wvband";
    private static final String _coeffskey = "coeffs";
    private static final char[] _separators = new char[]{','};
    private Properties _props = new Properties();
    private static final int _numCoeffs = 7;
    private Logger _logger = Logger.getLogger("snap.processor.arc");

    public ArcCoefficients load(URL coeffFile) throws IOException {
        Guardian.assertNotNull((String)"coeffFile", (Object)coeffFile);
        this._logger.fine("Reading coefficient file: '" + coeffFile.getPath() + "'");
        this._props.clear();
        try (InputStream inStream = coeffFile.openStream();){
            this._props.load(inStream);
        }
        String name = this._props.getProperty(_nameKey);
        if (name == null) {
            throw new OperatorException("illegal coefficient file format: name is required");
        }
        this._logger.fine("... coefficients name: '" + name + "'");
        String description = this._props.getProperty(_descriptionKey);
        if (description != null) {
            this._logger.fine("... coefficients description: '" + description + "'");
        } else {
            this._logger.fine("... coefficients have no description");
        }
        String value = this._props.getProperty(_secnadkey);
        double[] secnad = ArcCoefficientLoader.loadCoeffArray(value);
        value = this._props.getProperty(_secfwdkey);
        double[] secfwd = ArcCoefficientLoader.loadCoeffArray(value);
        value = this._props.getProperty(_wvbandkey);
        double[] wvband = ArcCoefficientLoader.loadCoeffArray(value);
        double[][] dimensions = new double[][]{wvband, secfwd, secnad};
        value = this._props.getProperty(_coeffskey);
        double[] lutdata = ArcCoefficientLoader.loadCoeffArray(value);
        VectorLookupTable lut = new VectorLookupTable(7, lutdata, (double[][])dimensions);
        ArcCoefficients coeffs = new ArcCoefficients(name, description, lut);
        this._logger.fine("... success");
        return coeffs;
    }

    public String getDescription(URL coeffFile) throws IOException {
        Guardian.assertNotNull((String)"coeffFile", (Object)coeffFile);
        String desc = "";
        File file = null;
        try {
            file = new File(coeffFile.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (file != null && file.exists() && file.isFile()) {
            FileInputStream inStream = new FileInputStream(file);
            this._props.load(inStream);
            ((InputStream)inStream).close();
            desc = this._props.getProperty(_descriptionKey);
        }
        return desc;
    }

    private static double[] loadCoeffArray(String value) {
        String[] valStrings = StringUtils.split((String)value, (char[])_separators, (boolean)true);
        double[] valDouble = new double[valStrings.length];
        for (int n = 0; n < valStrings.length; ++n) {
            valDouble[n] = Double.parseDouble(valStrings[n]);
        }
        return valDouble;
    }
}

