/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.snap.core.datamodel.MetadataElement;

public class VolumeDescriptorRecord
extends BaseRecord {
    private final String _asciiCodeCharacter;
    private final String _specificationNumber;
    private final String _specificationRevisionNumber;
    private final String _recordFormatRevisionNumer;
    private final String _softwareVersionNumber;
    private final String _logicalVolumeID;
    private final String _volumeSetID;
    private final int _volumeNumberOfThisVolumeDescritorRecord;
    private final int _numberOfFirstFileFollowingTheVolumeDirectoryFile;
    private final int _logicalVolumeNumberInVolumeSet;
    private final String _logicalVolumePreparationDate;
    private final String _logicalVolumePreparationTime;
    private String _logicalVolumePreparationCountry;
    private String _logicalVolumePreparingAgent;
    private String _logicalVolumePreparingFacility;
    private int _numberOfFilepointerRecords;
    private int _numberOfRecords;

    public VolumeDescriptorRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public VolumeDescriptorRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._asciiCodeCharacter = reader.readAn(2);
        reader.skipBytes(2L);
        this._specificationNumber = reader.readAn(12);
        this._specificationRevisionNumber = reader.readAn(2);
        this._recordFormatRevisionNumer = reader.readAn(2);
        this._softwareVersionNumber = reader.readAn(12);
        reader.skipBytes(16L);
        this._logicalVolumeID = reader.readAn(16);
        this._volumeSetID = reader.readAn(16);
        reader.skipBytes(6L);
        this._volumeNumberOfThisVolumeDescritorRecord = (int)reader.readIn(2);
        this._numberOfFirstFileFollowingTheVolumeDirectoryFile = reader.readI4();
        this._logicalVolumeNumberInVolumeSet = reader.readI4();
        reader.skipBytes(4L);
        this._logicalVolumePreparationDate = reader.readAn(8);
        this._logicalVolumePreparationTime = reader.readAn(8);
        this._logicalVolumePreparationCountry = reader.readAn(12);
        this._logicalVolumePreparingAgent = reader.readAn(8);
        this._logicalVolumePreparingFacility = reader.readAn(12);
        this._numberOfFilepointerRecords = reader.readI4();
        this._numberOfRecords = reader.readI4();
        reader.skipBytes(192L);
    }

    public String getAsciiCodeCharacter() {
        return this._asciiCodeCharacter;
    }

    public String getSpecificationNumber() {
        return this._specificationNumber;
    }

    public String getSpecificationRevisionNumber() {
        return this._specificationRevisionNumber;
    }

    public String getRecordFormatRevisionNumer() {
        return this._recordFormatRevisionNumer;
    }

    public String getSoftwareVersionNumber() {
        return this._softwareVersionNumber;
    }

    public String getLogicalVolumeID() {
        return this._logicalVolumeID;
    }

    public String getVolumeSetID() {
        return this._volumeSetID;
    }

    public int getVolumeNumberOfThisVolumeDescritorRecord() {
        return this._volumeNumberOfThisVolumeDescritorRecord;
    }

    public int getNumberOfFirstFileFollowingTheVolumeDirectoryFile() {
        return this._numberOfFirstFileFollowingTheVolumeDirectoryFile;
    }

    public int getLogicalVolumeNumberInVolumeSet() {
        return this._logicalVolumeNumberInVolumeSet;
    }

    public String getLogicalVolumePreparationDate() {
        return this._logicalVolumePreparationDate;
    }

    public String getLogicalVolumePreparationTime() {
        return this._logicalVolumePreparationTime;
    }

    public String getLogicalVolumePreparationCountry() {
        return this._logicalVolumePreparationCountry;
    }

    public String getLogicalVolumePreparingAgent() {
        return this._logicalVolumePreparingAgent;
    }

    public String getLogicalVolumePreparingFacility() {
        return this._logicalVolumePreparingFacility;
    }

    public int getNumberOfFilepointerRecords() {
        return this._numberOfFilepointerRecords;
    }

    public int getNumberOfRecords() {
        return this._numberOfRecords;
    }

    @Override
    public void assignMetadataTo(MetadataElement elem, String suffix) {
        super.assignMetadataTo(elem, suffix);
        elem.setAttributeString("Ascii code character", this._asciiCodeCharacter);
        elem.setAttributeString("Specification number", this._specificationNumber);
        elem.setAttributeString("Specification revision number", this._specificationRevisionNumber);
        elem.setAttributeString("Record format revision number", this._recordFormatRevisionNumer);
        elem.setAttributeString("Software version number", this._softwareVersionNumber);
        elem.setAttributeString("Logical volume ID", this._logicalVolumeID);
        elem.setAttributeString("Volume set ID", this._volumeSetID);
        elem.setAttributeInt("Volume number of this volume descriptor record", this._volumeNumberOfThisVolumeDescritorRecord);
        elem.setAttributeInt("Number of first file following the volume directory file", this._numberOfFirstFileFollowingTheVolumeDirectoryFile);
        elem.setAttributeInt("Logical volume number in volume set", this._logicalVolumeNumberInVolumeSet);
        elem.setAttributeString("Logical volume preparation date", this._logicalVolumePreparationDate);
        elem.setAttributeString("Logical volume preparation time", this._logicalVolumePreparationTime);
        elem.setAttributeString("Logical volume preparation country", this._logicalVolumePreparationCountry);
        elem.setAttributeString("Logical volume preparing agent", this._logicalVolumePreparingAgent);
        elem.setAttributeString("Logical volume preparing facility", this._logicalVolumePreparingFacility);
        elem.setAttributeInt("Number of filepointer records", this._numberOfFilepointerRecords);
        elem.setAttributeInt("Number of records", this._numberOfRecords);
    }
}

