/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;

public class TextRecord
extends BaseRecord {
    private final String _codeCharacter;
    private final String _productID;
    private final String _facility;
    private final String _sceneID;
    private final String _imageFormat;

    public TextRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public TextRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
        this._codeCharacter = reader.readAn(2);
        reader.skipBytes(2L);
        this._productID = reader.readAn(40).trim().substring(8);
        this._facility = reader.readAn(60);
        this._sceneID = reader.readAn(40).trim().substring(6);
        this._imageFormat = reader.readAn(4);
        reader.skipBytes(200L);
    }

    public String getCodeCharacter() {
        return this._codeCharacter;
    }

    public String getProductID() {
        return this._productID;
    }

    public String getFacility() {
        return this._facility;
    }

    public String getSceneID() {
        return this._sceneID;
    }

    public String getImageFormat() {
        return this._imageFormat;
    }
}

