/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

public class BaseRecord {
    private final int _recordNumber;
    private final int _firstRecordSubtype;
    private final int _recordTypeCode;
    private final int _secondRecordSubtype;
    private final int _thirdRecordSubtype;
    private final int _recordLength;
    private final long _startPos;
    private final CeosFileReader _reader;

    public BaseRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        this._reader = reader;
        if (startPos != -1L) {
            this._startPos = startPos;
            reader.seek(startPos);
        } else {
            this._startPos = reader.getCurrentPos();
        }
        this._recordNumber = reader.readB4();
        this._firstRecordSubtype = reader.readB1();
        this._recordTypeCode = reader.readB1();
        this._secondRecordSubtype = reader.readB1();
        this._thirdRecordSubtype = reader.readB1();
        this._recordLength = reader.readB4();
    }

    public int getRecordNumber() {
        return this._recordNumber;
    }

    public int getFirstRecordSubtype() {
        return this._firstRecordSubtype;
    }

    public int getRecordTypeCode() {
        return this._recordTypeCode;
    }

    public int getSecondRecordSubtype() {
        return this._secondRecordSubtype;
    }

    public int getThirdRecordSubtype() {
        return this._thirdRecordSubtype;
    }

    public int getRecordLength() {
        return this._recordLength;
    }

    public long getStartPos() {
        return this._startPos;
    }

    public CeosFileReader getReader() {
        return this._reader;
    }

    public long getAbsolutPosition(long relativePosition) {
        return this.getStartPos() + relativePosition;
    }

    public void assignMetadataTo(MetadataElement elem, String suffix) {
        elem.setAttributeInt("Record number", this._recordNumber);
        elem.setAttributeInt("First record subtype", this._firstRecordSubtype);
        elem.setAttributeInt("Record type code", this._recordTypeCode);
        elem.setAttributeInt("Second record subtype", this._secondRecordSubtype);
        elem.setAttributeInt("Third record subtype", this._thirdRecordSubtype);
        elem.setAttributeInt("Record length", this._recordLength);
    }

    public static void addIntAttributte(MetadataElement elem, String name, int value) {
        ProductData data = ProductData.createInstance((int)10);
        data.setElemInt(value);
        elem.addAttribute(new MetadataAttribute(name, data, true));
    }

    protected final long[] readLongs(int numLongs, int relativePosition) throws IOException, IllegalCeosFormatException {
        this.getReader().seek(this.getAbsolutPosition(relativePosition));
        long[] coeffs = new long[numLongs];
        this.getReader().readB8(coeffs);
        return coeffs;
    }

    protected final long[][] readLongs(int numArrays, int numLongs, int relativePosition) throws IOException, IllegalCeosFormatException {
        long[][] longs = new long[numArrays][];
        this.getReader().seek(this.getAbsolutPosition(relativePosition));
        for (int i = 0; i < longs.length; ++i) {
            long[] coeffs = new long[numLongs];
            this.getReader().readB8(coeffs);
            longs[i] = coeffs;
        }
        return longs;
    }

    protected static MetadataElement createMetadataElement(String name, String suffix) {
        MetadataElement elem = suffix != null && suffix.trim().length() > 0 ? new MetadataElement(name + " " + suffix.trim()) : new MetadataElement(name);
        return elem;
    }
}

