/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.Ancillary2Record;

public class PrismAncillary2Record
extends Ancillary2Record {
    private String _compressionMode;
    private double _ccdTemperature;
    private double _signalProcessingSectionTemperature;
    private double _absoluteCalibrationGain;
    private double _absoluteCalibrationOffset;

    public PrismAncillary2Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public PrismAncillary2Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.seek(this.getAbsolutPosition(62L));
        this._compressionMode = reader.readAn(1);
        reader.seek(this.getAbsolutPosition(78L));
        this._ccdTemperature = reader.readFn(8);
        this._signalProcessingSectionTemperature = reader.readFn(8);
        reader.seek(this.getAbsolutPosition(2702L));
        this._absoluteCalibrationGain = reader.readFn(8);
        this._absoluteCalibrationOffset = reader.readFn(8);
    }

    public String getCompressionMode() {
        return this._compressionMode;
    }

    public double getCcdTemperature() {
        return this._ccdTemperature;
    }

    public double getSignalProcessingSectionTemperature() {
        return this._signalProcessingSectionTemperature;
    }

    public double getAbsoluteCalibrationGain() {
        return this._absoluteCalibrationGain;
    }

    public double getAbsoluteCalibrationOffset() {
        return this._absoluteCalibrationOffset;
    }
}

